/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.apache.camel.tools.apt.helper.JsonSchemaHelper;

public final class DocumentationHelper {
    private DocumentationHelper() {
    }

    public static String findComponentJavaDoc(String scheme, String extendsScheme, String fieldName) {
        File file = DocumentationHelper.jsonFile(scheme, extendsScheme);
        if (file != null) {
            try {
                String json = DocumentationHelper.loadText(file);
                List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("componentProperties", json, true);
                return DocumentationHelper.getPropertyDescription(rows, fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String findEndpointJavaDoc(String scheme, String extendsScheme, String fieldName) {
        File file = DocumentationHelper.jsonFile(scheme, extendsScheme);
        if (file != null) {
            try {
                String json = DocumentationHelper.loadText(file);
                List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
                return DocumentationHelper.getPropertyDescription(rows, fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getPropertyDescription(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String description = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("description")) {
                description = row.get("description");
            }
            if (!found) continue;
            return description;
        }
        return null;
    }

    private static File jsonFile(String scheme, String extendsScheme) {
        if ("file".equals(extendsScheme)) {
            return new File("../camel-file/target/classes/org/apache/camel/component/file/file.json");
        }
        if ("ahc".equals(extendsScheme)) {
            return new File("../camel-ahc/target/classes/org/apache/camel/component/ahc/ahc.json");
        }
        if ("atom".equals(extendsScheme)) {
            return new File("../camel-atom/target/classes/org/apache/camel/component/atom/atom.json");
        }
        if ("ftp".equals(extendsScheme)) {
            return new File("../camel-ftp/target/classes/org/apache/camel/component/file/remote/ftp.json");
        }
        if ("jms".equals(extendsScheme)) {
            return new File("../camel-jms/target/classes/org/apache/camel/component/jms/jms.json");
        }
        if ("sjms".equals(extendsScheme)) {
            return new File("../camel-sjms/target/classes/org/apache/camel/component/sjms/sjms.json");
        }
        if ("http".equals(extendsScheme)) {
            return new File("../camel-http/target/classes/org/apache/camel/component/http/http.json");
        }
        if ("https".equals(extendsScheme)) {
            return new File("../camel-http/target/classes/org/apache/camel/component/http/https.json");
        }
        if ("netty".equals(extendsScheme)) {
            return new File("../camel-netty/target/classes/org/apache/camel/component/netty/netty.json");
        }
        if ("servlet".equals(extendsScheme)) {
            return new File("../camel-servlet/target/classes/org/apache/camel/component/servlet/servlet.json");
        }
        return null;
    }

    private static String loadText(File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        Files.readAllLines(file.toPath()).forEach(line -> {
            builder.append((String)line);
            builder.append("\n");
        });
        return builder.toString();
    }
}

