/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tools.apt.AnnotationProcessorHelper;
import org.apache.camel.tools.apt.Func1;
import org.apache.camel.tools.apt.helper.JsonSchemaHelper;
import org.apache.camel.tools.apt.helper.Strings;

public class CoreEipAnnotationProcessor {
    private static final String ONE_OF_TYPE_NAME = "org.apache.camel.model.ExpressionSubElementDefinition";
    private static final String[] ONE_OF_LANGUAGES = new String[]{"org.apache.camel.model.language.ExpressionDefinition", "org.apache.camel.model.language.NamespaceAwareExpression"};
    private static final String[] ONE_OF_INPUTS = new String[]{"org.apache.camel.model.ProcessorDefinition", "org.apache.camel.model.VerbDefinition"};
    private static final String[] ONE_OF_OUTPUTS = new String[]{"org.apache.camel.model.ProcessorDefinition", "org.apache.camel.model.NoOutputDefinition", "org.apache.camel.model.OutputDefinition", "org.apache.camel.model.ExpressionNode", "org.apache.camel.model.NoOutputExpressionNode", "org.apache.camel.model.SendDefinition", "org.apache.camel.model.InterceptDefinition", "org.apache.camel.model.WhenDefinition", "org.apache.camel.model.ToDynamicDefinition"};
    private static final String[] ONE_OF_VERBS = new String[]{"org.apache.camel.model.rest.VerbDefinition"};
    private boolean skipUnwanted = true;

    protected void processModelClass(final ProcessingEnvironment processingEnv, final RoundEnvironment roundEnv, final TypeElement classElement) {
        String name;
        final String javaTypeName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
        String packageName = javaTypeName.substring(0, javaTypeName.lastIndexOf("."));
        if (classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        if (this.skipUnwanted && classElement.getQualifiedName().toString().equals(ONE_OF_TYPE_NAME)) {
            return;
        }
        final XmlRootElement rootElement = classElement.getAnnotation(XmlRootElement.class);
        if (rootElement == null) {
            return;
        }
        String aName = rootElement.name();
        if (Strings.isNullOrEmpty(aName) || "##default".equals(aName)) {
            XmlType typeElement = classElement.getAnnotation(XmlType.class);
            aName = typeElement.name();
        }
        String fileName = Strings.isNullOrEmpty(name = aName) || "##default".equals(name) ? classElement.getSimpleName().toString() + ".json" : name + ".json";
        Func1<PrintWriter, Void> handler = new Func1<PrintWriter, Void>(){

            @Override
            public Void call(PrintWriter writer) {
                CoreEipAnnotationProcessor.this.writeJSonSchemeDocumentation(processingEnv, writer, roundEnv, classElement, rootElement, javaTypeName, name);
                return null;
            }
        };
        AnnotationProcessorHelper.processFile(processingEnv, packageName, fileName, handler);
    }

    protected void writeJSonSchemeDocumentation(ProcessingEnvironment processingEnv, PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, XmlRootElement rootElement, String javaTypeName, String modelName) {
        EipModel eipModel = this.findEipModelProperties(processingEnv, roundEnv, classElement, javaTypeName, modelName);
        TreeSet<EipOption> eipOptions = new TreeSet<EipOption>(new EipOptionComparator(eipModel));
        this.findClassProperties(processingEnv, writer, roundEnv, eipOptions, classElement, classElement, "", modelName);
        eipModel.setInput(this.hasInput(processingEnv, roundEnv, classElement));
        eipModel.setOutput(this.hasOutput(eipModel, eipOptions));
        String json = this.createParameterJsonSchema(eipModel, eipOptions);
        writer.println(json);
    }

    public String createParameterJsonSchema(EipModel eipModel, Set<EipOption> options) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"model\": {");
        buffer.append("\n    \"kind\": \"").append("model").append("\",");
        buffer.append("\n    \"name\": \"").append(eipModel.getName()).append("\",");
        if (eipModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(eipModel.getTitle()).append("\",");
        } else {
            buffer.append("\n    \"title\": \"").append(CoreEipAnnotationProcessor.asTitle(eipModel.getName())).append("\",");
        }
        buffer.append("\n    \"description\": \"").append(Strings.safeNull(eipModel.getDescription())).append("\",");
        if (eipModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(Strings.safeNull(eipModel.getFirstVersion())).append("\",");
        }
        buffer.append("\n    \"javaType\": \"").append(eipModel.getJavaType()).append("\",");
        buffer.append("\n    \"label\": \"").append(Strings.safeNull(eipModel.getLabel())).append("\",");
        buffer.append("\n    \"deprecated\": ").append(eipModel.isDeprecated()).append(",");
        if (eipModel.getDeprecationNode() != null) {
            buffer.append("\n    \"deprecationNote\": \"").append(Strings.safeNull(eipModel.getDeprecationNode())).append("\",");
        }
        buffer.append("\n    \"input\": ").append(eipModel.getInput()).append(",");
        buffer.append("\n    \"output\": ").append(eipModel.getOutput());
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        boolean first = true;
        if ("false".equals(eipModel.getOutput())) {
            options = options.stream().filter(o -> !"outputs".equals(o.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        for (EipOption entry : options) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc = entry.getDocumentation();
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            buffer.append(JsonSchemaHelper.toJson(entry.getName(), entry.getDisplayName(), entry.getKind(), entry.isRequired(), entry.getType(), entry.getDefaultValue(), doc, entry.isDeprecated(), entry.getDeprecationNode(), false, null, null, entry.isEnumType(), entry.getEnums(), entry.isOneOf(), entry.getOneOfTypes(), entry.isAsPredicate(), null, null, false));
        }
        buffer.append("\n  }");
        buffer.append("\n}\n");
        return buffer.toString();
    }

    protected EipModel findEipModelProperties(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement classElement, String javaTypeName, String name) {
        EipModel model = new EipModel();
        model.setJavaType(javaTypeName);
        model.setName(name);
        boolean deprecated = classElement.getAnnotation(Deprecated.class) != null;
        model.setDeprecated(deprecated);
        Metadata metadata = classElement.getAnnotation(Metadata.class);
        if (metadata != null) {
            if (!Strings.isNullOrEmpty(metadata.label())) {
                model.setLabel(metadata.label());
            }
            if (!Strings.isNullOrEmpty(metadata.title())) {
                model.setTitle(metadata.title());
            }
            if (!Strings.isNullOrEmpty(metadata.firstVersion())) {
                model.setFirstVersion(metadata.firstVersion());
            }
        }
        if (model.getJavaType() != null) {
            String doc;
            Elements elementUtils = processingEnv.getElementUtils();
            TypeElement typeElement = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, model.getJavaType());
            if (typeElement != null && (doc = elementUtils.getDocComment(typeElement)) != null && !Strings.isNullOrEmpty(doc = JsonSchemaHelper.sanitizeDescription(doc, true))) {
                model.setDescription(doc);
            }
        }
        return model;
    }

    protected void findClassProperties(ProcessingEnvironment processingEnv, PrintWriter writer, RoundEnvironment roundEnv, Set<EipOption> eipOptions, TypeElement originalClassType, TypeElement classElement, String prefix, String modelName) {
        while (true) {
            List<VariableElement> fieldElements = ElementFilter.fieldsIn(classElement.getEnclosedElements());
            for (VariableElement fieldElement : fieldElements) {
                XmlElementRef elementRef;
                XmlElement element;
                XmlElements elements;
                boolean skip;
                String fieldName = fieldElement.getSimpleName().toString();
                XmlAttribute attribute = fieldElement.getAnnotation(XmlAttribute.class);
                if (attribute != null && (skip = this.processAttribute(processingEnv, roundEnv, originalClassType, classElement, fieldElement, fieldName, attribute, eipOptions, prefix, modelName))) continue;
                XmlValue value = fieldElement.getAnnotation(XmlValue.class);
                if (value != null) {
                    this.processValue(processingEnv, roundEnv, originalClassType, classElement, fieldElement, fieldName, value, eipOptions, prefix, modelName);
                }
                if ((elements = fieldElement.getAnnotation(XmlElements.class)) != null) {
                    this.processElements(processingEnv, roundEnv, classElement, elements, fieldElement, eipOptions, prefix);
                }
                if ((element = fieldElement.getAnnotation(XmlElement.class)) != null) {
                    this.processElement(processingEnv, roundEnv, classElement, element, fieldElement, eipOptions, prefix);
                }
                if ((elementRef = fieldElement.getAnnotation(XmlElementRef.class)) == null) continue;
                this.processRoutes(roundEnv, originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processOutputs(processingEnv, roundEnv, originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processRefWhenClauses(processingEnv, roundEnv, originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processRests(roundEnv, originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processVerbs(processingEnv, roundEnv, originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processRefExpression(processingEnv, roundEnv, originalClassType, classElement, elementRef, fieldElement, fieldName, eipOptions, prefix);
            }
            if ("OptionalIdentifiedDefinition".equals(classElement.getSimpleName().toString())) {
                this.processIdentified(processingEnv, roundEnv, originalClassType, classElement, eipOptions, prefix);
            } else if ("RouteDefinition".equals(classElement.getSimpleName().toString())) {
                this.processRoute(processingEnv, roundEnv, originalClassType, classElement, eipOptions, prefix);
            }
            TypeElement baseTypeElement = null;
            TypeMirror superclass = classElement.getSuperclass();
            if (superclass != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    private boolean processAttribute(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, VariableElement fieldElement, String fieldName, XmlAttribute attribute, Set<EipOption> eipOptions, String prefix, String modelName) {
        boolean isEnum;
        boolean loadBalancer;
        Elements elementUtils = processingEnv.getElementUtils();
        String name = attribute.name();
        if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
            name = fieldName;
        }
        if (this.skipUnwanted && !(loadBalancer = "LoadBalanceDefinition".equals(originalClassType.getSimpleName().toString())) && "inheritErrorHandler".equals(name)) {
            return true;
        }
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        name = prefix + name;
        TypeMirror fieldType = fieldElement.asType();
        String fieldTypeName = fieldType.toString();
        TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeName);
        String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
        String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
        boolean required = attribute.required();
        required = this.findRequired(fieldElement, required);
        TreeSet<String> enums = new TreeSet<String>();
        if (metadata != null && !Strings.isNullOrEmpty(metadata.enums())) {
            String[] values;
            isEnum = true;
            for (String val : values = metadata.enums().split(",")) {
                enums.add(val);
            }
        } else {
            TypeElement enumClass;
            boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
            if (isEnum && (enumClass = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeElement.asType().toString())) != null) {
                List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                for (VariableElement var : fields) {
                    if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    String val = var.toString();
                    enums.add(val);
                }
            }
        }
        String displayName = null;
        if (metadata != null) {
            displayName = metadata.displayName();
        }
        boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
        String deprecationNote = null;
        if (metadata != null) {
            deprecationNote = metadata.deprecationNode();
        }
        EipOption ep = new EipOption(name, displayName, "attribute", fieldTypeName, required, defaultValue, docComment, deprecated, deprecationNote, isEnum, enums, false, null, false);
        eipOptions.add(ep);
        return false;
    }

    private void processValue(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, VariableElement fieldElement, String fieldName, XmlValue value, Set<EipOption> eipOptions, String prefix, String modelName) {
        Elements elementUtils = processingEnv.getElementUtils();
        String name = fieldName;
        if (("method".equals(modelName) || "tokenize".equals(modelName) || "xtokenize".equals(modelName)) && "expression".equals(name)) {
            return;
        }
        name = prefix + name;
        TypeMirror fieldType = fieldElement.asType();
        String fieldTypeName = fieldType.toString();
        String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
        String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
        boolean required = true;
        required = this.findRequired(fieldElement, required);
        String displayName = null;
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null) {
            displayName = metadata.displayName();
        }
        boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
        String deprecationNote = null;
        if (metadata != null) {
            deprecationNote = metadata.deprecationNode();
        }
        EipOption ep = new EipOption(name, displayName, "value", fieldTypeName, required, defaultValue, docComment, deprecated, deprecationNote, false, null, false, null, false);
        eipOptions.add(ep);
    }

    private void processElement(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement classElement, XmlElement element, VariableElement fieldElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        String fieldName = fieldElement.getSimpleName().toString();
        if (element != null) {
            boolean isEnum;
            boolean asPredicate;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            String kind = "element";
            String name = element.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeName);
            String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
            String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
            boolean required = element.required();
            required = this.findRequired(fieldElement, required);
            boolean bl = asPredicate = fieldElement.getAnnotation(AsPredicate.class) != null;
            if (!asPredicate) {
                asPredicate = classElement.getAnnotation(AsPredicate.class) != null;
            }
            TreeSet<String> enums = new TreeSet<String>();
            if (metadata != null && !Strings.isNullOrEmpty(metadata.enums())) {
                String[] values;
                isEnum = true;
                for (String val : values = metadata.enums().split(",")) {
                    enums.add(val);
                }
            } else {
                TypeElement enumClass;
                boolean bl2 = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                if (isEnum && (enumClass = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, fieldTypeElement.asType().toString())) != null) {
                    List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                    for (VariableElement var : fields) {
                        String val;
                        if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                        val = var.toString();
                        enums.add(val);
                    }
                }
            }
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            boolean isOneOf = ONE_OF_TYPE_NAME.equals(fieldTypeName);
            if (isOneOf) {
                kind = "expression";
                String[] stringArray = ONE_OF_LANGUAGES;
                int var = stringArray.length;
                for (int val = 0; val < var; ++val) {
                    String language;
                    fieldTypeName = language = stringArray[val];
                    TypeElement languages = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, language);
                    if (languages == null) continue;
                    String superClassName = Strings.canonicalClassName(languages.toString());
                    LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
                    AnnotationProcessorHelper.findTypeElementChildren(processingEnv, roundEnv, children, superClassName);
                    for (TypeElement child : children) {
                        XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                        if (rootElement == null) continue;
                        String childName = rootElement.name();
                        oneOfTypes.add(childName);
                    }
                }
            }
            if ("otherwise".equals(name)) {
                isOneOf = true;
                oneOfTypes.add("otherwise");
            }
            String displayName = null;
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNode();
            }
            EipOption ep = new EipOption(name, displayName, kind, fieldTypeName, required, defaultValue, docComment, deprecated, deprecationNote, isEnum, enums, isOneOf, oneOfTypes, asPredicate);
            eipOptions.add(ep);
        }
    }

    private void processElements(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement classElement, XmlElements elements, VariableElement fieldElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        String fieldName = fieldElement.getSimpleName().toString();
        if (elements != null) {
            String kind = "element";
            String name = fieldName;
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
            String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
            boolean required = true;
            required = this.findRequired(fieldElement, required);
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            for (XmlElement element : elements.value()) {
                String child = element.name();
                oneOfTypes.add(child);
            }
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNode();
            }
            EipOption ep = new EipOption(name, displayName, kind, fieldTypeName, required, defaultValue, docComment, deprecated, deprecationNote, false, null, true, oneOfTypes, false);
            eipOptions.add(ep);
        }
    }

    private void processRoute(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "group", null, classElement, true);
        EipOption ep = new EipOption("group", "Group", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "streamCache", null, classElement, true);
        ep = new EipOption("streamCache", "Stream Cache", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "trace", null, classElement, true);
        ep = new EipOption("trace", "Trace", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "messageHistory", null, classElement, true);
        ep = new EipOption("messageHistory", "Message History", "attribute", "java.lang.String", false, "true", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "logMask", null, classElement, true);
        ep = new EipOption("logMask", "Log Mask", "attribute", "java.lang.String", false, "false", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "handleFault", null, classElement, true);
        ep = new EipOption("handleFault", "Handle Fault", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "delayer", null, classElement, true);
        ep = new EipOption("delayer", "Delayer", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "autoStartup", null, classElement, true);
        ep = new EipOption("autoStartup", "Auto Startup", "attribute", "java.lang.String", false, "true", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "startupOrder", null, classElement, true);
        ep = new EipOption("startupOrder", "Startup Order", "attribute", "java.lang.Integer", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "errorHandlerRef", null, classElement, true);
        ep = new EipOption("errorHandlerRef", "Error Handler", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "routePolicyRef", null, classElement, true);
        ep = new EipOption("routePolicyRef", "Route Policy", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        LinkedHashSet<String> enums = new LinkedHashSet<String>();
        enums.add("Default");
        enums.add("Defer");
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "shutdownRoute", "Default", classElement, true);
        ep = new EipOption("shutdownRoute", "Shutdown Route", "attribute", "org.apache.camel.ShutdownRoute", false, "", docComment, false, null, true, enums, false, null, false);
        eipOptions.add(ep);
        enums = new LinkedHashSet();
        enums.add("CompleteCurrentTaskOnly");
        enums.add("CompleteAllTasks");
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "shutdownRunningTask", "CompleteCurrentTaskOnly", classElement, true);
        ep = new EipOption("shutdownRunningTask", "Shutdown Running Task", "attribute", "org.apache.camel.ShutdownRunningTask", false, "", docComment, false, null, true, enums, false, null, false);
        eipOptions.add(ep);
        TreeSet<String> oneOfTypes = new TreeSet<String>();
        oneOfTypes.add("from");
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "inputs", null, classElement, true);
        ep = new EipOption("inputs", "Inputs", "element", "java.util.List<org.apache.camel.model.FromDefinition>", true, "", docComment, false, null, false, null, true, oneOfTypes, false);
        eipOptions.add(ep);
        oneOfTypes = new TreeSet();
        LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
        for (String superclass : ONE_OF_OUTPUTS) {
            AnnotationProcessorHelper.findTypeElementChildren(processingEnv, roundEnv, children, superclass);
        }
        for (TypeElement child : children) {
            XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
            if (rootElement == null) continue;
            String childName = rootElement.name();
            oneOfTypes.add(childName);
        }
        oneOfTypes.remove("route");
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "outputs", null, classElement, true);
        ep = new EipOption("outputs", "Outputs", "element", "java.util.List<org.apache.camel.model.ProcessorDefinition<?>>", true, "", docComment, false, null, false, null, true, oneOfTypes, false);
        eipOptions.add(ep);
    }

    private void processIdentified(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "id", null, classElement, true);
        EipOption ep = new EipOption("id", "Id", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "description", null, classElement, true);
        ep = new EipOption("description", "Description", "element", "org.apache.camel.model.DescriptionDefinition", false, "", docComment, false, null, false, null, false, null, false);
        eipOptions.add(ep);
        if (!this.skipUnwanted) {
            docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, null, "customId", null, classElement, true);
            ep = new EipOption("customId", "Custom Id", "attribute", "java.lang.String", false, "", docComment, false, null, false, null, false, null, false);
            eipOptions.add(ep);
        }
    }

    private void processRoutes(RoundEnvironment roundEnv, TypeElement originalClassType, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        if ("routes".equals(fieldName)) {
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            oneOfTypes.add("route");
            EipOption ep = new EipOption("routes", "Routes", "element", fieldTypeName, false, "", "Contains the Camel routes", false, null, false, null, true, oneOfTypes, false);
            eipOptions.add(ep);
        }
    }

    private void processRests(RoundEnvironment roundEnv, TypeElement originalClassType, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        if ("rests".equals(fieldName)) {
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            oneOfTypes.add("rest");
            EipOption ep = new EipOption("rests", "Rests", "element", fieldTypeName, false, "", "Contains the rest services defined using the rest-dsl", false, null, false, null, true, oneOfTypes, false);
            eipOptions.add(ep);
        }
    }

    private void processOutputs(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        if ("outputs".equals(fieldName) && this.supportOutputs(originalClassType)) {
            String kind = "element";
            String name = elementRef.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
            for (String superclass : ONE_OF_OUTPUTS) {
                AnnotationProcessorHelper.findTypeElementChildren(processingEnv, roundEnv, children, superclass);
            }
            for (TypeElement child : children) {
                XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                if (rootElement == null) continue;
                String childName = rootElement.name();
                oneOfTypes.add(childName);
            }
            oneOfTypes.remove("route");
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNode();
            }
            EipOption ep = new EipOption(name, displayName, kind, fieldTypeName, true, "", "", deprecated, deprecationNote, false, null, true, oneOfTypes, false);
            eipOptions.add(ep);
        }
    }

    private void processVerbs(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        if ("verbs".equals(fieldName) && this.supportOutputs(originalClassType)) {
            String kind = "element";
            String name = elementRef.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, originalClassType, true);
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
            for (String superclass : ONE_OF_VERBS) {
                AnnotationProcessorHelper.findTypeElementChildren(processingEnv, roundEnv, children, superclass);
            }
            for (TypeElement child : children) {
                String childName;
                XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                if (rootElement == null || (childName = rootElement.name()) == null) continue;
                oneOfTypes.add(childName);
            }
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNode();
            }
            EipOption ep = new EipOption(name, displayName, kind, fieldTypeName, true, "", docComment, deprecated, deprecationNote, false, null, true, oneOfTypes, false);
            eipOptions.add(ep);
        }
    }

    private void processRefExpression(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        if ("expression".equals(fieldName)) {
            boolean asPredicate;
            String kind = "expression";
            String name = elementRef.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, originalClassType, true);
            boolean bl = asPredicate = fieldElement.getAnnotation(AsPredicate.class) != null;
            if (!asPredicate) {
                boolean bl2 = asPredicate = classElement.getAnnotation(AsPredicate.class) != null;
            }
            if (!asPredicate) {
                asPredicate = originalClassType.getAnnotation(AsPredicate.class) != null;
            }
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            for (String language : ONE_OF_LANGUAGES) {
                TypeElement languages = AnnotationProcessorHelper.findTypeElement(processingEnv, roundEnv, language);
                String superClassName = Strings.canonicalClassName(languages.toString());
                LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
                AnnotationProcessorHelper.findTypeElementChildren(processingEnv, roundEnv, children, superClassName);
                for (TypeElement child : children) {
                    XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                    if (rootElement == null) continue;
                    String childName = rootElement.name();
                    oneOfTypes.add(childName);
                }
            }
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNode();
            }
            EipOption ep = new EipOption(name, displayName, kind, fieldTypeName, true, "", docComment, deprecated, deprecationNote, false, null, true, oneOfTypes, asPredicate);
            eipOptions.add(ep);
        }
    }

    private void processRefWhenClauses(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement originalClassType, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = processingEnv.getElementUtils();
        if ("whenClauses".equals(fieldName)) {
            String kind = "element";
            String name = elementRef.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, originalClassType, true);
            HashSet<String> oneOfTypes = new HashSet<String>();
            oneOfTypes.add("when");
            boolean asPredicate = true;
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNode();
            }
            EipOption ep = new EipOption(name, displayName, kind, fieldTypeName, false, "", docComment, deprecated, deprecationNote, false, null, true, oneOfTypes, asPredicate);
            eipOptions.add(ep);
        }
    }

    private boolean supportOutputs(TypeElement classElement) {
        String superclass = Strings.canonicalClassName(classElement.getSuperclass().toString());
        return !"org.apache.camel.model.NoOutputExpressionNode".equals(superclass);
    }

    private String findDefaultValue(VariableElement fieldElement, String fieldTypeName) {
        String defaultValue = null;
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null && !Strings.isNullOrEmpty(metadata.defaultValue())) {
            defaultValue = metadata.defaultValue();
        }
        if (defaultValue == null && ("boolean".equals(fieldTypeName) || "java.lang.Boolean".equals(fieldTypeName))) {
            defaultValue = "false";
        }
        return defaultValue;
    }

    private boolean findRequired(VariableElement fieldElement, boolean defaultValue) {
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null && !Strings.isNullOrEmpty(metadata.required())) {
            defaultValue = "true".equals(metadata.required());
        }
        return defaultValue;
    }

    private static String asTitle(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            boolean first;
            boolean upper = Character.isUpperCase(c);
            boolean bl = first = sb.length() == 0;
            if (first) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (upper) {
                sb.append(' ');
                sb.append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString().trim();
    }

    private boolean hasInput(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, TypeElement classElement) {
        for (String name : ONE_OF_INPUTS) {
            if (!AnnotationProcessorHelper.hasSuperClass(processingEnv, roundEnv, classElement, name)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOutput(EipModel model, Set<EipOption> options) {
        if ("route".equals(model.getName()) || "rest".equals(model.getName())) {
            return true;
        }
        if ("policy".equals(model.getName()) || "transacted".equals(model.getName())) {
            return false;
        }
        for (EipOption option : options) {
            if (!"outputs".equals(option.getName())) continue;
            return true;
        }
        return false;
    }

    private static final class EipOptionComparator
    implements Comparator<EipOption> {
        private final EipModel model;

        private EipOptionComparator(EipModel model) {
            this.model = model;
        }

        @Override
        public int compare(EipOption o1, EipOption o2) {
            int weigth2;
            int weigth = this.weigth(o1);
            if (weigth == (weigth2 = this.weigth(o2))) {
                return 1;
            }
            return weigth2 - weigth;
        }

        private int weigth(EipOption o) {
            String name = o.getName();
            if ("expression".equals(name)) {
                return 10;
            }
            if ("description".equals(name)) {
                return -10;
            }
            if ("id".equals(name)) {
                return -9;
            }
            if ("pattern".equals(name) && "to".equals(this.model.getName())) {
                return -8;
            }
            return 0;
        }
    }

    private static final class EipOption {
        private String name;
        private String displayName;
        private String kind;
        private String type;
        private boolean required;
        private String defaultValue;
        private String documentation;
        private boolean deprecated;
        private String deprecationNode;
        private boolean enumType;
        private Set<String> enums;
        private boolean oneOf;
        private Set<String> oneOfTypes;
        private boolean asPredicate;

        private EipOption(String name, String displayName, String kind, String type, boolean required, String defaultValue, String documentation, boolean deprecated, String deprecationNode, boolean enumType, Set<String> enums, boolean oneOf, Set<String> oneOfTypes, boolean asPredicate) {
            this.name = name;
            this.displayName = displayName;
            this.kind = kind;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.documentation = documentation;
            this.deprecated = deprecated;
            this.deprecationNode = deprecationNode;
            this.enumType = enumType;
            this.enums = enums;
            this.oneOf = oneOf;
            this.oneOfTypes = oneOfTypes;
            this.asPredicate = asPredicate;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getKind() {
            return this.kind;
        }

        public String getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getDeprecationNode() {
            return this.deprecationNode;
        }

        public boolean isEnumType() {
            return this.enumType;
        }

        public Set<String> getEnums() {
            return this.enums;
        }

        public boolean isOneOf() {
            return this.oneOf;
        }

        public Set<String> getOneOfTypes() {
            return this.oneOfTypes;
        }

        public boolean isAsPredicate() {
            return this.asPredicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EipOption that = (EipOption)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class EipModel {
        private String name;
        private String title;
        private String javaType;
        private String label;
        private String description;
        private boolean deprecated;
        private String deprecationNode;
        private boolean input;
        private boolean output;
        private String firstVersion;

        private EipModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public String getDeprecationNode() {
            return this.deprecationNode;
        }

        public void setDeprecationNode(String deprecationNode) {
            this.deprecationNode = deprecationNode;
        }

        public boolean isInput() {
            return this.input;
        }

        public void setInput(boolean input) {
            this.input = input;
        }

        public String getInput() {
            return this.input ? "true" : "false";
        }

        public boolean isOutput() {
            return this.output;
        }

        public void setOutput(boolean output) {
            this.output = output;
        }

        public String getOutput() {
            return this.output ? "true" : "false";
        }

        public String getFirstVersion() {
            return this.firstVersion;
        }

        public void setFirstVersion(String firstVersion) {
            this.firstVersion = firstVersion;
        }
    }
}

