/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.util.ImmutableIntList;

public class Version
implements Comparable<Version> {
    private static final Ordering<Iterable<Integer>> ORDERING = Ordering.natural().lexicographical();
    public final List<Integer> integers;
    public final String string;

    private Version(List<Integer> integers, String string) {
        this.integers = ImmutableList.copyOf(integers);
        this.string = string;
    }

    public static Version of(String s) {
        String[] strings = s.split("[.-]");
        ArrayList<Integer> integers = new ArrayList<Integer>();
        for (String string : strings) {
            try {
                integers.add(Integer.parseInt(string));
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        return new Version(integers, s);
    }

    public static Version of(int ... integers) {
        return new Version((List<Integer>)ImmutableIntList.copyOf((int[])integers), "");
    }

    @Override
    public int compareTo(Version version) {
        return ORDERING.compare(this.integers, version.integers);
    }
}

