/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicFunction;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.TableCharacteristic;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Optionality;

public class MockSqlOperatorTable
extends ChainedSqlOperatorTable {
    private static final SqlFunction HIGHER_ORDER_FUNCTION = SqlBasicFunction.create((String)"HIGHER_ORDER_FUNCTION", (SqlReturnTypeInference)ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.sequence((String)"HIGHER_ORDER_FUNCTION(INTEGER, FUNCTION(STRING, ANY) -> NUMERIC)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER}), OperandTypes.function((SqlTypeFamily)SqlTypeFamily.NUMERIC, (SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.ANY})}), (SqlFunctionCategory)SqlFunctionCategory.SYSTEM);
    private static final SqlFunction HIGHER_ORDER_FUNCTION2 = SqlBasicFunction.create((String)"HIGHER_ORDER_FUNCTION2", (SqlReturnTypeInference)ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.sequence((String)"HIGHER_ORDER_FUNCTION(INTEGER, FUNCTION() -> NUMERIC)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER}), OperandTypes.function((SqlTypeFamily)SqlTypeFamily.NUMERIC, (SqlTypeFamily[])new SqlTypeFamily[0])}), (SqlFunctionCategory)SqlFunctionCategory.SYSTEM);

    private MockSqlOperatorTable(SqlOperatorTable parentTable) {
        super(ImmutableList.of((Object)parentTable));
    }

    public static MockSqlOperatorTable standard() {
        return MockSqlOperatorTable.of((SqlOperatorTable)SqlStdOperatorTable.instance());
    }

    public static MockSqlOperatorTable of(SqlOperatorTable operatorTable) {
        return new MockSqlOperatorTable(operatorTable);
    }

    public MockSqlOperatorTable extend() {
        SqlOperatorTable parentTable = (SqlOperatorTable)Iterables.getOnlyElement((Iterable)this.tableList);
        return new MockSqlOperatorTable(SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{parentTable, SqlOperatorTables.of((SqlOperator[])new SqlOperator[]{new RampFunction(), new DedupFunction(), new MyFunction(), new MyAvgAggFunction(), new RowFunction(), new NotATableFunction(), new BadTableFunction(), new StructuredFunction(), new CompositeFunction(), new ScoreTableFunction(), new TopNTableFunction(), new SimilarlityTableFunction(), new InvalidTableFunction(), new CompareStringsOrNumericValues(), HIGHER_ORDER_FUNCTION, HIGHER_ORDER_FUNCTION2})}));
    }

    public MockSqlOperatorTable plus(Iterable<SqlLibrary> librarySet) {
        SqlOperatorTable parentTable = (SqlOperatorTable)Iterables.getOnlyElement((Iterable)this.tableList);
        return new MockSqlOperatorTable(SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{parentTable, SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(librarySet)}));
    }

    public static class CompareStringsOrNumericValues
    extends SqlFunction {
        public CompareStringsOrNumericValues() {
            super("COMPARE_STRINGS_OR_NUMERIC_VALUES", new SqlIdentifier("COMPARE_STRINGS_OR_NUMERIC_VALUES", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME.or(OperandTypes.NUMERIC_NUMERIC.and(OperandTypes.SAME_SAME)), SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class CompositeFunction
    extends SqlFunction {
        public CompositeFunction() {
            super("COMPOSITE", new SqlIdentifier("COMPOSITE", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)1)).or(OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)2))), SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    public static class StructuredFunction
    extends SqlFunction {
        StructuredFunction() {
            super("STRUCTURED_FUNC", new SqlIdentifier("STRUCTURED_FUNC", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NILADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType bigintType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            RelDataType varcharType = typeFactory.createSqlType(SqlTypeName.VARCHAR, 20);
            return typeFactory.builder().add("F0", bigintType).add("F1", varcharType).build();
        }
    }

    public static class RowFunction
    extends SqlFunction
    implements SqlTableFunction {
        RowFunction() {
            super("ROW_FUNC", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.NILADIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        private static RelDataType inferRowType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType bigintType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            return typeFactory.builder().add("NOT_NULL_FIELD", bigintType).add("NULLABLE_FIELD", bigintType).nullable(true).build();
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return RowFunction::inferRowType;
        }
    }

    public static class MyAvgAggFunction
    extends SqlAggFunction {
        public MyAvgAggFunction() {
            super("MYAGG", null, SqlKind.AVG, ReturnTypes.AVG_AGG_FUNCTION, null, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC}), SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
        }

        public boolean isDeterministic() {
            return false;
        }
    }

    public static class MapFunction
    extends SqlFunction {
        public MapFunction() {
            super("MAP", new SqlIdentifier("MAP", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING}), SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.VARCHAR));
        }
    }

    public static class SplitFunction
    extends SqlFunction {
        public SplitFunction() {
            super("SPLIT", new SqlIdentifier("SPLIT", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING}), SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.VARCHAR), -1L);
        }
    }

    public static class MyAggFunc
    extends SqlAggFunction {
        public MyAggFunc() {
            super("myAggFunc", null, SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, null, OperandTypes.ONE_OR_MORE, SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.FORBIDDEN);
        }
    }

    public static class MyFunction
    extends SqlFunction {
        public MyFunction() {
            super("MYFUN", new SqlIdentifier("MYFUN", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    public static class InvalidTableFunction
    extends SqlFunction
    implements SqlTableFunction {
        private final Map<Integer, TableCharacteristic> tableParams = ImmutableMap.of((Object)0, (Object)TableCharacteristic.builder((TableCharacteristic.Semantics)TableCharacteristic.Semantics.ROW).passColumnsThrough().build(), (Object)1, (Object)TableCharacteristic.builder((TableCharacteristic.Semantics)TableCharacteristic.Semantics.ROW).passColumnsThrough().build());

        public InvalidTableFunction() {
            super("INVALID", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> opBinding.getTypeFactory().builder().add("NAME", SqlTypeName.VARCHAR, 1024).build();
        }

        public TableCharacteristic tableCharacteristic(int ordinal) {
            return this.tableParams.get(ordinal);
        }

        public boolean argumentMustBeScalar(int ordinal) {
            return !this.tableParams.containsKey(ordinal);
        }
    }

    public static class SimilarlityTableFunction
    extends SqlFunction
    implements SqlTableFunction {
        private final Map<Integer, TableCharacteristic> tableParams = ImmutableMap.of((Object)0, (Object)TableCharacteristic.builder((TableCharacteristic.Semantics)TableCharacteristic.Semantics.SET).build(), (Object)1, (Object)TableCharacteristic.builder((TableCharacteristic.Semantics)TableCharacteristic.Semantics.SET).build());

        public SimilarlityTableFunction() {
            super("SIMILARLITY", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)new OperandMetadataImpl(), SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> opBinding.getTypeFactory().builder().add("VAL", SqlTypeName.DECIMAL, 5, 2).build();
        }

        public TableCharacteristic tableCharacteristic(int ordinal) {
            return this.tableParams.get(ordinal);
        }

        public boolean argumentMustBeScalar(int ordinal) {
            return !this.tableParams.containsKey(ordinal);
        }

        private static class OperandMetadataImpl
        implements SqlOperandMetadata {
            private OperandMetadataImpl() {
            }

            public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
                return ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.ANY), (Object)typeFactory.createSqlType(SqlTypeName.ANY));
            }

            public List<String> paramNames() {
                return ImmutableList.of((Object)"LTABLE", (Object)"RTABLE");
            }

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return true;
            }

            public SqlOperandCountRange getOperandCountRange() {
                return SqlOperandCountRanges.of((int)2);
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return "SIMILARITY(TABLE table_name, TABLE table_name)";
            }
        }
    }

    public static class TopNTableFunction
    extends SqlFunction
    implements SqlTableFunction {
        private final Map<Integer, TableCharacteristic> tableParams = ImmutableMap.of((Object)0, (Object)TableCharacteristic.builder((TableCharacteristic.Semantics)TableCharacteristic.Semantics.SET).passColumnsThrough().pruneIfEmpty().build());

        public TopNTableFunction() {
            super("TOPN", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)new OperandMetadataImpl(), SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        private static RelDataType inferRowType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType inputRowType = opBinding.getOperandType(0);
            RelDataType bigintType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            return typeFactory.builder().kind(inputRowType.getStructKind()).addAll((Iterable)inputRowType.getFieldList()).add("RANK_NUMBER", bigintType).nullable(true).build();
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return TopNTableFunction::inferRowType;
        }

        public TableCharacteristic tableCharacteristic(int ordinal) {
            return this.tableParams.get(ordinal);
        }

        public boolean argumentMustBeScalar(int ordinal) {
            return !this.tableParams.containsKey(ordinal);
        }

        private static class OperandMetadataImpl
        implements SqlOperandMetadata {
            private OperandMetadataImpl() {
            }

            public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
                return ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.ANY), (Object)typeFactory.createSqlType(SqlTypeName.INTEGER));
            }

            public List<String> paramNames() {
                return ImmutableList.of((Object)"DATA", (Object)"COL");
            }

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                SqlNode operand1 = callBinding.operand(1);
                SqlValidator validator = callBinding.getValidator();
                RelDataType type = validator.getValidatedNodeType(operand1);
                if (!SqlTypeUtil.isIntType((RelDataType)type)) {
                    if (throwOnFailure) {
                        throw callBinding.newValidationSignatureError();
                    }
                    return false;
                }
                return true;
            }

            public SqlOperandCountRange getOperandCountRange() {
                return SqlOperandCountRanges.of((int)2);
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return "TopN(TABLE table_name, BIGINT rows)";
            }
        }
    }

    public static class ScoreTableFunction
    extends SqlFunction
    implements SqlTableFunction {
        private final Map<Integer, TableCharacteristic> tableParams = ImmutableMap.of((Object)0, (Object)TableCharacteristic.builder((TableCharacteristic.Semantics)TableCharacteristic.Semantics.ROW).passColumnsThrough().build());

        public ScoreTableFunction() {
            super("SCORE", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)new OperandMetadataImpl(), SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        private static RelDataType inferRowType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType inputRowType = opBinding.getOperandType(0);
            RelDataType bigintType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            return typeFactory.builder().kind(inputRowType.getStructKind()).addAll((Iterable)inputRowType.getFieldList()).add("SCORE_VALUE", bigintType).nullable(true).build();
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return ScoreTableFunction::inferRowType;
        }

        public TableCharacteristic tableCharacteristic(int ordinal) {
            return this.tableParams.get(ordinal);
        }

        public boolean argumentMustBeScalar(int ordinal) {
            return !this.tableParams.containsKey(ordinal);
        }

        private static class OperandMetadataImpl
        implements SqlOperandMetadata {
            private OperandMetadataImpl() {
            }

            public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
                return ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.ANY));
            }

            public List<String> paramNames() {
                return ImmutableList.of((Object)"DATA");
            }

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return true;
            }

            public SqlOperandCountRange getOperandCountRange() {
                return SqlOperandCountRanges.of((int)1);
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return "Score(TABLE table_name)";
            }
        }
    }

    public static class DedupFunction
    extends SqlFunction
    implements SqlTableFunction {
        public DedupFunction() {
            super("DEDUP", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> opBinding.getTypeFactory().builder().add("NAME", SqlTypeName.VARCHAR, 1024).build();
        }
    }

    public static class BadTableFunction
    extends SqlFunction
    implements SqlTableFunction {
        public BadTableFunction() {
            super("BAD_TABLE_FUNCTION", SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getTypeFactory().builder().add("I", SqlTypeName.INTEGER).build();
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return this::inferReturnType;
        }
    }

    public static class NotATableFunction
    extends SqlFunction {
        public NotATableFunction() {
            super("BAD_RAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }
    }

    public static class DynamicTypeFunction
    extends SqlFunction
    implements SqlTableFunction {
        public DynamicTypeFunction() {
            super("RAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> opBinding.getTypeFactory().builder().add("I", SqlTypeName.INTEGER).build();
        }
    }

    public static class RampFunction
    extends SqlFunction
    implements SqlTableFunction {
        public RampFunction() {
            super("RAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        }

        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> opBinding.getTypeFactory().builder().add("I", SqlTypeName.INTEGER).build();
        }
    }
}

