/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.server;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.server.AbstractModifiableTable;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

class MutableArrayTable
extends AbstractModifiableTable
implements Wrapper {
    final List rows = new ArrayList();
    private final RelProtoDataType protoRowType;
    private final InitializerExpressionFactory initializerExpressionFactory;

    MutableArrayTable(String name, RelProtoDataType protoStoredRowType, RelProtoDataType protoRowType, InitializerExpressionFactory initializerExpressionFactory) {
        super(name);
        Objects.requireNonNull(protoStoredRowType, "protoStoredRowType");
        this.protoRowType = Objects.requireNonNull(protoRowType, "protoRowType");
        this.initializerExpressionFactory = Objects.requireNonNull(initializerExpressionFactory, "initializerExpressionFactory");
    }

    public Collection getModifiableCollection() {
        return this.rows;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

            public Enumerator<T> enumerator() {
                return Linq4j.enumerator((Collection)MutableArrayTable.this.rows);
            }
        };
    }

    public Type getElementType() {
        return Object[].class;
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply((Object)typeFactory);
    }

    public <C> @Nullable C unwrap(Class<C> aClass) {
        if (aClass.isInstance(this.initializerExpressionFactory)) {
            return aClass.cast(this.initializerExpressionFactory);
        }
        return (C)super.unwrap(aClass);
    }
}

