/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.redis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Objects;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisJedisManager
implements AutoCloseable {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private final LoadingCache<String, JedisPool> jedisPoolCache;
    private final JedisPoolConfig jedisPoolConfig;
    private final String host;
    private final String password;
    private final int port;
    private final int database;

    public RedisJedisManager(String host, int port, int database, String password) {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(8);
        jedisPoolConfig.setMaxIdle(8);
        jedisPoolConfig.setMinIdle(0);
        this.host = host;
        this.port = port;
        this.database = database;
        this.password = password;
        this.jedisPoolConfig = jedisPoolConfig;
        this.jedisPoolCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new JedisPoolRemovalListener()).build(CacheLoader.from(this::createConsumer));
    }

    public JedisPool getJedisPool() {
        Objects.requireNonNull(this.host, "host is null");
        return (JedisPool)this.jedisPoolCache.getUnchecked((Object)this.host);
    }

    public Jedis getResource() {
        return this.getJedisPool().getResource();
    }

    private JedisPool createConsumer() {
        String pwd = this.password;
        if (StringUtils.isEmpty((CharSequence)pwd)) {
            pwd = null;
        }
        return new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, this.host, this.port, 2000, pwd, this.database);
    }

    @Override
    public void close() {
        this.jedisPoolCache.invalidateAll();
    }

    private static class JedisPoolRemovalListener
    implements RemovalListener<String, JedisPool> {
        private JedisPoolRemovalListener() {
        }

        public void onRemoval(RemovalNotification<String, JedisPool> notification) {
            JedisPool value = (JedisPool)Objects.requireNonNull(notification.getValue());
            try {
                value.destroy();
            }
            catch (Exception e) {
                LOGGER.warn("While destroying JedisPool {}", notification.getKey());
            }
        }
    }
}

