/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.chinook;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.jdbc.JdbcMeta;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.server.AvaticaProtobufHandler;
import org.apache.calcite.avatica.server.HttpServer;
import org.apache.calcite.avatica.server.Main;
import org.apache.calcite.chinook.CalciteConnectionProvider;

public class ChinookAvaticaServer {
    private HttpServer server;

    public void startWithCalcite() throws Exception {
        String[] args = new String[]{CalciteChinookMetaFactory.class.getName()};
        this.server = Main.start((String[])args, (int)0, AvaticaProtobufHandler::new);
    }

    public void startWithRaw() throws Exception {
        String[] args = new String[]{RawChinookMetaFactory.class.getName()};
        this.server = Main.start((String[])args, (int)0, AvaticaProtobufHandler::new);
    }

    public String getURL() {
        return "jdbc:avatica:remote:url=http://localhost:" + this.server.getPort() + ";serialization=" + Driver.Serialization.PROTOBUF.name();
    }

    public void stop() {
        this.server.stop();
    }

    public static class RawChinookMetaFactory
    implements Meta.Factory {
        private static volatile JdbcMeta instance = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static JdbcMeta getInstance() {
            if (instance != null) return instance;
            Class<RawChinookMetaFactory> clazz = RawChinookMetaFactory.class;
            synchronized (RawChinookMetaFactory.class) {
                if (instance != null) return instance;
                try {
                    instance = new JdbcMeta("jdbc:hsqldb:res:chinook", "CHINOOK", "CHINOOK");
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                return instance;
            }
        }

        public Meta create(List<String> args) {
            return RawChinookMetaFactory.getInstance();
        }
    }

    public static class CalciteChinookMetaFactory
    implements Meta.Factory {
        private static final CalciteConnectionProvider CONNECTION_PROVIDER = new CalciteConnectionProvider();
        private static volatile JdbcMeta instance = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static JdbcMeta getInstance() {
            if (instance != null) return instance;
            Class<CalciteChinookMetaFactory> clazz = CalciteChinookMetaFactory.class;
            synchronized (CalciteChinookMetaFactory.class) {
                try {
                    instance = new JdbcMeta("jdbc:calcite:", CONNECTION_PROVIDER.provideConnectionInfo());
                }
                catch (IOException | SQLException e) {
                    throw new RuntimeException(e);
                }
                return instance;
            }
        }

        public Meta create(List<String> args) {
            return CalciteChinookMetaFactory.getInstance();
        }
    }
}

