/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.os.AbstractBaseScannableTable;
import org.apache.calcite.adapter.os.Processes;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VmstatTableFunction {
    private VmstatTableFunction() {
    }

    public static ScannableTable eval(boolean b) {
        return new AbstractBaseScannableTable(){

            public Enumerable<@Nullable Object[]> scan(DataContext root) {
                String[] args;
                RelDataType rowType = this.getRowType((RelDataTypeFactory)root.getTypeFactory());
                ImmutableList fieldNames = ImmutableList.copyOf((Collection)rowType.getFieldNames());
                String osName = System.getProperty("os.name");
                String osVersion = System.getProperty("os.version");
                Util.discard((Object)osVersion);
                switch (osName) {
                    case "Mac OS X": {
                        args = new String[]{"/bin/sh", "-c", "vm_stat | tail -n +2 | awk '{print $NF}' | sed 's/\\.//' | tr '\\n' ' '"};
                        break;
                    }
                    default: {
                        args = new String[]{"/bin/sh", "-c", "vmstat -n | tail -n +3"};
                    }
                }
                return Processes.processLines(args).select((Function1)new Function1<String, Object[]>((List)fieldNames){
                    final /* synthetic */ List val$fieldNames;
                    {
                        this.val$fieldNames = list;
                    }

                    public Object[] apply(String line) {
                        String[] fields = line.trim().split("\\s+");
                        Object[] values = new Object[this.val$fieldNames.size()];
                        for (int i = 0; i < values.length; ++i) {
                            try {
                                values[i] = this.field((String)this.val$fieldNames.get(i), fields[i]);
                                continue;
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace(System.out);
                                throw new RuntimeException("while parsing value [" + fields[i] + "] of field [" + (String)this.val$fieldNames.get(i) + "] in line [" + line + "]");
                            }
                        }
                        return values;
                    }

                    private Object field(String field, String value) {
                        if (value.isEmpty()) {
                            return 0;
                        }
                        if (value.endsWith(".")) {
                            return Long.parseLong(value);
                        }
                        return Long.parseLong(value);
                    }
                });
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                String osName = System.getProperty("os.name");
                RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
                switch (osName) {
                    case "Mac OS X": {
                        return builder.add("pages_free", SqlTypeName.BIGINT).add("pages_active", SqlTypeName.BIGINT).add("pages_inactive", SqlTypeName.BIGINT).add("pages_speculative", SqlTypeName.BIGINT).add("pages_throttled", SqlTypeName.BIGINT).add("pages_wired_down", SqlTypeName.BIGINT).add("pages_purgeable", SqlTypeName.BIGINT).add("translation_faults", SqlTypeName.BIGINT).add("pages_copy_on_write", SqlTypeName.BIGINT).add("pages_zero_filed", SqlTypeName.BIGINT).add("pages_reactivated", SqlTypeName.BIGINT).add("pages_purged", SqlTypeName.BIGINT).add("pages_file_backed", SqlTypeName.BIGINT).add("pages_anonymous", SqlTypeName.BIGINT).add("pages_stored_compressor", SqlTypeName.BIGINT).add("pages_occupied_compressor", SqlTypeName.BIGINT).add("decompressions", SqlTypeName.BIGINT).add("compressions", SqlTypeName.BIGINT).add("pageins", SqlTypeName.BIGINT).add("pageouts", SqlTypeName.BIGINT).add("swapins", SqlTypeName.BIGINT).add("swapouts", SqlTypeName.BIGINT).build();
                    }
                }
                return builder.add("proc_r", SqlTypeName.BIGINT).add("proc_b", SqlTypeName.BIGINT).add("mem_swpd", SqlTypeName.BIGINT).add("mem_free", SqlTypeName.BIGINT).add("mem_buff", SqlTypeName.BIGINT).add("mem_cache", SqlTypeName.BIGINT).add("swap_si", SqlTypeName.BIGINT).add("swap_so", SqlTypeName.BIGINT).add("io_bi", SqlTypeName.BIGINT).add("io_bo", SqlTypeName.BIGINT).add("system_in", SqlTypeName.BIGINT).add("system_cs", SqlTypeName.BIGINT).add("cpu_us", SqlTypeName.BIGINT).add("cpu_sy", SqlTypeName.BIGINT).add("cpu_id", SqlTypeName.BIGINT).add("cpu_wa", SqlTypeName.BIGINT).add("cpu_st", SqlTypeName.BIGINT).build();
            }
        };
    }
}

