/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;

public class Processes {
    private Processes() {
    }

    static Enumerable<String> processLines(String ... args) {
        return Processes.processLines(' ', args);
    }

    static Enumerable<String> processLines(char sep, String ... args) {
        return Processes.processLines(sep, Processes.processSupplier(args));
    }

    private static Enumerable<String> processLines(char sep, Supplier<Process> processSupplier) {
        if (sep != ' ') {
            return new SeparatedLinesEnumerable(processSupplier, sep);
        }
        return new ProcessLinesEnumerator(processSupplier);
    }

    private static Supplier<Process> processSupplier(String ... args) {
        return new ProcessFactory(args);
    }

    private static class ProcessFactory
    implements Supplier<Process> {
        private final String[] args;

        ProcessFactory(String ... args) {
            this.args = args;
        }

        @Override
        public Process get() {
            try {
                return new ProcessBuilder(new String[0]).command(this.args).start();
            }
            catch (IOException e) {
                throw new RuntimeException("while creating process: " + Arrays.toString(this.args), e);
            }
        }

        public String toString() {
            return this.args[0];
        }
    }

    private static class SeparatedLinesEnumerable
    extends AbstractEnumerable<String> {
        private final Supplier<Process> processSupplier;
        private final int sep;

        SeparatedLinesEnumerable(Supplier<Process> processSupplier, char sep) {
            this.processSupplier = processSupplier;
            this.sep = sep;
        }

        public Enumerator<String> enumerator() {
            final Process process = this.processSupplier.get();
            InputStream is = process.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            InputStreamReader isr = new InputStreamReader((InputStream)bis, StandardCharsets.UTF_8);
            final BufferedReader br = new BufferedReader(isr);
            return new Enumerator<String>(){
                private final StringBuilder b = new StringBuilder();
                private String line;

                public String current() {
                    return this.line;
                }

                public boolean moveNext() {
                    try {
                        while (true) {
                            int c;
                            if ((c = br.read()) < 0) {
                                return false;
                            }
                            if (c == sep) {
                                this.line = this.b.toString();
                                this.b.setLength(0);
                                return true;
                            }
                            this.b.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void reset() {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("while running " + processSupplier, e);
                    }
                    process.destroy();
                }
            };
        }
    }

    private static class ProcessLinesEnumerator
    extends AbstractEnumerable<String> {
        private final Supplier<Process> processSupplier;

        ProcessLinesEnumerator(Supplier<Process> processSupplier) {
            this.processSupplier = Objects.requireNonNull(processSupplier, "processSupplier");
        }

        public Enumerator<String> enumerator() {
            final Process process = this.processSupplier.get();
            InputStream is = process.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            InputStreamReader isr = new InputStreamReader((InputStream)bis, StandardCharsets.UTF_8);
            final BufferedReader br = new BufferedReader(isr);
            return new Enumerator<String>(){
                private String line;

                public String current() {
                    return this.line;
                }

                public boolean moveNext() {
                    try {
                        this.line = br.readLine();
                        return this.line != null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void reset() {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("while running " + processSupplier, e);
                    }
                    process.destroy();
                }
            };
        }
    }
}

