/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.calcite.piglet.PigRelBuilder;
import org.apache.calcite.piglet.PigRelSqlUdfs;
import org.apache.calcite.piglet.PigUdfFinder;
import org.apache.calcite.piglet.PigUserDefinedFunction;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.pig.Accumulator;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;

class PigRelUdfConverter {
    private static final PigUdfFinder PIG_UDF_FINDER = new PigUdfFinder();
    private static final Map<String, SqlOperator> BUILTIN_FUNC = ImmutableMap.builder().put((Object)"org.apache.pig.builtin.ABS", (Object)SqlStdOperatorTable.ABS).put((Object)"org.apache.pig.builtin.BigDecimalAbs", (Object)SqlStdOperatorTable.ABS).put((Object)"org.apache.pig.builtin.BigIntegerAbs", (Object)SqlStdOperatorTable.ABS).put((Object)"org.apache.pig.builtin.DoubleAbs", (Object)SqlStdOperatorTable.ABS).put((Object)"org.apache.pig.builtin.FloatAbs", (Object)SqlStdOperatorTable.ABS).put((Object)"org.apache.pig.builtin.IntAbs", (Object)SqlStdOperatorTable.ABS).put((Object)"org.apache.pig.builtin.LongAbs", (Object)SqlStdOperatorTable.ABS).put((Object)"org.apache.pig.builtin.CEIL", (Object)SqlStdOperatorTable.CEIL).put((Object)"org.apache.pig.builtin.CONCAT", (Object)SqlStdOperatorTable.CONCAT).put((Object)"org.apache.pig.builtin.StringConcat", (Object)SqlStdOperatorTable.CONCAT).put((Object)"org.apache.pig.builtin.EXP", (Object)SqlStdOperatorTable.EXP).put((Object)"org.apache.pig.builtin.FLOOR", (Object)SqlStdOperatorTable.FLOOR).put((Object)"org.apache.pig.builtin.LOG", (Object)SqlStdOperatorTable.LN).put((Object)"org.apache.pig.builtin.LOG10", (Object)SqlStdOperatorTable.LOG10).put((Object)"org.apache.pig.builtin.LOWER", (Object)SqlStdOperatorTable.LOWER).put((Object)"org.apache.pig.builtin.RANDOM", (Object)SqlStdOperatorTable.RAND).put((Object)"org.apache.pig.builtin.SQRT", (Object)SqlStdOperatorTable.SQRT).put((Object)"org.apache.pig.builtin.StringSize", (Object)SqlStdOperatorTable.CHAR_LENGTH).put((Object)"org.apache.pig.builtin.SUBSTRING", (Object)SqlStdOperatorTable.SUBSTRING).put((Object)"org.apache.pig.builtin.TOTUPLE", (Object)SqlStdOperatorTable.ROW).put((Object)"org.apache.pig.builtin.UPPER", (Object)SqlStdOperatorTable.UPPER).build();
    private static final Map<String, SqlAggFunction> BUILTIN_AGG_FUNC = ImmutableMap.builder().put((Object)"org.apache.pig.builtin.AVG", (Object)SqlStdOperatorTable.AVG).put((Object)"org.apache.pig.builtin.BigDecimalAvg", (Object)SqlStdOperatorTable.AVG).put((Object)"org.apache.pig.builtin.BigIntegerAvg", (Object)SqlStdOperatorTable.AVG).put((Object)"org.apache.pig.builtin.DoubleAvg", (Object)SqlStdOperatorTable.AVG).put((Object)"org.apache.pig.builtin.FloatAvg", (Object)SqlStdOperatorTable.AVG).put((Object)"org.apache.pig.builtin.IntAvg", (Object)SqlStdOperatorTable.AVG).put((Object)"org.apache.pig.builtin.LongAvg", (Object)SqlStdOperatorTable.AVG).put((Object)"org.apache.pig.builtin.COUNT", (Object)SqlStdOperatorTable.COUNT).put((Object)"org.apache.pig.builtin.MAX", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.BigDecimalMax", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.BigIntegerMax", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.DateTimeMax", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.DoubleMax", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.FloatMax", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.IntMax", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.LongMax", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.StringMax", (Object)SqlStdOperatorTable.MAX).put((Object)"org.apache.pig.builtin.MIN", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.BigDecimalMin", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.BigIntegerMin", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.DateTimeMin", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.DoubleMin", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.FloatMin", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.IntMin", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.LongMin", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.StringMin", (Object)SqlStdOperatorTable.MIN).put((Object)"org.apache.pig.builtin.BigDecimalSum", (Object)SqlStdOperatorTable.SUM).put((Object)"org.apache.pig.builtin.BigIntegerSum", (Object)SqlStdOperatorTable.SUM).put((Object)"org.apache.pig.builtin.DoubleSum", (Object)SqlStdOperatorTable.SUM).put((Object)"org.apache.pig.builtin.FloatSum", (Object)SqlStdOperatorTable.SUM).put((Object)"org.apache.pig.builtin.IntSum", (Object)SqlStdOperatorTable.SUM).put((Object)"org.apache.pig.builtin.LongSum", (Object)SqlStdOperatorTable.SUM).build();

    private PigRelUdfConverter() {
    }

    static RexNode convertPigFunction(PigRelBuilder builder, FuncSpec pigFunc, ImmutableList<RexNode> operands, RelDataType returnType) throws FrontendException {
        SqlOperator operator = BUILTIN_FUNC.get(pigFunc.getClassName());
        if (operator != null) {
            return builder.call(operator, (Iterable)operands);
        }
        try {
            Class<?> clazz = Class.forName(pigFunc.getClassName());
            Method method = PIG_UDF_FINDER.findPigUdfImplementationMethod(clazz);
            SqlUserDefinedFunction convertOp = Accumulator.class.isAssignableFrom(clazz) ? PigRelSqlUdfs.createPigBagUDF(operands) : PigRelSqlUdfs.createPigTupleUDF(operands);
            RexNode rexTuple = builder.call((SqlOperator)convertOp, (Iterable)operands);
            SqlUserDefinedFunction userFuncOp = PigRelSqlUdfs.createGeneralPigUdf(clazz.getSimpleName(), method, pigFunc, rexTuple.getType(), returnType);
            return builder.call((SqlOperator)userFuncOp, (Iterable)ImmutableList.of((Object)rexTuple));
        }
        catch (ClassNotFoundException e) {
            throw new FrontendException("Cannot find the implementation for Pig UDF class: " + pigFunc.getClassName());
        }
    }

    static SqlAggFunction getSqlAggFuncForPigUdf(RexCall call) {
        if (!(call.getOperator() instanceof PigUserDefinedFunction)) {
            return null;
        }
        PigUserDefinedFunction pigUdf = (PigUserDefinedFunction)call.getOperator();
        if (pigUdf.funcSpec != null) {
            Class<?> udfClass;
            String pigUdfClassName = pigUdf.funcSpec.getClassName();
            SqlAggFunction sqlAggFunction = BUILTIN_AGG_FUNC.get(pigUdfClassName);
            if (sqlAggFunction == null && Accumulator.class.isAssignableFrom(udfClass = ((ScalarFunctionImpl)pigUdf.getFunction()).method.getDeclaringClass())) {
                throw new UnsupportedOperationException("Cannot find corresponding SqlAgg func for Pig aggegate " + pigUdfClassName);
            }
            return sqlAggFunction;
        }
        return null;
    }
}

