/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

public class PigRelToSqlConverter
extends RelToSqlConverter {
    PigRelToSqlConverter(SqlDialect dialect) {
        super(dialect);
    }

    public SqlImplementor.Result visit(Aggregate e) {
        boolean isProjectOutput = e.getInput() instanceof Project || e.getInput() instanceof EnumerableInterpreter && ((EnumerableInterpreter)e.getInput()).getInput() instanceof Project;
        SqlImplementor.Result x = this.visitInput((RelNode)e, 0, this.isAnon(), isProjectOutput, (Set)ImmutableSet.of((Object)SqlImplementor.Clause.GROUP_BY));
        SqlImplementor.Builder builder = x.builder((RelNode)e);
        Expressions.FluentList groupByList = Expressions.list();
        ArrayList selectList = new ArrayList();
        this.buildAggGroupList(e, builder, (List)groupByList, selectList);
        int groupSetSize = e.getGroupSets().size();
        SqlNodeList groupBy = new SqlNodeList((Collection)groupByList, POS);
        if (groupSetSize > 1) {
            Expressions.FluentList cubeRollupList = Expressions.list();
            if (groupSetSize == groupByList.size() + 1) {
                cubeRollupList.add(SqlStdOperatorTable.ROLLUP.createCall(groupBy));
            } else {
                assert ((long)groupSetSize == Math.round(Math.pow(2.0, groupByList.size())));
                cubeRollupList.add(SqlStdOperatorTable.CUBE.createCall(groupBy));
            }
            groupBy = new SqlNodeList((Collection)cubeRollupList, POS);
        }
        return this.buildAggregate(e, builder, selectList, (List)groupBy).result();
    }

    public SqlImplementor.Result visit(Window e) {
        SqlImplementor.Result x = this.visitInput((RelNode)e, 0, new SqlImplementor.Clause[]{SqlImplementor.Clause.SELECT});
        SqlImplementor.Builder builder = x.builder((RelNode)e);
        ArrayList<SqlCall> selectList = new ArrayList<SqlCall>(builder.context.fieldList());
        for (Window.Group winGroup : e.groups) {
            Expressions.FluentList partitionList = Expressions.list();
            Iterator iterator = winGroup.keys.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                partitionList.add(builder.context.field(i));
            }
            Expressions.FluentList orderList = Expressions.list();
            for (RelFieldCollation orderKey : winGroup.collation().getFieldCollations()) {
                orderList.add(builder.context.toSql(orderKey));
            }
            SqlNode lowerBound = builder.context.toSql(winGroup.lowerBound);
            SqlNode upperBound = builder.context.toSql(winGroup.upperBound);
            if (orderList.isEmpty() && !winGroup.isRows) {
                upperBound = null;
                lowerBound = null;
            }
            SqlWindow sqlWindow = SqlWindow.create(null, null, (SqlNodeList)new SqlNodeList((Collection)partitionList, POS), (SqlNodeList)new SqlNodeList((Collection)orderList, POS), (SqlLiteral)SqlLiteral.createBoolean((boolean)winGroup.isRows, (SqlParserPos)POS), (SqlNode)lowerBound, (SqlNode)upperBound, null, (SqlLiteral)builder.context.toSql(winGroup.exclude), (SqlParserPos)POS);
            for (Window.RexWinAggCall winFunc : winGroup.aggCalls) {
                Expressions.FluentList winFuncOperands = Expressions.list();
                for (RexNode operand : winFunc.getOperands()) {
                    winFuncOperands.add(builder.context.toSql(null, operand));
                }
                SqlCall aggFunc = winFunc.getOperator().createCall(new SqlNodeList((Collection)winFuncOperands, POS));
                selectList.add(SqlStdOperatorTable.OVER.createCall(POS, new SqlNode[]{aggFunc, sqlWindow}));
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
        }
        return builder.result();
    }
}

