/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableList;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.piglet.PigRelBuilder;
import org.apache.calcite.piglet.PigRelExVisitor;
import org.apache.calcite.piglet.PigRelOpInnerVisitor;
import org.apache.calcite.piglet.PigRelOpWalker;
import org.apache.calcite.piglet.PigTable;
import org.apache.calcite.piglet.PigTypes;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlRankFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.pig.builtin.CubeDimensions;
import org.apache.pig.builtin.RollupDimensions;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.LinkedMultiMap;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LOCube;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

class PigRelOpVisitor
extends PigRelOpWalker.PlanPreVisitor {
    protected final PigRelBuilder builder;
    private Operator currentRoot;

    PigRelOpVisitor(OperatorPlan plan, PlanWalker walker, PigRelBuilder builder) throws FrontendException {
        super(plan, walker);
        if (!(walker instanceof PigRelOpWalker)) {
            throw new FrontendException("Expected PigRelOpWalker", 2223);
        }
        this.builder = builder;
        this.currentRoot = null;
    }

    Operator getCurrentRoot() {
        return this.currentRoot;
    }

    List<RelNode> translate() throws FrontendException {
        ArrayList<RelNode> relNodes = new ArrayList<RelNode>();
        Iterator iterator = this.plan.getSinks().iterator();
        while (iterator.hasNext()) {
            Operator pigOp;
            this.currentRoot = pigOp = (Operator)iterator.next();
            this.currentWalker.walk((PlanVisitor)this);
            if (pigOp instanceof LOStore) continue;
            relNodes.add(this.builder.build());
        }
        return relNodes;
    }

    public void visit(LOLoad load) throws FrontendException {
        RelOptTable pigRelOptTable;
        String fullName = load.getSchemaFile();
        if (fullName.contains("file://")) {
            fullName = Paths.get(load.getSchemaFile(), new String[0]).getFileName().toString();
        }
        String[] tableNames = fullName.startsWith("/") ? new String[]{fullName} : fullName.split("\\.");
        LogicalSchema pigSchema = load.getSchema();
        if (pigSchema == null) {
            pigRelOptTable = null;
        } else {
            RelDataType rowType = PigTypes.convertSchema(pigSchema);
            pigRelOptTable = PigTable.createRelOptTable(this.builder.getRelOptSchema(), rowType, Arrays.asList(tableNames));
        }
        this.builder.scan(pigRelOptTable, tableNames);
        this.builder.register((LogicalRelationalOperator)load);
    }

    public void visit(LOFilter filter) throws FrontendException {
        RexNode relExFilter = PigRelExVisitor.translatePigEx(this.builder, filter.getFilterPlan());
        this.builder.filter(new RexNode[]{relExFilter});
        this.builder.register((LogicalRelationalOperator)filter);
    }

    public void visit(LOForEach foreach) throws FrontendException {
        PigRelOpWalker innerWalker = new PigRelOpWalker((OperatorPlan)foreach.getInnerPlan());
        PigRelOpInnerVisitor innerVisitor = new PigRelOpInnerVisitor((OperatorPlan)foreach.getInnerPlan(), innerWalker, this.builder);
        RelNode root = innerVisitor.translate().get(0);
        this.builder.push(root);
        this.builder.register((LogicalRelationalOperator)foreach);
    }

    public void visit(LOCogroup loCogroup) throws FrontendException {
        GroupType groupType = PigRelOpVisitor.getGroupType(loCogroup);
        if (groupType == GroupType.REGULAR) {
            this.processRegularGroup(loCogroup);
        } else {
            this.processCube(groupType, loCogroup);
        }
        this.projectGroup(loCogroup.getExpressionPlans().get((Object)0).size());
        this.builder.register((LogicalRelationalOperator)loCogroup);
    }

    private void projectGroup(int groupCount) {
        RexInputRef groupRex;
        List inputFields = this.builder.peek().getRowType().getFieldList();
        if (groupCount == 1) {
            groupRex = this.builder.field(0);
        } else {
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<RelDataType> fieldTypes = new ArrayList<RelDataType>();
            ArrayList<RexInputRef> fieldRexes = new ArrayList<RexInputRef>();
            for (int j = 0; j < groupCount; ++j) {
                fieldTypes.add(((RelDataTypeField)inputFields.get(j)).getType());
                fieldNames.add(((RelDataTypeField)inputFields.get(j)).getName());
                fieldRexes.add(this.builder.field(j));
            }
            RelDataType groupDataType = PigTypes.TYPE_FACTORY.createStructType(fieldTypes, fieldNames);
            groupRex = this.builder.getRexBuilder().makeCall(groupDataType, (SqlOperator)SqlStdOperatorTable.ROW, fieldRexes);
        }
        ArrayList<RexInputRef> outputFields = new ArrayList<RexInputRef>();
        ArrayList<String> outputNames = new ArrayList<String>();
        outputFields.add(groupRex);
        outputNames.add("group");
        for (int i = groupCount; i < inputFields.size(); ++i) {
            outputFields.add(this.builder.field(i));
            outputNames.add(((RelDataTypeField)inputFields.get(i)).getName());
        }
        this.builder.project(outputFields, outputNames, true);
    }

    private void processRegularGroup(LOCogroup loCogroup) throws FrontendException {
        ArrayList<RelBuilder.GroupKey> groupKeys = new ArrayList<RelBuilder.GroupKey>();
        int numRels = loCogroup.getExpressionPlans().size();
        this.preprocessCogroup(loCogroup, false);
        for (Integer key : loCogroup.getExpressionPlans().keySet()) {
            int groupCount = loCogroup.getExpressionPlans().get((Object)key).size();
            ArrayList<RexInputRef> relKeys = new ArrayList<RexInputRef>();
            for (int i = 0; i < groupCount; ++i) {
                relKeys.add(this.builder.field(numRels - key, 0, i));
            }
            groupKeys.add(this.builder.groupKey(relKeys));
        }
        this.builder.cogroup(groupKeys);
    }

    private void processCube(GroupType groupType, LOCogroup loCogroup) throws FrontendException {
        assert (loCogroup.getExpressionPlans().size() == 1);
        this.adjustCubeInput();
        this.preprocessCogroup(loCogroup, true);
        ImmutableList.Builder groupsetBuilder = new ImmutableList.Builder();
        ArrayList<Integer> keyIndexs = new ArrayList<Integer>();
        groupsetBuilder.add((Object)ImmutableBitSet.of(keyIndexs));
        int groupCount = loCogroup.getExpressionPlans().get((Object)0).size();
        for (int i = groupCount - 1; i >= 0; --i) {
            keyIndexs.add(i);
            groupsetBuilder.add((Object)ImmutableBitSet.of(keyIndexs));
        }
        ImmutableBitSet groupSet = ImmutableBitSet.of(keyIndexs);
        ImmutableList groupSets = groupType == GroupType.CUBE ? ImmutableList.copyOf((Iterable)groupSet.powerSet()) : groupsetBuilder.build();
        RelBuilder.GroupKey groupKey = this.builder.groupKey(groupSet, (Iterable)groupSets);
        this.builder.cogroup((Iterable<? extends RelBuilder.GroupKey>)ImmutableList.of((Object)groupKey));
    }

    private void adjustCubeInput() {
        RelNode project1 = this.builder.peek();
        assert (project1 instanceof LogicalProject);
        RelNode correl = ((LogicalProject)project1).getInput();
        assert (correl instanceof LogicalCorrelate);
        RelNode project2 = ((LogicalCorrelate)correl).getLeft();
        assert (project2 instanceof LogicalProject);
        this.builder.replaceTop(((LogicalProject)project2).getInput());
    }

    private void preprocessCogroup(LOCogroup loCogroup, boolean isCubeRollup) throws FrontendException {
        int i;
        int numRels = loCogroup.getExpressionPlans().size();
        ArrayList<RelNode> inputRels = new ArrayList<RelNode>();
        for (i = 0; i < numRels; ++i) {
            inputRels.add(0, this.builder.build());
        }
        for (i = 0; i < numRels; ++i) {
            RelNode originalRel = (RelNode)inputRels.get(i);
            this.builder.push(originalRel);
            List pigGroupKeys = loCogroup.getExpressionPlans().get((Object)i);
            ArrayList<RexNode> fieldRels = new ArrayList<RexNode>();
            for (LogicalExpressionPlan pigKey : pigGroupKeys) {
                fieldRels.add(PigRelExVisitor.translatePigEx(this.builder, pigKey));
            }
            RexNode row = this.builder.getRexBuilder().makeCall(this.getGroupRowType(fieldRels, isCubeRollup), (SqlOperator)SqlStdOperatorTable.ROW, this.getGroupRowOperands(fieldRels, isCubeRollup));
            fieldRels.add(row);
            this.builder.project(fieldRels);
            this.builder.updateAlias(this.builder.getPig(originalRel), this.builder.getAlias(originalRel), false);
        }
    }

    private RelDataType getGroupRowType(List<RexNode> groupFields, boolean isCubeRollup) {
        if (isCubeRollup) {
            List rowFields = this.builder.peek().getRowType().getFieldList();
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<RelDataType> fieldTypes = new ArrayList<RelDataType>();
            ArrayList<Integer> groupColIndexes = new ArrayList<Integer>();
            for (RexNode rex : groupFields) {
                assert (rex instanceof RexInputRef);
                int colIndex = ((RexInputRef)rex).getIndex();
                groupColIndexes.add(colIndex);
                fieldNames.add(((RelDataTypeField)rowFields.get(colIndex)).getName());
                fieldTypes.add(((RelDataTypeField)rowFields.get(colIndex)).getType());
            }
            for (int i = 0; i < rowFields.size(); ++i) {
                if (groupColIndexes.contains(i)) continue;
                fieldNames.add(((RelDataTypeField)rowFields.get(i)).getName());
                fieldTypes.add(((RelDataTypeField)rowFields.get(i)).getType());
            }
            return PigTypes.TYPE_FACTORY.createStructType(fieldTypes, fieldNames);
        }
        return this.builder.peek().getRowType();
    }

    private List<RexNode> getGroupRowOperands(List<RexNode> fieldRels, boolean isCubeRollup) {
        ImmutableList rowFields = this.builder.fields();
        if (isCubeRollup) {
            ArrayList<RexNode> cubeRowFields = new ArrayList<RexNode>(fieldRels);
            for (RexNode field : rowFields) {
                if (cubeRowFields.contains(field)) continue;
                cubeRowFields.add(field);
            }
            return ImmutableList.copyOf(cubeRowFields);
        }
        return rowFields;
    }

    private static GroupType getGroupType(LOCogroup pigGroup) {
        LogicalExpressionPlan exPlan;
        LOGenerate generate;
        List projectList;
        LOForEach foreach;
        Operator input;
        if (pigGroup.getInputs((LogicalPlan)pigGroup.getPlan()).size() == 1 && (input = (Operator)pigGroup.getInputs((LogicalPlan)pigGroup.getPlan()).get(0)) instanceof LOForEach && (foreach = (LOForEach)input).getInnerPlan().getSinks().size() == 1 && (projectList = (generate = (LOGenerate)foreach.getInnerPlan().getSinks().get(0)).getOutputPlans()).size() > 1 && (exPlan = (LogicalExpressionPlan)projectList.get(0)).getSources().size() == 1 && exPlan.getSources().get(0) instanceof UserFuncExpression) {
            UserFuncExpression func = (UserFuncExpression)exPlan.getSources().get(0);
            if (func.getFuncSpec().getClassName().equals(CubeDimensions.class.getName())) {
                return GroupType.CUBE;
            }
            if (func.getFuncSpec().getClassName().equals(RollupDimensions.class.getName())) {
                return GroupType.ROLLUP;
            }
        }
        return GroupType.REGULAR;
    }

    public void visit(LOLimit loLimit) {
        this.builder.limit(0, (int)loLimit.getLimit());
        this.builder.register((LogicalRelationalOperator)loLimit);
    }

    public void visit(LOSort loSort) throws FrontendException {
        long limit = loSort.getLimit();
        ArrayList<Object> relSortCols = new ArrayList<Object>();
        if (loSort.isStar()) {
            RelNode top = this.builder.peek();
            for (RelDataTypeField field : top.getRowType().getFieldList()) {
                relSortCols.add(this.builder.field(field.getIndex()));
            }
        } else {
            assert (loSort.getSortColPlans().size() == loSort.getAscendingCols().size());
            for (int i = 0; i < loSort.getSortColPlans().size(); ++i) {
                RexNode sortColsNoDirection = PigRelExVisitor.translatePigEx(this.builder, (LogicalExpressionPlan)loSort.getSortColPlans().get(i));
                if (!((Boolean)loSort.getAscendingCols().get(i)).booleanValue()) {
                    relSortCols.add(this.builder.desc(sortColsNoDirection));
                    continue;
                }
                relSortCols.add(sortColsNoDirection);
            }
        }
        this.builder.sortLimit(-1, limit, relSortCols);
        this.builder.register((LogicalRelationalOperator)loSort);
    }

    public void visit(LOJoin join) throws FrontendException {
        this.joinInternal((MultiMap<Integer, LogicalExpressionPlan>)join.getExpressionPlans(), join.getInnerFlags());
        LogicalJoin joinRel = (LogicalJoin)this.builder.peek();
        HashSet duplicateNames = new HashSet(joinRel.getLeft().getRowType().getFieldNames());
        duplicateNames.retainAll(joinRel.getRight().getRowType().getFieldNames());
        if (!duplicateNames.isEmpty()) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<RexInputRef> fields = new ArrayList<RexInputRef>();
            for (RelDataTypeField leftField : joinRel.getLeft().getRowType().getFieldList()) {
                fieldNames.add(this.builder.getAlias(joinRel.getLeft()) + "::" + leftField.getName());
                fields.add(this.builder.field(leftField.getIndex()));
            }
            int leftCount = joinRel.getLeft().getRowType().getFieldList().size();
            for (RelDataTypeField rightField : joinRel.getRight().getRowType().getFieldList()) {
                fieldNames.add(this.builder.getAlias(joinRel.getRight()) + "::" + rightField.getName());
                fields.add(this.builder.field(rightField.getIndex() + leftCount));
            }
            this.builder.project(fields, fieldNames);
        }
        this.builder.register((LogicalRelationalOperator)join);
    }

    public void visit(LOCross loCross) throws FrontendException {
        int numInputs = loCross.getInputs().size();
        LinkedMultiMap joinPlans = new LinkedMultiMap();
        boolean[] innerFlags = new boolean[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            joinPlans.put((Object)i, Collections.emptyList());
            innerFlags[i] = true;
        }
        this.joinInternal((MultiMap<Integer, LogicalExpressionPlan>)joinPlans, innerFlags);
        this.builder.register((LogicalRelationalOperator)loCross);
    }

    private void joinInternal(MultiMap<Integer, LogicalExpressionPlan> joinPlans, boolean[] innerFlags) throws FrontendException {
        int i;
        int numRels = joinPlans.size();
        ArrayList<RelNode> joinRels = new ArrayList<RelNode>();
        for (i = 0; i < numRels; ++i) {
            joinRels.add(0, this.builder.build());
        }
        for (i = 0; i < numRels; ++i) {
            this.builder.push((RelNode)joinRels.get(i));
            if (i == 0) continue;
            ArrayList<RexNode> predicates = new ArrayList<RexNode>();
            List leftJoinExprs = joinPlans.get((Object)(i - 1));
            List rightJoinExprs = joinPlans.get((Object)i);
            assert (leftJoinExprs.size() == rightJoinExprs.size());
            for (int j = 0; j < leftJoinExprs.size(); ++j) {
                RexNode leftRelExpr = PigRelExVisitor.translatePigEx(this.builder, (LogicalExpressionPlan)leftJoinExprs.get(j), 2, 0);
                RexNode rightRelExpr = PigRelExVisitor.translatePigEx(this.builder, (LogicalExpressionPlan)rightJoinExprs.get(j), 2, 1);
                predicates.add(this.builder.equals(leftRelExpr, rightRelExpr));
            }
            this.builder.join(PigRelOpVisitor.getJoinType(innerFlags[i - 1], innerFlags[i]), this.builder.and(predicates));
        }
    }

    private static JoinRelType getJoinType(boolean leftInner, boolean rightInner) {
        if (leftInner && rightInner) {
            return JoinRelType.INNER;
        }
        if (leftInner) {
            return JoinRelType.LEFT;
        }
        if (rightInner) {
            return JoinRelType.RIGHT;
        }
        return JoinRelType.FULL;
    }

    public void visit(LOUnion loUnion) throws FrontendException {
        int i;
        LogicalSchema unionSchema = loUnion.getSchema();
        if (unionSchema == null) {
            throw new IllegalArgumentException("UNION on incompatible types is not supported. Please consider using ONSCHEMA option");
        }
        int numInputs = loUnion.getInputs().size();
        RelDataType unionRelType = PigTypes.convertSchema(unionSchema);
        ArrayList<RelNode> adjustedInputs = new ArrayList<RelNode>();
        for (i = 0; i < numInputs; ++i) {
            adjustedInputs.add(this.builder.project(this.builder.build(), unionRelType));
        }
        for (i = numInputs - 1; i >= 0; --i) {
            this.builder.push((RelNode)adjustedInputs.get(i));
        }
        this.builder.union(true, numInputs);
        this.builder.register((LogicalRelationalOperator)loUnion);
    }

    public void visit(LODistinct loDistinct) {
        this.builder.distinct();
        this.builder.register((LogicalRelationalOperator)loDistinct);
    }

    public void visit(LOCube cube) throws FrontendException {
        throw new FrontendException("Cube should be translated into group by Pig parser", 10000);
    }

    public void visit(LOInnerLoad load) throws FrontendException {
        throw new FrontendException("Not implemented", 10000);
    }

    public void visit(LOSplit loSplit) {
        this.builder.register((LogicalRelationalOperator)loSplit);
    }

    public void visit(LOSplitOutput loSplitOutput) throws FrontendException {
        RexNode relExFilter = PigRelExVisitor.translatePigEx(this.builder, loSplitOutput.getFilterPlan());
        this.builder.filter(new RexNode[]{relExFilter});
        this.builder.register((LogicalRelationalOperator)loSplitOutput);
    }

    public void visit(LOStore store) {
        this.builder.store(store.getAlias());
    }

    public void visit(LOGenerate gen) throws FrontendException {
        throw new FrontendException("Not implemented", 10000);
    }

    public void visit(LORank loRank) throws FrontendException {
        RexNode rankField = this.buildRankField(loRank);
        RelDataType inputRowType = this.builder.peek().getRowType();
        ArrayList<Object> projectedFields = new ArrayList<Object>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        projectedFields.add(rankField);
        fieldNames.add(loRank.getSchema().getField((int)0).alias);
        for (int i = 0; i < inputRowType.getFieldCount(); ++i) {
            projectedFields.add(this.builder.field(i));
            fieldNames.add((String)inputRowType.getFieldNames().get(i));
        }
        this.builder.project(projectedFields, fieldNames);
        this.builder.register((LogicalRelationalOperator)loRank);
    }

    private RexNode buildRankField(LORank loRank) throws FrontendException {
        SqlRankFunction rank = loRank.isDenseRank() ? SqlStdOperatorTable.DENSE_RANK : SqlStdOperatorTable.RANK;
        ArrayList<RexNode> orderNodes = new ArrayList<RexNode>();
        for (Pair p : Pair.zip((List)loRank.getRankColPlans(), (List)loRank.getAscendingCol())) {
            RexNode orderNode = PigRelExVisitor.translatePigEx(this.builder, (LogicalExpressionPlan)p.left);
            boolean ascending = (Boolean)p.right;
            if (!ascending) {
                orderNode = this.builder.desc(orderNode);
            }
            orderNodes.add(orderNode);
        }
        return this.builder.aggregateCall((SqlAggFunction)rank, new RexNode[0]).over().rangeFrom(RexWindowBounds.UNBOUNDED_PRECEDING).orderBy(orderNodes).toRex();
    }

    public void visit(LOStream loStream) throws FrontendException {
        throw new FrontendException("Not implemented", 10000);
    }

    public void visit(LONative nativeMR) throws FrontendException {
        throw new FrontendException("Not implemented", 10000);
    }

    @Override
    public boolean preVisit(LogicalRelationalOperator root) {
        return this.builder.checkMap(root);
    }

    private static enum GroupType {
        CUBE,
        ROLLUP,
        REGULAR;

    }
}

