/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.rel.type.DynamicRecordTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;

public class DynamicTupleRecordType
extends DynamicRecordTypeImpl {
    private static final Pattern INDEX_PATTERN = Pattern.compile("^\\$(\\d+)$");

    DynamicTupleRecordType(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    public RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        int index = DynamicTupleRecordType.nameToIndex(fieldName);
        if (index >= 0) {
            this.resize(index + 1);
            return super.getField(fieldName, caseSensitive, elideRecord);
        }
        return null;
    }

    void resize(int size) {
        int currentSize = this.getFieldCount();
        if (size > currentSize) {
            for (int i = currentSize; i < size; ++i) {
                super.getField("$" + i, true, true);
            }
            this.computeDigest();
        }
    }

    private static int nameToIndex(String fieldName) {
        Matcher matcher = INDEX_PATTERN.matcher(fieldName);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }
}

