/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.piglet.DynamicTupleRecordType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

class PigTypes {
    private static final String PIG_TUPLE_WRAPPER = "PIG_WRAPPER";
    static final PigRelDataTypeFactory TYPE_FACTORY = new PigRelDataTypeFactory(RelDataTypeSystem.DEFAULT);

    private PigTypes() {
    }

    static RelDataType convertSchemaField(LogicalSchema.LogicalFieldSchema pigField) {
        return PigTypes.convertSchemaField(pigField, true);
    }

    static RelDataType convertSchemaField(LogicalSchema.LogicalFieldSchema pigField, boolean nullable) {
        switch (pigField.type) {
            case 0: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.ANY, nullable);
            }
            case 1: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.NULL, nullable);
            }
            case 5: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.BOOLEAN, nullable);
            }
            case 6: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.TINYINT, nullable);
            }
            case 10: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER, nullable);
            }
            case 15: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.BIGINT, nullable);
            }
            case 20: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.REAL, nullable);
            }
            case 25: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.DOUBLE, nullable);
            }
            case 30: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.DATE, nullable);
            }
            case 50: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.BINARY, nullable);
            }
            case 55: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR, nullable);
            }
            case 65: 
            case 70: {
                return TYPE_FACTORY.createSqlType(SqlTypeName.DECIMAL, nullable);
            }
            case 110: {
                if (pigField.alias != null && pigField.alias.equals(PIG_TUPLE_WRAPPER)) {
                    if (pigField.schema == null || pigField.schema.size() != 1) {
                        throw new IllegalArgumentException("Expect one subfield from " + pigField.schema);
                    }
                    return PigTypes.convertSchemaField(pigField.schema.getField(0), nullable);
                }
                return PigTypes.convertSchema(pigField.schema, nullable);
            }
            case 100: {
                RelDataType relKey = TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR);
                if (pigField.schema == null) {
                    return TYPE_FACTORY.createMapType(relKey, TYPE_FACTORY.createSqlType(SqlTypeName.BINARY), nullable);
                }
                assert (pigField.schema.size() == 1);
                return TYPE_FACTORY.createMapType(relKey, PigTypes.convertSchemaField(pigField.schema.getField(0), nullable), nullable);
            }
            case 120: {
                if (pigField.schema == null) {
                    return TYPE_FACTORY.createMultisetType(TYPE_FACTORY.createSqlType(SqlTypeName.ANY, true), -1L, true);
                }
                assert (pigField.schema.size() == 1);
                return TYPE_FACTORY.createMultisetType(PigTypes.convertSchemaField(pigField.schema.getField(0), nullable), -1L, nullable);
            }
        }
        throw new IllegalArgumentException("Unsupported conversion for Pig Data type: " + DataType.findTypeName((byte)pigField.type));
    }

    static RelDataType convertSchema(LogicalSchema pigSchema) {
        return PigTypes.convertSchema(pigSchema, true);
    }

    static RelDataType convertSchema(LogicalSchema pigSchema, boolean nullable) {
        if (pigSchema != null && pigSchema.size() > 0) {
            ArrayList<String> fieldNameList = new ArrayList<String>();
            ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
            for (int i = 0; i < pigSchema.size(); ++i) {
                LogicalSchema.LogicalFieldSchema subPigField = pigSchema.getField(i);
                fieldNameList.add(subPigField.alias != null ? subPigField.alias : "$" + i);
                typeList.add(PigTypes.convertSchemaField(subPigField, nullable));
            }
            return TYPE_FACTORY.createStructType(typeList, fieldNameList, nullable);
        }
        return new DynamicTupleRecordType((RelDataTypeFactory)TYPE_FACTORY);
    }

    static class PigRelDataTypeFactory
    extends JavaTypeFactoryImpl {
        private PigRelDataTypeFactory(RelDataTypeSystem typeSystem) {
            super(typeSystem);
        }

        public RelDataType createSqlType(SqlTypeName typeName, boolean nullable) {
            return this.createTypeWithNullability(super.createSqlType(typeName), nullable);
        }

        public RelDataType createStructType(List<RelDataType> typeList, List<String> fieldNameList, boolean nullable) {
            return this.createTypeWithNullability(super.createStructType(typeList, fieldNameList), nullable);
        }

        public RelDataType createMultisetType(RelDataType type, long maxCardinality, boolean nullable) {
            return this.createTypeWithNullability(super.createMultisetType(type, maxCardinality), nullable);
        }

        public RelDataType createMapType(RelDataType keyType, RelDataType valueType, boolean nullable) {
            return this.createTypeWithNullability(super.createMapType(keyType, valueType), nullable);
        }

        public RelDataType toSql(RelDataType type) {
            if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == DataBag.class) {
                return this.createMultisetType(this.createSqlType(SqlTypeName.ANY, true), -1L, true);
            }
            return super.toSql(type);
        }
    }
}

