/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apache.calcite.piglet.DynamicTupleRecordType;
import org.apache.calcite.piglet.PigTable;
import org.apache.calcite.piglet.PigTypes;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.scripting.jython.JythonFunction;

public class PigRelBuilder
extends RelBuilder {
    private final Map<RelNode, String> reverseAliasMap = new HashMap<RelNode, String>();
    private final Map<String, RelNode> aliasMap = new HashMap<String, RelNode>();
    private final Map<Operator, RelNode> pigRelMap = new HashMap<Operator, RelNode>();
    private final Map<RelNode, Operator> relPigMap = new HashMap<RelNode, Operator>();
    private final Map<String, RelNode> storeMap = new HashMap<String, RelNode>();
    private int nextCorrelId = 0;
    private final PigRelTranslationContext pigRelContext = new PigRelTranslationContext();

    private PigRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        super(context, cluster, relOptSchema);
    }

    public static PigRelBuilder create(FrameworkConfig config) {
        RelBuilder relBuilder = RelBuilder.create((FrameworkConfig)config);
        return new PigRelBuilder(PigRelBuilder.transform(config.getContext(), c -> c.withBloat(-1)), relBuilder.getCluster(), relBuilder.getRelOptSchema());
    }

    private static Context transform(Context context, UnaryOperator<RelBuilder.Config> transform) {
        RelBuilder.Config config = context.maybeUnwrap(RelBuilder.Config.class).orElse(RelBuilder.Config.DEFAULT);
        return Contexts.of((Object[])new Object[]{transform.apply(config), context});
    }

    public RelNode getRel(String alias) {
        return this.aliasMap.get(alias);
    }

    public RelNode getRel(Operator pig) {
        return this.pigRelMap.get(pig);
    }

    Operator getPig(RelNode rel) {
        return this.relPigMap.get(rel);
    }

    String getAlias(RelNode rel) {
        return this.reverseAliasMap.get(rel);
    }

    CorrelationId nextCorrelId() {
        return new CorrelationId(this.nextCorrelId++);
    }

    public String getAlias() {
        RelNode input = this.peek();
        if (this.reverseAliasMap.containsKey(input)) {
            return this.reverseAliasMap.get(input);
        }
        return null;
    }

    public void clear() {
        super.clear();
        this.reverseAliasMap.clear();
        this.aliasMap.clear();
        this.pigRelMap.clear();
        this.relPigMap.clear();
        this.storeMap.clear();
        this.nextCorrelId = 0;
    }

    public boolean checkMap(LogicalRelationalOperator pigOp) {
        if (this.pigRelMap.containsKey(pigOp)) {
            this.push(this.pigRelMap.get(pigOp));
            return true;
        }
        return false;
    }

    public void updateAlias(Operator pigOp, String alias, boolean updatePigRelMap) {
        RelNode rel = this.peek();
        if (updatePigRelMap) {
            this.pigRelMap.put(pigOp, rel);
        }
        this.relPigMap.put(rel, pigOp);
        this.aliasMap.put(alias, rel);
        this.reverseAliasMap.put(rel, alias);
    }

    void register(LogicalRelationalOperator pigOp) {
        this.updateAlias((Operator)pigOp, pigOp.getAlias(), true);
    }

    void registerPigUDF(String className, FuncSpec pigFunc) {
        Class<?> udfClass = pigFunc.getClass();
        String key = className;
        if (udfClass == JythonFunction.class) {
            String[] args = pigFunc.getCtorArgs();
            Objects.requireNonNull(args, "args");
            Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0);
            String fileName = args[0].substring(args[0].lastIndexOf("/") + 1, args[0].lastIndexOf(".py"));
            key = udfClass.getName() + "_" + fileName + "_" + args[1];
        }
        this.pigRelContext.pigUdfs.put(key, pigFunc);
    }

    void replaceTop(RelNode newRel) {
        RelNode topRel = this.peek();
        if (topRel instanceof SingleRel) {
            Operator pig;
            String alias = this.reverseAliasMap.get(topRel);
            if (alias != null) {
                this.reverseAliasMap.remove(topRel);
                this.reverseAliasMap.put(newRel, alias);
                this.aliasMap.put(alias, newRel);
            }
            if ((pig = this.getPig(topRel)) != null) {
                this.relPigMap.remove(topRel);
                this.relPigMap.put(newRel, pig);
                this.pigRelMap.put(pig, newRel);
            }
            this.build();
            this.push(newRel);
        }
    }

    public RelBuilder scan(RelOptTable userSchema, String ... tableNames) {
        ImmutableList names = ImmutableList.copyOf((Object[])tableNames);
        Objects.requireNonNull(this.relOptSchema, "relOptSchema");
        RelOptTable systemSchema = this.relOptSchema.getTableForMember((List)names);
        if (systemSchema != null) {
            if (userSchema != null && !PigRelBuilder.compatibleType(userSchema.getRowType(), systemSchema.getRowType())) {
                throw new IllegalArgumentException("Pig script schema does not match database schema for table " + names + ".\n\t Scrip schema: " + userSchema.getRowType().getFullTypeString() + "\n\t Database schema: " + systemSchema.getRowType().getFullTypeString());
            }
            return this.scan(systemSchema);
        }
        if (userSchema != null) {
            return this.scan(userSchema);
        }
        throw (CalciteException)Static.RESOURCE.tableNotFound(String.join((CharSequence)".", (Iterable<? extends CharSequence>)names)).ex();
    }

    private RelBuilder scan(RelOptTable tableSchema) {
        RelNode scan = this.getScanFactory().createScan(ViewExpanders.simpleContext((RelOptCluster)this.cluster), tableSchema);
        this.push(scan);
        return this;
    }

    public RelBuilder scan(RelDataType rowType, String ... tableNames) {
        return this.scan(rowType, Arrays.asList(tableNames));
    }

    public RelBuilder scan(RelDataType rowType, List<String> tableNames) {
        RelOptTable relOptTable = PigTable.createRelOptTable(this.getRelOptSchema(), rowType, tableNames);
        return this.scan(relOptTable);
    }

    public RelNode project(RelNode input, RelDataType outputType) {
        RelDataType inputType = input.getRowType();
        if (PigRelBuilder.compatibleType(inputType, outputType) && inputType.getFieldNames().equals(outputType.getFieldNames())) {
            return input;
        }
        this.push(input);
        this.project(this.projects(inputType, outputType), outputType.getFieldNames(), true);
        return this.build();
    }

    private List<RexNode> projects(RelDataType inputType, RelDataType outputType) {
        List outputFields = outputType.getFieldList();
        List inputFields = inputType.getFieldList();
        ArrayList<RexNode> projectionExprs = new ArrayList<RexNode>();
        for (RelDataTypeField outputField : outputFields) {
            RelDataTypeField matchInputField = null;
            for (RelDataTypeField inputField : inputFields) {
                if (!inputField.getName().equals(outputField.getName())) continue;
                matchInputField = inputField;
                break;
            }
            if (matchInputField != null) {
                RexInputRef fieldProject = this.field(matchInputField.getIndex());
                if (matchInputField.getType().equals(outputField.getType())) {
                    projectionExprs.add((RexNode)fieldProject);
                    continue;
                }
                projectionExprs.add(this.getRexBuilder().makeCast(outputField.getType(), (RexNode)fieldProject));
                continue;
            }
            RelDataType columnType = outputField.getType();
            if (!columnType.isStruct() && columnType.getComponentType() == null) {
                projectionExprs.add((RexNode)this.getRexBuilder().makeNullLiteral(outputField.getType()));
                continue;
            }
            projectionExprs.add((RexNode)this.literal(null));
        }
        return projectionExprs;
    }

    public RelBuilder cogroup(Iterable<? extends RelBuilder.GroupKey> groupKeys) {
        int i;
        ImmutableList groupKeyList = ImmutableList.copyOf(groupKeys);
        int groupCount = ((RelBuilder.GroupKey)groupKeyList.get(0)).groupKeyCount();
        int numRels = groupKeyList.size();
        ArrayList<RelNode> cogroupRels = new ArrayList<RelNode>();
        for (i = 0; i < numRels; ++i) {
            cogroupRels.add(0, this.build());
        }
        for (i = 0; i < numRels; ++i) {
            int j;
            this.push((RelNode)cogroupRels.get(i));
            RexInputRef row = this.field(groupCount);
            this.aggregate((RelBuilder.GroupKey)groupKeyList.get(i), new RelBuilder.AggCall[]{this.aggregateCall(SqlStdOperatorTable.COLLECT, new RexNode[]{row}).as(this.getAlias())});
            if (i == 0) continue;
            ArrayList<RexNode> predicates = new ArrayList<RexNode>();
            Iterator iterator = Util.range((int)groupCount).iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                predicates.add(this.equals((RexNode)this.field(2, 0, key), (RexNode)this.field(2, 1, key)));
            }
            this.join(JoinRelType.FULL, this.and(predicates));
            Object[] projectFields = new RexNode[groupCount + i + 1];
            Object[] fieldNames = new String[groupCount + i + 1];
            LogicalJoin join = (LogicalJoin)this.peek();
            for (j = 0; j < groupCount; ++j) {
                String rightName;
                RexNode[] caseOperands = new RexNode[]{this.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{this.field(j)}), this.field(j), this.field(j + groupCount + i)};
                projectFields[j] = this.call((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
                String leftName = (String)join.getLeft().getRowType().getFieldNames().get(j);
                fieldNames[j] = leftName.equals(rightName = (String)join.getRight().getRowType().getFieldNames().get(j)) ? leftName : rightName;
            }
            for (j = groupCount; j < groupCount + i + 1; ++j) {
                projectFields[j] = this.field(j);
                fieldNames[j] = (String)this.peek().getRowType().getFieldNames().get(j);
            }
            projectFields[groupCount + i] = this.field(2 * groupCount + i);
            fieldNames[groupCount + i] = (String)this.peek().getRowType().getFieldNames().get(2 * groupCount + i);
            this.project((Iterable)ImmutableList.copyOf((Object[])projectFields), (Iterable)ImmutableList.copyOf((Object[])fieldNames));
        }
        return this;
    }

    public RelBuilder multiSetFlatten(List<Integer> flattenCols, List<String> flattenOutputAliases) {
        int colCount = this.peek().getRowType().getFieldCount();
        List inputFields = this.peek().getRowType().getFieldList();
        CorrelationId correlId = this.nextCorrelId();
        RexNode cor = this.correl(inputFields, correlId);
        ArrayList<RexNode> flattenNodes = new ArrayList<RexNode>();
        for (int i : flattenCols) {
            assert (((RelDataTypeField)inputFields.get(i)).getType().getFamily() instanceof MultisetSqlType);
            flattenNodes.add(this.getRexBuilder().makeFieldAccess(cor, i));
        }
        this.push((RelNode)LogicalValues.createOneRow((RelOptCluster)this.getCluster()));
        this.project(flattenNodes);
        this.multiSetFlatten();
        this.join(JoinRelType.INNER, (RexNode)this.literal(true), (Set)ImmutableSet.of((Object)correlId));
        ArrayList<RexInputRef> finnalCols = new ArrayList<RexInputRef>();
        ArrayList<String> finnalColNames = new ArrayList<String>();
        int flattenCount = 0;
        for (int i = 0; i < colCount; ++i) {
            if (flattenCols.indexOf(i) >= 0) {
                RelDataType componentType = ((RelDataTypeField)inputFields.get(i)).getType().getComponentType();
                int numSubFields = componentType.isStruct() ? componentType.getFieldCount() : 1;
                for (int j = 0; j < numSubFields; ++j) {
                    finnalCols.add(this.field(colCount + flattenCount));
                    finnalColNames.add(flattenOutputAliases.get(flattenCount));
                    ++flattenCount;
                }
                continue;
            }
            finnalCols.add(this.field(i));
            finnalColNames.add(((RelDataTypeField)inputFields.get(i)).getName());
        }
        this.project(finnalCols, finnalColNames);
        return this;
    }

    public RelBuilder multiSetFlatten() {
        Uncollect uncollect = Uncollect.create((RelTraitSet)this.cluster.traitSetOf((RelTrait)Convention.NONE), (RelNode)this.build(), (boolean)false, Collections.emptyList());
        this.push((RelNode)uncollect);
        return this;
    }

    public RexNode correl(List<RelDataTypeField> inputFields, CorrelationId correlId) {
        RelDataTypeFactory.FieldInfoBuilder fieldBuilder = PigTypes.TYPE_FACTORY.builder();
        for (RelDataTypeField field : inputFields) {
            fieldBuilder.add(field.getName(), field.getType());
        }
        return this.getRexBuilder().makeCorrel(fieldBuilder.uniquify().build(), correlId);
    }

    public RelBuilder collect() {
        RelNode inputRel = this.peek();
        RexNode row = this.getRexBuilder().makeCall(inputRel.getRowType(), (SqlOperator)SqlStdOperatorTable.ROW, (List)this.fields());
        this.project((Iterable)ImmutableList.of((Object)this.literal("all"), (Object)row));
        this.updateAlias(this.getPig(inputRel), this.getAlias(inputRel), false);
        this.cogroup((Iterable<? extends RelBuilder.GroupKey>)ImmutableList.of((Object)this.groupKey((Iterable)ImmutableList.of((Object)this.field(0)))));
        this.project(new RexNode[]{this.field(1)});
        return this;
    }

    public RexNode dot(RexNode node, Object field) {
        if (field instanceof Integer) {
            int fieldIndex = (Integer)field;
            RelDataType type = node.getType();
            if (type instanceof DynamicTupleRecordType) {
                ((DynamicTupleRecordType)type).resize(fieldIndex + 1);
            }
            return super.dot(node, fieldIndex);
        }
        return super.dot(node, (String)field);
    }

    public RexLiteral literal(Object value, RelDataType type) {
        if (value instanceof Tuple) {
            assert (type.isStruct());
            return this.getRexBuilder().makeLiteral((Object)((Tuple)value).getAll(), type);
        }
        if (value instanceof DataBag) {
            assert (type.getComponentType() != null && type.getComponentType().isStruct());
            ArrayList<List> multisetObj = new ArrayList<List>();
            for (Tuple tuple : (DataBag)value) {
                multisetObj.add(tuple.getAll());
            }
            return this.getRexBuilder().makeLiteral(multisetObj, type);
        }
        return this.getRexBuilder().makeLiteral(value, type);
    }

    RelBuilder store(String storeAlias) {
        this.storeMap.put(storeAlias, this.build());
        return this;
    }

    public List<RelNode> getRelsForStores() {
        if (this.storeMap.isEmpty()) {
            return null;
        }
        return ImmutableList.copyOf(this.storeMap.values());
    }

    public ImmutableList<RexNode> getFields(int inputCount, int inputOrdinal, int fieldOrdinal) {
        if (fieldOrdinal == -1) {
            return this.fields(inputCount, inputOrdinal);
        }
        return ImmutableList.of((Object)this.field(inputCount, inputOrdinal, fieldOrdinal));
    }

    public static boolean compatibleType(RelDataType t1, RelDataType t2) {
        if (t1.isStruct() || t2.isStruct()) {
            if (!t1.isStruct() || !t2.isStruct()) {
                return false;
            }
            if (t1.getFieldCount() != t2.getFieldCount()) {
                return false;
            }
            List fields1 = t1.getFieldList();
            List fields2 = t2.getFieldList();
            for (int i = 0; i < fields1.size(); ++i) {
                if (PigRelBuilder.compatibleType(((RelDataTypeField)fields1.get(i)).getType(), ((RelDataTypeField)fields2.get(i)).getType())) continue;
                return false;
            }
            return true;
        }
        RelDataType comp1 = t1.getComponentType();
        RelDataType comp2 = t2.getComponentType();
        if (comp1 != null || comp2 != null) {
            if (comp1 == null || comp2 == null) {
                return false;
            }
            if (!PigRelBuilder.compatibleType(comp1, comp2)) {
                return false;
            }
        }
        return t1.getSqlTypeName().getFamily() == t2.getSqlTypeName().getFamily();
    }

    public static class PigRelTranslationContext {
        final Map<String, FuncSpec> pigUdfs = new HashMap<String, FuncSpec>();
    }
}

