/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class Ast {
    private Ast() {
    }

    public static String toString(Node x) {
        return new UnParser().append((Node)x).buf.toString();
    }

    public static UnParser unParse(UnParser u, Node n) {
        switch (n.op) {
            case PROGRAM: {
                Program program = (Program)n;
                return u.append("{op: PROGRAM, stmts: ").appendList(program.stmtList).append("}");
            }
            case LOAD: {
                LoadStmt load = (LoadStmt)n;
                return u.append("{op: LOAD, target: " + load.target.value + ", name: " + load.name.value + "}");
            }
            case DUMP: {
                DumpStmt dump = (DumpStmt)n;
                return u.append("{op: DUMP, relation: " + dump.relation.value + "}");
            }
            case DESCRIBE: {
                DescribeStmt describe = (DescribeStmt)n;
                return u.append("{op: DESCRIBE, relation: " + describe.relation.value + "}");
            }
            case FOREACH: {
                ForeachStmt foreach = (ForeachStmt)n;
                return u.append("{op: FOREACH, target: " + foreach.target.value + ", source: " + foreach.source.value + ", expList: ").appendList(foreach.expList).append("}");
            }
            case FOREACH_NESTED: {
                ForeachNestedStmt foreachNested = (ForeachNestedStmt)n;
                return u.append("{op: FOREACH, target: " + foreachNested.target.value + ", source: " + foreachNested.source.value + ", nestedOps: ").appendList(foreachNested.nestedStmtList).append(", expList: ").appendList(foreachNested.expList).append("}");
            }
            case FILTER: {
                FilterStmt filter = (FilterStmt)n;
                u.append("{op: FILTER, target: " + filter.target.value + ", source: " + filter.source.value + ", condition: ");
                u.in().append(filter.condition).out();
                return u.append("}");
            }
            case DISTINCT: {
                DistinctStmt distinct = (DistinctStmt)n;
                return u.append("{op: DISTINCT, target: " + distinct.target.value + ", source: " + distinct.source.value + "}");
            }
            case LIMIT: {
                LimitStmt limit = (LimitStmt)n;
                return u.append("{op: LIMIT, target: ").append(limit.target.value).append(", source: ").append(limit.source.value).append(", count: ").append(limit.count.value.toString()).append("}");
            }
            case ORDER: {
                OrderStmt order = (OrderStmt)n;
                return u.append("{op: ORDER, target: " + order.target.value + ", source: " + order.source.value + "}");
            }
            case GROUP: {
                GroupStmt group = (GroupStmt)n;
                u.append("{op: GROUP, target: " + group.target.value + ", source: " + group.source.value);
                if (group.keys != null) {
                    u.append(", keys: ").appendList(group.keys);
                }
                return u.append("}");
            }
            case LITERAL: {
                Literal literal = (Literal)n;
                return u.append(String.valueOf(literal.value));
            }
            case IDENTIFIER: {
                Identifier id = (Identifier)n;
                return u.append(id.value);
            }
        }
        throw new AssertionError((Object)("unknown op " + (Object)((Object)n.op)));
    }

    public static enum Direction {
        ASC,
        DESC,
        NOT_SPECIFIED;

    }

    static class UnParser {
        final StringBuilder buf = new StringBuilder();
        final Spacer spacer = new Spacer(0);

        UnParser() {
        }

        public UnParser in() {
            this.spacer.add(2);
            return this;
        }

        public UnParser out() {
            this.spacer.subtract(2);
            return this;
        }

        public UnParser newline() {
            this.buf.append(Util.LINE_SEPARATOR);
            this.spacer.spaces(this.buf);
            return this;
        }

        public UnParser append(String s) {
            this.buf.append(s);
            return this;
        }

        public UnParser append(Node n) {
            return Ast.unParse(this, n);
        }

        public UnParser appendList(List<? extends Node> list) {
            this.append("[").in();
            for (Ord n : Ord.zip(list)) {
                this.newline().append((Node)n.e);
                if (n.i >= list.size() - 1) continue;
                this.append(",");
            }
            return this.out().append("]");
        }
    }

    public static class MapType
    extends Type {
        final Type keyType;
        final Type valueType;

        public MapType(SqlParserPos pos) {
            super(pos, Op.MAP_TYPE);
            this.keyType = new ScalarType(pos, "int");
            this.valueType = new ScalarType(pos, "int");
        }
    }

    public static class TupleType
    extends Type {
        final List<FieldSchema> fieldSchemaList;

        public TupleType(SqlParserPos pos, List<FieldSchema> fieldSchemaList) {
            super(pos, Op.TUPLE_TYPE);
            this.fieldSchemaList = ImmutableList.copyOf(fieldSchemaList);
        }
    }

    public static class BagType
    extends Type {
        final Type componentType;

        public BagType(SqlParserPos pos, Type componentType) {
            super(pos, Op.BAG_TYPE);
            this.componentType = componentType;
        }
    }

    public static class ScalarType
    extends Type {
        final String name;

        public ScalarType(SqlParserPos pos, String name) {
            super(pos, Op.SCALAR_TYPE);
            this.name = name;
        }
    }

    public static abstract class Type
    extends Node {
        protected Type(SqlParserPos pos, Op op) {
            super(pos, op);
        }
    }

    public static class Schema
    extends Node {
        final List<FieldSchema> fieldSchemaList;

        public Schema(SqlParserPos pos, List<FieldSchema> fieldSchemaList) {
            super(pos, Op.SCHEMA);
            this.fieldSchemaList = ImmutableList.copyOf(fieldSchemaList);
        }
    }

    public static class FieldSchema
    extends Node {
        final Identifier id;
        final Type type;

        public FieldSchema(SqlParserPos pos, Identifier id, Type type) {
            super(pos, Op.FIELD_SCHEMA);
            this.id = Objects.requireNonNull(id, "id");
            this.type = Objects.requireNonNull(type, "type");
        }
    }

    public static class Program
    extends Node {
        public final List<Stmt> stmtList;

        public Program(SqlParserPos pos, List<Stmt> stmtList) {
            super(pos, Op.PROGRAM);
            this.stmtList = stmtList;
        }
    }

    public static class Call
    extends Node {
        final ImmutableList<Node> operands;

        private Call(SqlParserPos pos, Op op, ImmutableList<Node> operands) {
            super(pos, op);
            this.operands = ImmutableList.copyOf(operands);
        }

        public Call(SqlParserPos pos, Op op, Iterable<? extends Node> operands) {
            this(pos, op, (ImmutableList<Node>)ImmutableList.copyOf(operands));
        }

        public Call(SqlParserPos pos, Op op, Node ... operands) {
            this(pos, op, (ImmutableList<Node>)ImmutableList.copyOf((Object[])operands));
        }
    }

    public static class SpecialIdentifier
    extends Identifier {
        public SpecialIdentifier(SqlParserPos pos) {
            super(pos, "*");
        }

        @Override
        public boolean isStar() {
            return true;
        }
    }

    public static class Identifier
    extends Node {
        final String value;

        public Identifier(SqlParserPos pos, String value) {
            super(pos, Op.IDENTIFIER);
            this.value = Objects.requireNonNull(value, "value");
        }

        public boolean isStar() {
            return false;
        }
    }

    public static class NumericLiteral
    extends Literal {
        final int prec;
        final int scale;
        final boolean exact;

        NumericLiteral(SqlParserPos pos, BigDecimal value, int prec, int scale, boolean exact) {
            super(pos, value);
            this.prec = prec;
            this.scale = scale;
            this.exact = exact;
        }

        public NumericLiteral negate(SqlParserPos pos) {
            BigDecimal value = (BigDecimal)this.value;
            return new NumericLiteral(pos, value.negate(), this.prec, this.scale, this.exact);
        }
    }

    public static class Literal
    extends Node {
        final Object value;

        public Literal(SqlParserPos pos, Object value) {
            super(pos, Op.LITERAL);
            this.value = Objects.requireNonNull(value, "value");
        }

        public static NumericLiteral createExactNumeric(String s, SqlParserPos pos) {
            int prec;
            int scale;
            BigDecimal value;
            int i = s.indexOf(46);
            if (i >= 0 && s.length() - 1 != i) {
                value = SqlParserUtil.parseDecimal((String)s);
                scale = s.length() - i - 1;
                assert (scale == value.scale()) : s;
                prec = s.length() - 1;
            } else if (i >= 0 && s.length() - 1 == i) {
                value = SqlParserUtil.parseInteger((String)s.substring(0, i));
                scale = 0;
                prec = s.length() - 1;
            } else {
                value = SqlParserUtil.parseInteger((String)s);
                scale = 0;
                prec = s.length();
            }
            return new NumericLiteral(pos, value, prec, scale, true);
        }
    }

    public static class DescribeStmt
    extends Stmt {
        final Identifier relation;

        public DescribeStmt(SqlParserPos pos, Identifier relation) {
            super(pos, Op.DESCRIBE);
            this.relation = Objects.requireNonNull(relation, "relation");
        }
    }

    public static class DumpStmt
    extends Stmt {
        final Identifier relation;

        public DumpStmt(SqlParserPos pos, Identifier relation) {
            super(pos, Op.DUMP);
            this.relation = Objects.requireNonNull(relation, "relation");
        }
    }

    public static class GroupStmt
    extends Assignment1 {
        final List<Node> keys;

        public GroupStmt(SqlParserPos pos, Identifier target, Identifier source, List<Node> keys) {
            super(pos, Op.GROUP, target, source);
            this.keys = keys;
            assert (keys == null || keys.size() >= 1);
        }
    }

    public static class OrderStmt
    extends Assignment1 {
        final List<Pair<Identifier, Direction>> fields;

        public OrderStmt(SqlParserPos pos, Identifier target, Identifier source, List<Pair<Identifier, Direction>> fields) {
            super(pos, Op.ORDER, target, source);
            this.fields = fields;
        }
    }

    public static class LimitStmt
    extends Assignment1 {
        final Literal count;

        public LimitStmt(SqlParserPos pos, Identifier target, Identifier source, Literal count) {
            super(pos, Op.LIMIT, target, source);
            this.count = count;
        }
    }

    public static class DistinctStmt
    extends Assignment1 {
        public DistinctStmt(SqlParserPos pos, Identifier target, Identifier source) {
            super(pos, Op.DISTINCT, target, source);
        }
    }

    public static class FilterStmt
    extends Assignment1 {
        final Node condition;

        public FilterStmt(SqlParserPos pos, Identifier target, Identifier source, Node condition) {
            super(pos, Op.FILTER, target, source);
            this.condition = condition;
        }
    }

    public static class ForeachNestedStmt
    extends Assignment1 {
        final List<Stmt> nestedStmtList;
        final List<Node> expList;

        public ForeachNestedStmt(SqlParserPos pos, Identifier target, Identifier source, List<Stmt> nestedStmtList, List<Node> expList, Schema schema) {
            super(pos, Op.FOREACH_NESTED, target, source);
            this.nestedStmtList = nestedStmtList;
            this.expList = expList;
            assert (schema == null);
        }
    }

    public static class ForeachStmt
    extends Assignment1 {
        final List<Node> expList;

        public ForeachStmt(SqlParserPos pos, Identifier target, Identifier source, List<Node> expList, Schema schema) {
            super(pos, Op.FOREACH, target, source);
            this.expList = expList;
            assert (schema == null);
        }
    }

    public static class Assignment1
    extends Assignment {
        final Identifier source;

        protected Assignment1(SqlParserPos pos, Op op, Identifier target, Identifier source) {
            super(pos, op, target);
            this.source = source;
        }
    }

    public static class ValuesStmt
    extends Assignment {
        final List<List<Node>> tupleList;
        final Schema schema;

        public ValuesStmt(SqlParserPos pos, Identifier target, Schema schema, List<List<Node>> tupleList) {
            super(pos, Op.VALUES, target);
            this.schema = schema;
            this.tupleList = ImmutableList.copyOf(tupleList);
        }
    }

    public static class LoadStmt
    extends Assignment {
        final Literal name;

        public LoadStmt(SqlParserPos pos, Identifier target, Literal name) {
            super(pos, Op.LOAD, target);
            this.name = Objects.requireNonNull(name, "name");
        }
    }

    public static abstract class Assignment
    extends Stmt {
        final Identifier target;

        protected Assignment(SqlParserPos pos, Op op, Identifier target) {
            super(pos, op);
            this.target = Objects.requireNonNull(target, "target");
        }
    }

    public static abstract class Stmt
    extends Node {
        protected Stmt(SqlParserPos pos, Op op) {
            super(pos, op);
        }
    }

    public static abstract class Node {
        public final Op op;
        public final SqlParserPos pos;

        protected Node(SqlParserPos pos, Op op) {
            this.op = Objects.requireNonNull(op, "op");
            this.pos = Objects.requireNonNull(pos, "pos");
        }
    }

    public static enum Op {
        PROGRAM,
        LITERAL,
        IDENTIFIER,
        BAG,
        TUPLE,
        DESCRIBE,
        DISTINCT,
        DUMP,
        LOAD,
        FOREACH,
        FILTER,
        FOREACH_NESTED,
        LIMIT,
        ORDER,
        GROUP,
        VALUES,
        SCHEMA,
        SCALAR_TYPE,
        BAG_TYPE,
        TUPLE_TYPE,
        MAP_TYPE,
        FIELD_SCHEMA,
        DOT,
        EQ,
        NE,
        GT,
        LT,
        GTE,
        LTE,
        PLUS,
        MINUS,
        AND,
        OR,
        NOT;

    }
}

