/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;

public class MongoAggregate
extends Aggregate
implements MongoRel {
    public MongoAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, (List)ImmutableList.of(), input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() == MongoRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
        for (AggregateCall aggCall : aggCalls) {
            if (!aggCall.isDistinct()) continue;
            throw new InvalidRelException("distinct aggregation not supported");
        }
        switch (this.getGroupType()) {
            case SIMPLE: {
                break;
            }
            default: {
                throw new InvalidRelException("unsupported group type: " + this.getGroupType());
            }
        }
    }

    @Deprecated
    public MongoAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        MongoAggregate.checkIndicator((boolean)indicator);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new MongoAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        AbstractList fixups;
        int group;
        Iterator iterator;
        implementor.visitChild(0, this.getInput());
        ArrayList<String> list = new ArrayList<String>();
        List<String> inNames = MongoRules.mongoFieldNames(this.getInput().getRowType());
        final List<String> outNames = MongoRules.mongoFieldNames(this.getRowType());
        int i = 0;
        if (this.groupSet.cardinality() == 1) {
            String inName = inNames.get(this.groupSet.nth(0));
            list.add("_id: " + MongoRules.maybeQuote("$" + inName));
            ++i;
        } else {
            ArrayList<String> keys = new ArrayList<String>();
            iterator = this.groupSet.iterator();
            while (iterator.hasNext()) {
                group = (Integer)iterator.next();
                String inName = inNames.get(group);
                keys.add(inName + ": " + MongoRules.quote("$" + inName));
                ++i;
            }
            list.add("_id: " + Util.toString(keys, (String)"{", (String)", ", (String)"}"));
        }
        for (AggregateCall aggCall : this.aggCalls) {
            list.add(MongoRules.maybeQuote(outNames.get(i++)) + ": " + MongoAggregate.toMongo(aggCall.getAggregation(), inNames, aggCall.getArgList()));
        }
        implementor.add(null, "{$group: " + Util.toString(list, (String)"{", (String)", ", (String)"}") + "}");
        if (this.groupSet.cardinality() == 1) {
            fixups = new AbstractList<String>(){

                @Override
                public String get(int index) {
                    String outName = (String)outNames.get(index);
                    return MongoRules.maybeQuote(outName) + ": " + MongoRules.maybeQuote("$" + (index == 0 ? "_id" : outName));
                }

                @Override
                public int size() {
                    return outNames.size();
                }
            };
        } else {
            fixups = new ArrayList<String>();
            fixups.add("_id: 0");
            i = 0;
            iterator = this.groupSet.iterator();
            while (iterator.hasNext()) {
                group = (Integer)iterator.next();
                fixups.add(MongoRules.maybeQuote(outNames.get(group)) + ": " + MongoRules.maybeQuote("$_id." + outNames.get(group)));
                ++i;
            }
            for (AggregateCall ignored : this.aggCalls) {
                String outName = outNames.get(i++);
                fixups.add(MongoRules.maybeQuote(outName) + ": " + MongoRules.maybeQuote("$" + outName));
            }
        }
        if (!this.groupSet.isEmpty()) {
            implementor.add(null, "{$project: " + Util.toString(fixups, (String)"{", (String)", ", (String)"}") + "}");
        }
    }

    private static String toMongo(SqlAggFunction aggregation, List<String> inNames, List<Integer> args) {
        if (aggregation == SqlStdOperatorTable.COUNT) {
            if (args.size() == 0) {
                return "{$sum: 1}";
            }
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$sum: {$cond: [ {$eq: [" + MongoRules.quote(inName) + ", null]}, 0, 1]}}";
        }
        if (aggregation instanceof SqlSumAggFunction || aggregation instanceof SqlSumEmptyIsZeroAggFunction) {
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$sum: " + MongoRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.MIN) {
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$min: " + MongoRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.MAX) {
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$max: " + MongoRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.AVG) {
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$avg: " + MongoRules.maybeQuote("$" + inName) + "}";
        }
        throw new AssertionError((Object)("unknown aggregate " + aggregation));
    }
}

