/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.innodb.InnodbSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.commons.lang3.StringUtils;

public class InnodbSchemaFactory
implements SchemaFactory {
    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        List sqlFilePathList = (List)operand.get("sqlFilePath");
        String ibdDataFileBasePath = (String)operand.get("ibdDataFileBasePath");
        String timeZone = (String)operand.get("timeZone");
        if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
            System.setProperty("innodb.java.reader.server.timezone", timeZone);
        }
        return new InnodbSchema(sqlFilePathList, ibdDataFileBasePath);
    }
}

