/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.innodb.InnodbRel;
import org.apache.calcite.adapter.innodb.InnodbRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InnodbProject
extends Project
implements InnodbRel {
    InnodbProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), input, projects, rowType, (Set)ImmutableSet.of());
        assert (this.getConvention() == InnodbRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new InnodbProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        return cost.multiplyBy(0.1);
    }

    @Override
    public void implement(InnodbRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        InnodbRules.RexToInnodbTranslator translator = new InnodbRules.RexToInnodbTranslator(InnodbRules.innodbFieldNames(this.getInput().getRowType()));
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        for (Pair pair : this.getNamedProjects()) {
            String name = (String)pair.right;
            String originalName = (String)((RexNode)pair.left).accept((RexVisitor)translator);
            fields.put(originalName, name);
        }
        implementor.addSelectFields(fields);
    }
}

