/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.comparator.ComparisonOperator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.innodb.QueryType;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IndexCondition {
    static final IndexCondition EMPTY_CONDITION = IndexCondition.create("", QueryType.PK_FULL_SCAN, null, ComparisonOperator.NOP, ComparisonOperator.NOP, (List<Object>)ImmutableList.of(), (List<Object>)ImmutableList.of());
    private final List<String> fieldNames;
    private final String indexName;
    private final List<String> indexColumnNames;
    private final RelCollation implicitCollation;
    private final List<RexNode> pushDownConditions;
    private final List<RexNode> remainderConditions;
    private final QueryType queryType;
    private final List<Object> pointQueryKey;
    private final ComparisonOperator rangeQueryLowerOp;
    private final ComparisonOperator rangeQueryUpperOp;
    private final List<Object> rangeQueryLowerKey;
    private final List<Object> rangeQueryUpperKey;

    private IndexCondition(List<String> fieldNames, String indexName, List<String> indexColumnNames, @Nullable RelCollation implicitCollation, @Nullable List<RexNode> pushDownConditions, @Nullable List<RexNode> remainderConditions, QueryType queryType, @Nullable List<Object> pointQueryKey, ComparisonOperator rangeQueryLowerOp, ComparisonOperator rangeQueryUpperOp, List<Object> rangeQueryLowerKey, List<Object> rangeQueryUpperKey) {
        this.fieldNames = fieldNames;
        this.indexName = indexName;
        this.indexColumnNames = indexColumnNames;
        this.implicitCollation = implicitCollation != null ? implicitCollation : IndexCondition.deduceImplicitCollation(fieldNames, indexColumnNames);
        this.pushDownConditions = pushDownConditions == null ? ImmutableList.of() : ImmutableList.copyOf(pushDownConditions);
        this.remainderConditions = remainderConditions == null ? ImmutableList.of() : ImmutableList.copyOf(remainderConditions);
        this.queryType = queryType;
        this.pointQueryKey = pointQueryKey == null ? ImmutableList.of() : ImmutableList.copyOf(pointQueryKey);
        this.rangeQueryLowerOp = Objects.requireNonNull(rangeQueryLowerOp, "rangeQueryLowerOp");
        this.rangeQueryUpperOp = Objects.requireNonNull(rangeQueryUpperOp, "rangeQueryUpperOp");
        this.rangeQueryLowerKey = ImmutableList.copyOf(rangeQueryLowerKey);
        this.rangeQueryUpperKey = ImmutableList.copyOf(rangeQueryUpperKey);
    }

    static IndexCondition create(List<String> fieldNames, String indexName, List<String> indexColumnNames, QueryType queryType) {
        return new IndexCondition(fieldNames, indexName, indexColumnNames, null, null, null, queryType, null, ComparisonOperator.NOP, ComparisonOperator.NOP, (List<Object>)ImmutableList.of(), (List<Object>)ImmutableList.of());
    }

    static IndexCondition create(List<String> fieldNames, String indexName, List<String> indexColumnNames, List<RexNode> pushDownConditions, List<RexNode> remainderConditions) {
        return new IndexCondition(fieldNames, indexName, indexColumnNames, null, pushDownConditions, remainderConditions, QueryType.PK_FULL_SCAN, null, ComparisonOperator.NOP, ComparisonOperator.NOP, (List<Object>)ImmutableList.of(), (List<Object>)ImmutableList.of());
    }

    public static IndexCondition create(String indexName, QueryType queryType, @Nullable List<Object> pointQueryKey, ComparisonOperator rangeQueryLowerOp, ComparisonOperator rangeQueryUpperOp, List<Object> rangeQueryLowerKey, List<Object> rangeQueryUpperKey) {
        return new IndexCondition((List<String>)ImmutableList.of(), indexName, (List<String>)ImmutableList.of(), null, null, null, queryType, pointQueryKey, rangeQueryLowerOp, rangeQueryUpperOp, rangeQueryLowerKey, rangeQueryUpperKey);
    }

    boolean canPushDown() {
        return !this.pushDownConditions.isEmpty();
    }

    public RelCollation getImplicitCollation() {
        return this.implicitCollation;
    }

    private static RelCollation deduceImplicitCollation(List<String> fieldNames, List<String> indexColumnNames) {
        Objects.requireNonNull(fieldNames, "field names must not be null");
        ArrayList<RelFieldCollation> keyCollations = new ArrayList<RelFieldCollation>(indexColumnNames.size());
        for (String keyColumnName : indexColumnNames) {
            int fieldIndex = fieldNames.indexOf(keyColumnName);
            keyCollations.add(new RelFieldCollation(fieldIndex, RelFieldCollation.Direction.ASCENDING));
        }
        return RelCollations.of(keyCollations);
    }

    public IndexCondition withFieldNames(List<String> fieldNames) {
        if (Objects.equals(fieldNames, this.fieldNames)) {
            return this;
        }
        return new IndexCondition(fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, this.queryType, this.pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexCondition withIndexName(String indexName) {
        if (Objects.equals(indexName, this.indexName)) {
            return this;
        }
        return new IndexCondition(this.fieldNames, indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, this.queryType, this.pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public IndexCondition withIndexColumnNames(List<String> indexColumnNames) {
        if (Objects.equals(indexColumnNames, this.indexColumnNames)) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, this.queryType, this.pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public List<RexNode> getPushDownConditions() {
        return this.pushDownConditions;
    }

    public IndexCondition withPushDownConditions(List<RexNode> pushDownConditions) {
        if (Objects.equals(pushDownConditions, this.pushDownConditions)) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, pushDownConditions, this.remainderConditions, this.queryType, this.pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public List<RexNode> getRemainderConditions() {
        return this.remainderConditions;
    }

    public IndexCondition withRemainderConditions(List<RexNode> remainderConditions) {
        if (Objects.equals(remainderConditions, this.remainderConditions)) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, remainderConditions, this.queryType, this.pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public IndexCondition withQueryType(QueryType queryType) {
        if (queryType == this.queryType) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, queryType, this.pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public List<Object> getPointQueryKey() {
        return this.pointQueryKey;
    }

    public IndexCondition withPointQueryKey(List<Object> pointQueryKey) {
        if (pointQueryKey == this.pointQueryKey) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, this.queryType, pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public ComparisonOperator getRangeQueryLowerOp() {
        return this.rangeQueryLowerOp;
    }

    public IndexCondition withRangeQueryLowerOp(ComparisonOperator rangeQueryLowerOp) {
        if (rangeQueryLowerOp == this.rangeQueryLowerOp) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, this.queryType, this.pointQueryKey, rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public ComparisonOperator getRangeQueryUpperOp() {
        return this.rangeQueryUpperOp;
    }

    public IndexCondition withRangeQueryUpperOp(ComparisonOperator rangeQueryUpperOp) {
        if (rangeQueryUpperOp == this.rangeQueryUpperOp) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, this.queryType, this.pointQueryKey, this.rangeQueryLowerOp, rangeQueryUpperOp, this.rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public List<Object> getRangeQueryLowerKey() {
        return this.rangeQueryLowerKey;
    }

    public IndexCondition withRangeQueryLowerKey(List<Object> rangeQueryLowerKey) {
        if (rangeQueryLowerKey == this.rangeQueryLowerKey) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, this.queryType, this.pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, rangeQueryLowerKey, this.rangeQueryUpperKey);
    }

    public List<Object> getRangeQueryUpperKey() {
        return this.rangeQueryUpperKey;
    }

    public IndexCondition withRangeQueryUpperKey(List<Object> rangeQueryUpperKey) {
        if (rangeQueryUpperKey == this.rangeQueryUpperKey) {
            return this;
        }
        return new IndexCondition(this.fieldNames, this.indexName, this.indexColumnNames, this.implicitCollation, this.pushDownConditions, this.remainderConditions, this.queryType, this.pointQueryKey, this.rangeQueryLowerOp, this.rangeQueryUpperOp, this.rangeQueryLowerKey, rangeQueryUpperKey);
    }

    public boolean nameMatch(String name) {
        return name != null && name.equalsIgnoreCase(this.indexName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("(");
        builder.append((Object)this.queryType).append(", index=").append(this.indexName);
        if (this.queryType == QueryType.PK_POINT_QUERY || this.queryType == QueryType.SK_POINT_QUERY) {
            Preconditions.checkState((this.pointQueryKey.size() == this.indexColumnNames.size() ? 1 : 0) != 0);
            IndexCondition.append(builder, this.indexColumnNames, this.pointQueryKey, "=");
        } else {
            if (!this.rangeQueryLowerKey.isEmpty()) {
                IndexCondition.append(builder, this.indexColumnNames, this.rangeQueryLowerKey, this.rangeQueryLowerOp.value());
            }
            if (!this.rangeQueryUpperKey.isEmpty()) {
                IndexCondition.append(builder, this.indexColumnNames, this.rangeQueryUpperKey, this.rangeQueryUpperOp.value());
            }
        }
        builder.append(")");
        return builder.toString();
    }

    private static void append(StringBuilder builder, List<String> keyColumnNames, List<Object> key, String op) {
        builder.append(", ");
        for (Pair value : Pair.zip(keyColumnNames, key)) {
            builder.append((String)value.getKey());
            builder.append(op);
            builder.append(value.getValue());
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
    }
}

