/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.sql.type.SqlTypeName;

public class ColumnTypeToSqlTypeConversionRules {
    private static final ColumnTypeToSqlTypeConversionRules INSTANCE = new ColumnTypeToSqlTypeConversionRules();
    private final Map<String, SqlTypeName> rules = ImmutableMap.builder().put((Object)"TINYINT", (Object)SqlTypeName.TINYINT).put((Object)"SMALLINT", (Object)SqlTypeName.SMALLINT).put((Object)"MEDIUMINT", (Object)SqlTypeName.INTEGER).put((Object)"INT", (Object)SqlTypeName.INTEGER).put((Object)"BIGINT", (Object)SqlTypeName.BIGINT).put((Object)"TINYINT UNSIGNED", (Object)SqlTypeName.TINYINT).put((Object)"SMALLINT UNSIGNED", (Object)SqlTypeName.SMALLINT).put((Object)"MEDIUMINT UNSIGNED", (Object)SqlTypeName.INTEGER).put((Object)"INT UNSIGNED", (Object)SqlTypeName.INTEGER).put((Object)"BIGINT UNSIGNED", (Object)SqlTypeName.BIGINT).put((Object)"FLOAT", (Object)SqlTypeName.REAL).put((Object)"REAL", (Object)SqlTypeName.REAL).put((Object)"DOUBLE", (Object)SqlTypeName.DOUBLE).put((Object)"DECIMAL", (Object)SqlTypeName.DECIMAL).put((Object)"NUMERIC", (Object)SqlTypeName.DECIMAL).put((Object)"BOOL", (Object)SqlTypeName.BOOLEAN).put((Object)"BOOLEAN", (Object)SqlTypeName.BOOLEAN).put((Object)"CHAR", (Object)SqlTypeName.CHAR).put((Object)"VARCHAR", (Object)SqlTypeName.VARCHAR).put((Object)"BINARY", (Object)SqlTypeName.BINARY).put((Object)"VARBINARY", (Object)SqlTypeName.VARBINARY).put((Object)"TINYBLOB", (Object)SqlTypeName.VARBINARY).put((Object)"MEDIUMBLOB", (Object)SqlTypeName.VARBINARY).put((Object)"BLOB", (Object)SqlTypeName.VARBINARY).put((Object)"LONGBLOB", (Object)SqlTypeName.VARBINARY).put((Object)"TINYTEXT", (Object)SqlTypeName.VARCHAR).put((Object)"MEDIUMTEXT", (Object)SqlTypeName.VARCHAR).put((Object)"TEXT", (Object)SqlTypeName.VARCHAR).put((Object)"LONGTEXT", (Object)SqlTypeName.VARCHAR).put((Object)"YEAR", (Object)SqlTypeName.SMALLINT).put((Object)"TIME", (Object)SqlTypeName.TIME).put((Object)"DATE", (Object)SqlTypeName.DATE).put((Object)"DATETIME", (Object)SqlTypeName.TIMESTAMP).put((Object)"TIMESTAMP", (Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).put((Object)"ENUM", (Object)SqlTypeName.VARCHAR).put((Object)"SET", (Object)SqlTypeName.VARCHAR).put((Object)"BIT", (Object)SqlTypeName.VARBINARY).build();

    public static ColumnTypeToSqlTypeConversionRules instance() {
        return INSTANCE;
    }

    public SqlTypeName lookup(String name) {
        return this.rules.getOrDefault(name, SqlTypeName.ANY);
    }
}

