/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.schema.TableDef;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.innodb.ImmutableInnodbFilterRuleConfig;
import org.apache.calcite.adapter.innodb.ImmutableInnodbSortFilterRuleConfig;
import org.apache.calcite.adapter.innodb.ImmutableInnodbSortTableScanRuleConfig;
import org.apache.calcite.adapter.innodb.IndexCondition;
import org.apache.calcite.adapter.innodb.InnodbFilter;
import org.apache.calcite.adapter.innodb.InnodbFilterTranslator;
import org.apache.calcite.adapter.innodb.InnodbProject;
import org.apache.calcite.adapter.innodb.InnodbRel;
import org.apache.calcite.adapter.innodb.InnodbSort;
import org.apache.calcite.adapter.innodb.InnodbTableScan;
import org.apache.calcite.adapter.innodb.InnodbToEnumerableConverter;
import org.apache.calcite.adapter.innodb.InnodbToEnumerableConverterRule;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.immutables.value.Value;

public class InnodbRules {
    public static final InnodbToEnumerableConverterRule TO_ENUMERABLE = (InnodbToEnumerableConverterRule)InnodbToEnumerableConverterRule.DEFAULT_CONFIG.toRule(InnodbToEnumerableConverterRule.class);
    public static final InnodbProjectRule PROJECT = (InnodbProjectRule)InnodbProjectRule.access$000().toRule(InnodbProjectRule.class);
    public static final InnodbFilterRule FILTER = InnodbFilterRule.InnodbFilterRuleConfig.DEFAULT.toRule();
    public static final InnodbSortFilterRule SORT_FILTER = InnodbSortFilterRule.InnodbSortFilterRuleConfig.DEFAULT.toRule();
    public static final InnodbSortTableScanRule SORT_SCAN = InnodbSortTableScanRule.InnodbSortTableScanRuleConfig.DEFAULT.toRule();
    public static final List<RelOptRule> RULES = ImmutableList.of((Object)((Object)PROJECT), (Object)((Object)FILTER), (Object)((Object)SORT_FILTER), (Object)((Object)SORT_SCAN));

    private InnodbRules() {
    }

    static List<String> innodbFieldNames(RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)rowType.getFieldNames(), (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
    }

    public static class InnodbSortTableScanRule
    extends AbstractInnodbSortRule<InnodbSortTableScanRuleConfig> {
        protected InnodbSortTableScanRule(InnodbSortTableScanRuleConfig config) {
            super(config);
        }

        public boolean matches(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            InnodbTableScan tableScan = (InnodbTableScan)call.rel(2);
            return this.collationsCompatible(sort.getCollation(), tableScan.getImplicitCollation());
        }

        @Value.Immutable(singleton=false)
        public static interface InnodbSortTableScanRuleConfig
        extends RelRule.Config {
            public static final InnodbSortTableScanRuleConfig DEFAULT = ImmutableInnodbSortTableScanRuleConfig.builder().withOperandSupplier(b0 -> b0.operand(Sort.class).predicate(sort -> true).oneInput(b1 -> b1.operand(InnodbToEnumerableConverter.class).oneInput(b2 -> b2.operand(InnodbTableScan.class).predicate(tableScan -> true).anyInputs()))).build();

            default public InnodbSortTableScanRule toRule() {
                return new InnodbSortTableScanRule(this);
            }
        }
    }

    public static class InnodbSortFilterRule
    extends AbstractInnodbSortRule<InnodbSortFilterRuleConfig> {
        protected InnodbSortFilterRule(InnodbSortFilterRuleConfig config) {
            super(config);
        }

        public boolean matches(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            InnodbFilter filter = (InnodbFilter)call.rel(2);
            return this.collationsCompatible(sort.getCollation(), filter.getImplicitCollation());
        }

        @Value.Immutable(singleton=false)
        public static interface InnodbSortFilterRuleConfig
        extends RelRule.Config {
            public static final InnodbSortFilterRuleConfig DEFAULT = ImmutableInnodbSortFilterRuleConfig.builder().withOperandSupplier(b0 -> b0.operand(Sort.class).predicate(sort -> true).oneInput(b1 -> b1.operand(InnodbToEnumerableConverter.class).oneInput(b2 -> b2.operand(InnodbFilter.class).predicate(innodbFilter -> true).anyInputs()))).build();

            default public InnodbSortFilterRule toRule() {
                return new InnodbSortFilterRule(this);
            }
        }
    }

    private static class AbstractInnodbSortRule<C extends RelRule.Config>
    extends RelRule<C> {
        AbstractInnodbSortRule(C config) {
            super(config);
        }

        RelNode convert(Sort sort) {
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)InnodbRel.CONVENTION).replace((RelTrait)sort.getCollation());
            return new InnodbSort(sort.getCluster(), traitSet, AbstractInnodbSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation());
        }

        protected boolean collationsCompatible(RelCollation sortCollation, RelCollation implicitCollation) {
            List sortFieldCollations = sortCollation.getFieldCollations();
            List implicitFieldCollations = implicitCollation.getFieldCollations();
            if (sortFieldCollations.size() > implicitFieldCollations.size()) {
                return false;
            }
            if (sortFieldCollations.isEmpty()) {
                return true;
            }
            boolean reversed = ((RelFieldCollation)sortFieldCollations.get(0)).getDirection().reverse().lax() == ((RelFieldCollation)implicitFieldCollations.get(0)).getDirection();
            for (int i = 0; i < sortFieldCollations.size(); ++i) {
                RelFieldCollation sorted = (RelFieldCollation)sortFieldCollations.get(i);
                RelFieldCollation implied = (RelFieldCollation)implicitFieldCollations.get(i);
                if (sorted.getFieldIndex() != implied.getFieldIndex()) {
                    return false;
                }
                RelFieldCollation.Direction sortDirection = sorted.getDirection();
                RelFieldCollation.Direction implicitDirection = implied.getDirection();
                if ((reversed || sortDirection == implicitDirection) && (!reversed || sortDirection.reverse().lax() == implicitDirection)) continue;
                return false;
            }
            return true;
        }

        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            RelNode converted = this.convert(sort);
            call.transformTo(converted);
        }
    }

    public static class InnodbFilterRule
    extends RelRule<InnodbFilterRuleConfig> {
        protected InnodbFilterRule(InnodbFilterRuleConfig config) {
            super((RelRule.Config)config);
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            InnodbTableScan scan = (InnodbTableScan)call.rel(1);
            if (filter.getTraitSet().contains((RelTrait)Convention.NONE)) {
                RelNode converted = this.convert(filter, scan);
                call.transformTo(converted);
            }
        }

        RelNode convert(LogicalFilter filter, InnodbTableScan scan) {
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)InnodbRel.CONVENTION);
            TableDef tableDef = scan.innodbTable.getTableDef();
            RelOptCluster cluster = filter.getCluster();
            InnodbFilterTranslator translator = new InnodbFilterTranslator(cluster.getRexBuilder(), filter.getRowType(), tableDef, scan.getForceIndexName());
            IndexCondition indexCondition = translator.translateMatch(filter.getCondition());
            RexNode condition = RexUtil.composeConjunction((RexBuilder)cluster.getRexBuilder(), indexCondition.getPushDownConditions());
            InnodbFilter innodbFilter = InnodbFilter.create(cluster, traitSet, InnodbFilterRule.convert((RelNode)filter.getInput(), (RelTrait)InnodbRel.CONVENTION), condition, indexCondition, tableDef, scan.getForceIndexName());
            if (innodbFilter.indexCondition.canPushDown()) {
                return LogicalFilter.create((RelNode)innodbFilter, (RexNode)RexUtil.composeConjunction((RexBuilder)cluster.getRexBuilder(), indexCondition.getRemainderConditions()));
            }
            return filter;
        }

        @Value.Immutable(singleton=false)
        public static interface InnodbFilterRuleConfig
        extends RelRule.Config {
            public static final InnodbFilterRuleConfig DEFAULT = ImmutableInnodbFilterRuleConfig.builder().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(InnodbTableScan.class).noInputs())).build();

            default public InnodbFilterRule toRule() {
                return new InnodbFilterRule(this);
            }
        }
    }

    public static class InnodbProjectRule
    extends InnodbConverterRule {
        private static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)InnodbRel.CONVENTION, "InnodbProjectRule").withRuleFactory(InnodbProjectRule::new);

        protected InnodbProjectRule(ConverterRule.Config config) {
            super(config);
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            for (RexNode e : project.getProjects()) {
                if (e instanceof RexInputRef) continue;
                return false;
            }
            return project.getVariablesSet().isEmpty();
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new InnodbProject(project.getCluster(), traitSet, InnodbProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ ConverterRule.Config access$000() {
            return DEFAULT_CONFIG;
        }
    }

    static abstract class InnodbConverterRule
    extends ConverterRule {
        InnodbConverterRule(ConverterRule.Config config) {
            super(config);
        }
    }

    static class RexToInnodbTranslator
    extends RexVisitorImpl<String> {
        private final List<String> inFields;

        protected RexToInnodbTranslator(List<String> inFields) {
            super(true);
            this.inFields = inFields;
        }

        public String visitInputRef(RexInputRef inputRef) {
            return this.inFields.get(inputRef.getIndex());
        }
    }
}

