/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.schema.KeyMeta;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.calcite.adapter.innodb.IndexCondition;
import org.apache.calcite.adapter.innodb.InnodbRel;
import org.apache.calcite.adapter.innodb.InnodbRules;
import org.apache.calcite.adapter.innodb.InnodbTable;
import org.apache.calcite.adapter.innodb.QueryType;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.HintPredicates;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InnodbTableScan
extends TableScan
implements InnodbRel {
    final InnodbTable innodbTable;
    final @Nullable RelDataType projectRowType;
    private final @Nullable String forceIndexName;
    private final IndexCondition indexCondition;

    protected InnodbTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, InnodbTable innodbTable, @Nullable RelDataType projectRowType, List<RelHint> hints) {
        super(cluster, traitSet, hints, table);
        this.innodbTable = Objects.requireNonNull(innodbTable, "innodbTable");
        this.projectRowType = projectRowType;
        this.forceIndexName = this.getForceIndexName(hints).orElse(null);
        this.indexCondition = this.getIndexCondition();
        Preconditions.checkArgument((this.getConvention() == InnodbRel.CONVENTION ? 1 : 0) != 0);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public void register(RelOptPlanner planner) {
        HintStrategyTable strategies = HintStrategyTable.builder().hintStrategy("index", HintPredicates.TABLE_SCAN).build();
        this.getCluster().setHintStrategies(strategies);
        planner.addRule((RelOptRule)InnodbRules.TO_ENUMERABLE);
        for (RelOptRule rule : InnodbRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(InnodbRel.Implementor implementor) {
        implementor.innodbTable = this.innodbTable;
        implementor.table = this.table;
        implementor.setIndexCondition(this.indexCondition);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("forceIndex", (Object)this.forceIndexName, this.forceIndexName != null);
    }

    public RelCollation getImplicitCollation() {
        return this.indexCondition.getImplicitCollation();
    }

    private Optional<String> getForceIndexName(List<RelHint> hints) {
        if (hints.isEmpty()) {
            return Optional.empty();
        }
        for (RelHint hint : hints) {
            if (!"index".equalsIgnoreCase(hint.hintName) || hint.listOptions.isEmpty()) continue;
            Set<String> indexesNameSet = this.innodbTable.getIndexesNameSet();
            Optional forceIndexName = hint.listOptions.stream().findFirst();
            if (!forceIndexName.isPresent()) {
                return Optional.empty();
            }
            for (String indexName : indexesNameSet) {
                if (indexName == null || !indexName.equalsIgnoreCase((String)forceIndexName.get())) continue;
                return Optional.of(indexName);
            }
        }
        return Optional.empty();
    }

    public @Nullable String getForceIndexName() {
        return this.forceIndexName;
    }

    private IndexCondition getIndexCondition() {
        if (this.forceIndexName != null && !this.forceIndexName.equalsIgnoreCase("PRIMARY_KEY")) {
            KeyMeta skMeta = (KeyMeta)this.innodbTable.getTableDef().getSecondaryKeyMetaMap().get(this.forceIndexName);
            if (skMeta == null) {
                throw new AssertionError((Object)("secondary index not found " + this.forceIndexName));
            }
            return IndexCondition.create(InnodbRules.innodbFieldNames(this.getRowType()), this.forceIndexName, skMeta.getKeyColumnNames(), QueryType.SK_FULL_SCAN);
        }
        return IndexCondition.create(InnodbRules.innodbFieldNames(this.getRowType()), "PRIMARY_KEY", this.innodbTable.getTableDef().getPrimaryKeyColumnNames(), QueryType.PK_FULL_SCAN);
    }
}

