/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.jdbc.JavaRecordType;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.util.ReflectUtil;
import org.apache.geode.pdx.PdxInstance;

public class JavaTypeFactoryExtImpl
extends JavaTypeFactoryImpl {
    public RelDataType createStructType(Class type) {
        ArrayList<RelDataTypeFieldImpl> list = new ArrayList<RelDataTypeFieldImpl>();
        for (Field field : type.getDeclaredFields()) {
            if (ReflectUtil.isStatic((Member)field)) continue;
            Class<?> fieldType = field.getType();
            list.add(new RelDataTypeFieldImpl(field.getName(), list.size(), this.createType(fieldType)));
        }
        return this.canonize((RelDataType)new JavaRecordType(list, type));
    }

    public RelDataType createPdxType(PdxInstance pdxInstance) {
        ArrayList<RelDataTypeFieldImpl> list = new ArrayList<RelDataTypeFieldImpl>();
        for (String fieldName : pdxInstance.getFieldNames()) {
            Object field = pdxInstance.getField(fieldName);
            Class fieldType = field == null ? String.class : (field instanceof PdxInstance ? Map.class : field.getClass());
            list.add(new RelDataTypeFieldImpl(fieldName, list.size(), this.createType((Type)((Object)fieldType))));
        }
        return this.canonize((RelDataType)new RelRecordType(list));
    }

    public RelDataType createPdxType2(PdxInstance pdxInstance) {
        ArrayList<RelDataTypeField> list = new ArrayList<RelDataTypeField>();
        this.recursiveCreatePdxType(pdxInstance, list, "");
        return this.canonize((RelDataType)new RelRecordType(list));
    }

    private void recursiveCreatePdxType(PdxInstance pdxInstance, List<RelDataTypeField> list, String fieldNamePrefix) {
        for (String fieldName : pdxInstance.getFieldNames()) {
            Object field = pdxInstance.getField(fieldName);
            Class<?> fieldType = field.getClass();
            if (fieldType instanceof PdxInstance) {
                this.recursiveCreatePdxType((PdxInstance)field, list, fieldNamePrefix + fieldName + ".");
                continue;
            }
            list.add((RelDataTypeField)new RelDataTypeFieldImpl(fieldNamePrefix + fieldName, list.size(), this.createType(fieldType)));
        }
    }
}

