/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.adapter.geode.rel.GeodeRules;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeodeRules.GeodeFilterRule.GeodeFilterRuleConfig", generator="Immutables")
@Immutable
final class ImmutableGeodeFilterRuleConfig
implements GeodeRules.GeodeFilterRule.GeodeFilterRuleConfig {
    private final RelBuilderFactory relBuilderFactory;
    @Nullable
    private final String description;
    private final RelRule.OperandTransform operandSupplier;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGeodeFilterRuleConfig(Builder builder) {
        this.description = builder.description;
        if (builder.relBuilderFactory != null) {
            this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
        }
        if (builder.operandSupplier != null) {
            this.initShim.withOperandSupplier(builder.operandSupplier);
        }
        this.relBuilderFactory = this.initShim.relBuilderFactory();
        this.operandSupplier = this.initShim.operandSupplier();
        this.initShim = null;
    }

    private ImmutableGeodeFilterRuleConfig(RelBuilderFactory relBuilderFactory, @Nullable String description, RelRule.OperandTransform operandSupplier) {
        this.relBuilderFactory = relBuilderFactory;
        this.description = description;
        this.operandSupplier = operandSupplier;
        this.initShim = null;
    }

    private RelBuilderFactory relBuilderFactoryInitialize() {
        return GeodeRules.GeodeFilterRule.GeodeFilterRuleConfig.super.relBuilderFactory();
    }

    private RelRule.OperandTransform operandSupplierInitialize() {
        return GeodeRules.GeodeFilterRule.GeodeFilterRuleConfig.super.operandSupplier();
    }

    public RelBuilderFactory relBuilderFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public RelRule.OperandTransform operandSupplier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.operandSupplier() : this.operandSupplier;
    }

    public final ImmutableGeodeFilterRuleConfig withRelBuilderFactory(RelBuilderFactory value) {
        if (this.relBuilderFactory == value) {
            return this;
        }
        RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
        return new ImmutableGeodeFilterRuleConfig(newValue, this.description, this.operandSupplier);
    }

    public final ImmutableGeodeFilterRuleConfig withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableGeodeFilterRuleConfig(this.relBuilderFactory, value, this.operandSupplier);
    }

    public final ImmutableGeodeFilterRuleConfig withOperandSupplier(RelRule.OperandTransform value) {
        if (this.operandSupplier == value) {
            return this;
        }
        RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
        return new ImmutableGeodeFilterRuleConfig(this.relBuilderFactory, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeodeFilterRuleConfig && this.equalTo((ImmutableGeodeFilterRuleConfig)another);
    }

    private boolean equalTo(ImmutableGeodeFilterRuleConfig another) {
        return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relBuilderFactory.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.operandSupplier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GeodeFilterRuleConfig").omitNullValues().add("relBuilderFactory", (Object)this.relBuilderFactory).add("description", (Object)this.description).add("operandSupplier", (Object)this.operandSupplier).toString();
    }

    public static ImmutableGeodeFilterRuleConfig copyOf(GeodeRules.GeodeFilterRule.GeodeFilterRuleConfig instance) {
        if (instance instanceof ImmutableGeodeFilterRuleConfig) {
            return (ImmutableGeodeFilterRuleConfig)instance;
        }
        return ImmutableGeodeFilterRuleConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GeodeRules.GeodeFilterRule.GeodeFilterRuleConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private RelBuilderFactory relBuilderFactory;
        @Nullable
        private String description;
        @Nullable
        private RelRule.OperandTransform operandSupplier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RelRule.Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GeodeRules.GeodeFilterRule.GeodeFilterRuleConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof RelRule.Config) {
                RelRule.Config instance = (RelRule.Config)object;
                this.withRelBuilderFactory(instance.relBuilderFactory());
                this.withOperandSupplier(instance.operandSupplier());
                String descriptionValue = instance.description();
                if (descriptionValue != null) {
                    this.withDescription(descriptionValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
            this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
            this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
            return this;
        }

        public ImmutableGeodeFilterRuleConfig build() {
            return new ImmutableGeodeFilterRuleConfig(this);
        }
    }

    @Generated(from="GeodeRules.GeodeFilterRule.GeodeFilterRuleConfig", generator="Immutables")
    private final class InitShim {
        private byte relBuilderFactoryBuildStage = 0;
        private RelBuilderFactory relBuilderFactory;
        private byte operandSupplierBuildStage = 0;
        private RelRule.OperandTransform operandSupplier;

        private InitShim() {
        }

        RelBuilderFactory relBuilderFactory() {
            if (this.relBuilderFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relBuilderFactoryBuildStage == 0) {
                this.relBuilderFactoryBuildStage = (byte)-1;
                this.relBuilderFactory = Objects.requireNonNull(ImmutableGeodeFilterRuleConfig.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                this.relBuilderFactoryBuildStage = 1;
            }
            return this.relBuilderFactory;
        }

        void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
            this.relBuilderFactory = relBuilderFactory;
            this.relBuilderFactoryBuildStage = 1;
        }

        RelRule.OperandTransform operandSupplier() {
            if (this.operandSupplierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.operandSupplierBuildStage == 0) {
                this.operandSupplierBuildStage = (byte)-1;
                this.operandSupplier = Objects.requireNonNull(ImmutableGeodeFilterRuleConfig.this.operandSupplierInitialize(), "operandSupplier");
                this.operandSupplierBuildStage = 1;
            }
            return this.operandSupplier;
        }

        void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
            this.operandSupplier = operandSupplier;
            this.operandSupplierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.relBuilderFactoryBuildStage == -1) {
                attributes.add("relBuilderFactory");
            }
            if (this.operandSupplierBuildStage == -1) {
                attributes.add("operandSupplier");
            }
            return "Cannot build GeodeFilterRuleConfig, attribute initializers form cycle " + attributes;
        }
    }
}

