/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.adapter.file.FileReaderException;
import org.apache.calcite.util.Source;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FileReader
implements Iterable<Elements> {
    private final Source source;
    private final @Nullable String selector;
    private final @Nullable Integer index;
    private final Charset charset = StandardCharsets.UTF_8;
    private @Nullable Element tableElement;
    private @Nullable Elements headings;

    public FileReader(Source source, @Nullable String selector, @Nullable Integer index) {
        this.source = Objects.requireNonNull(source, "source must not be null");
        this.selector = selector;
        this.index = index;
    }

    public FileReader(Source source, String selector) {
        this(source, selector, null);
    }

    public FileReader(Source source) {
        this(source, null, null);
    }

    private void getTable() throws FileReaderException {
        Document doc;
        try {
            String proto = this.source.protocol();
            doc = "file".equals(proto) ? Jsoup.parse((File)this.source.file(), (String)this.charset.name()) : (Arrays.asList("http", "https", "ftp").contains(proto) ? Jsoup.parse((URL)this.source.url(), (int)((int)TimeUnit.SECONDS.toMillis(20L))) : Jsoup.parse((InputStream)this.source.openStream(), (String)this.charset.name(), (String)""));
        }
        catch (IOException e) {
            throw new FileReaderException("Cannot read " + this.source, e);
        }
        this.tableElement = this.selector != null && !this.selector.isEmpty() ? this.getSelectedTable(doc, this.selector) : FileReader.getBestTable(doc);
    }

    private Element getSelectedTable(Document doc, String selector) throws FileReaderException {
        Element el;
        Elements list = doc.select(selector);
        if (this.index == null) {
            if (list.size() != 1) {
                throw new FileReaderException(list.size() + " HTML element(s) selected");
            }
            el = list.first();
        } else {
            el = (Element)list.get(this.index.intValue());
        }
        if (el.tag().getName().equals("table")) {
            return el;
        }
        throw new FileReaderException("selected (" + selector + ") element is a " + el.tag().getName() + ", not a table");
    }

    private static Element getBestTable(Document doc) throws FileReaderException {
        Element bestTable = null;
        int bestScore = -1;
        for (Element t : doc.select("table")) {
            Element firstRow;
            int cols;
            int rows = t.select("tr").size();
            int thisScore = rows * (cols = (firstRow = (Element)t.select("tr").get(0)).select("th,td").size());
            if (thisScore <= bestScore) continue;
            bestTable = t;
            bestScore = thisScore;
        }
        if (bestTable == null) {
            throw new FileReaderException("no tables found");
        }
        return bestTable;
    }

    void refresh() throws FileReaderException {
        this.headings = null;
        this.getTable();
    }

    Elements getHeadings() {
        if (this.headings == null) {
            this.iterator();
        }
        return this.headings;
    }

    public FileReaderIterator iterator() {
        FileReaderIterator iterator;
        Elements headings;
        if (this.tableElement == null) {
            try {
                this.getTable();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((headings = (iterator = new FileReaderIterator(this.tableElement.select("tr"))).next("th")).isEmpty()) {
            iterator = new FileReaderIterator(this.tableElement.select("tr"));
            Elements firstRow = iterator.next("td");
            int i = 0;
            headings = new Elements();
            for (Element td : firstRow) {
                Element th = td.clone();
                th.tagName("th");
                th.html("col" + i++);
                headings.add((Object)th);
            }
            iterator = new FileReaderIterator(this.tableElement.select("tr"));
        }
        this.headings = headings;
        return iterator;
    }

    public void close() {
    }

    private static class FileReaderIterator
    implements Iterator<Elements> {
        final Iterator<Element> rowIterator;

        FileReaderIterator(Elements rows) {
            this.rowIterator = rows.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext();
        }

        Elements next(String selector) {
            Element row = this.rowIterator.next();
            return row.select(selector);
        }

        @Override
        public Elements next() {
            return this.next("th,td");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("NFW - can't remove!");
        }
    }
}

