/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.adapter.file.FileEnumerator;
import org.apache.calcite.adapter.file.FileReader;
import org.apache.calcite.adapter.file.FileRowConverter;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.util.Source;
import org.checkerframework.checker.nullness.qual.Nullable;

class FileTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final @Nullable RelProtoDataType protoRowType;
    private final FileReader reader;
    private final FileRowConverter converter;

    private FileTable(Source source, String selector, Integer index, @Nullable RelProtoDataType protoRowType, List<Map<String, Object>> fieldConfigs) {
        super(Object[].class);
        this.protoRowType = protoRowType;
        this.reader = new FileReader(source, selector, index);
        this.converter = new FileRowConverter(this.reader, fieldConfigs);
    }

    static FileTable create(Source source, Map<String, Object> tableDef) {
        List fieldConfigs = (List)tableDef.get("fields");
        String selector = (String)tableDef.get("selector");
        Integer index = (Integer)tableDef.get("index");
        return new FileTable(source, selector, index, null, fieldConfigs);
    }

    public String toString() {
        return "FileTable";
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType != null) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
        return this.converter.getRowType((JavaTypeFactory)typeFactory);
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

            public Enumerator<T> enumerator() {
                try {
                    FileEnumerator enumerator = new FileEnumerator(FileTable.this.reader.iterator(), FileTable.this.converter);
                    return enumerator;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Enumerable<Object> project(final int[] fields) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                try {
                    return new FileEnumerator(FileTable.this.reader.iterator(), FileTable.this.converter, fields);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new EnumerableTableScan(context.getCluster(), context.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), relOptTable, (Class)this.getElementType());
    }
}

