/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ElasticsearchSort
extends Sort
implements ElasticsearchRel {
    ElasticsearchSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traitSet, input, collation, offset, fetch);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        return cost.multiplyBy(0.05);
    }

    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation relCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        return new ElasticsearchSort(this.getCluster(), traitSet, input, this.collation, offset, fetch);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List fields = this.getRowType().getFieldList();
        for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
            String name = ((RelDataTypeField)fields.get(fieldCollation.getFieldIndex())).getName();
            String rawName = implementor.expressionItemMap.getOrDefault(name, name);
            implementor.addNullsSort(rawName, fieldCollation.nullDirection);
            implementor.addSort(rawName, fieldCollation.getDirection());
        }
        if (this.offset != null) {
            implementor.offset(RexLiteral.numberValue((RexNode)this.offset).longValue());
        }
        if (this.fetch != null) {
            implementor.fetch(RexLiteral.numberValue((RexNode)this.fetch).longValue());
        }
    }
}

