/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.AbstractList;
import java.util.List;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchAggregate;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchFilter;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchProject;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSort;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

class ElasticsearchRules {
    static final RelOptRule[] RULES = new RelOptRule[]{ElasticsearchSortRule.access$000(), ElasticsearchFilterRule.access$100(), ElasticsearchProjectRule.access$200(), ElasticsearchAggregateRule.access$300()};

    private ElasticsearchRules() {
    }

    private static @Nullable String isItemCall(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = (RexNode)call.getOperands().get(0);
        RexNode op1 = (RexNode)call.getOperands().get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    static boolean isItem(RexNode node) {
        Boolean result = (Boolean)node.accept((RexVisitor)new RexVisitorImpl<Boolean>(false){

            public Boolean visitCall(RexCall call) {
                return ElasticsearchRules.isItemCall(ElasticsearchRules.uncast(call)) != null;
            }
        });
        return Boolean.TRUE.equals(result);
    }

    private static RexCall uncast(RexCall maybeCast) {
        if (maybeCast.getKind() == SqlKind.CAST && maybeCast.getOperands().get(0) instanceof RexCall) {
            return ElasticsearchRules.uncast((RexCall)maybeCast.getOperands().get(0));
        }
        return maybeCast;
    }

    static List<String> elasticsearchFieldNames(final RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
    }

    static String quote(String s) {
        return "\"" + s + "\"";
    }

    static String stripQuotes(String s) {
        return s.length() > 1 && s.startsWith("\"") && s.endsWith("\"") ? s.substring(1, s.length() - 1) : s;
    }

    private static String escapeSpecialSymbols(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static class ElasticsearchProjectRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchProjectRule INSTANCE = (ElasticsearchProjectRule)ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)ElasticsearchRel.CONVENTION, "ElasticsearchProjectRule").withRuleFactory(ElasticsearchProjectRule::new).toRule(ElasticsearchProjectRule.class);

        protected ElasticsearchProjectRule(ConverterRule.Config config) {
            super(config);
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            return project.getVariablesSet().isEmpty();
        }

        public RelNode convert(RelNode relNode) {
            LogicalProject project = (LogicalProject)relNode;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new ElasticsearchProject(project.getCluster(), traitSet, ElasticsearchProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ ElasticsearchProjectRule access$200() {
            return INSTANCE;
        }
    }

    private static class ElasticsearchAggregateRule
    extends ElasticsearchConverterRule {
        private static final RelOptRule INSTANCE = ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)ElasticsearchRel.CONVENTION, "ElasticsearchAggregateRule").withRuleFactory(ElasticsearchAggregateRule::new).toRule(ElasticsearchAggregateRule.class);

        protected ElasticsearchAggregateRule(ConverterRule.Config config) {
            super(config);
        }

        public @Nullable RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)this.out);
            try {
                return new ElasticsearchAggregate(rel.getCluster(), traitSet, ElasticsearchAggregateRule.convert((RelNode)agg.getInput(), (RelTraitSet)traitSet.simplify()), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                return null;
            }
        }

        static /* synthetic */ RelOptRule access$300() {
            return INSTANCE;
        }
    }

    private static class ElasticsearchFilterRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchFilterRule INSTANCE = (ElasticsearchFilterRule)ConverterRule.Config.INSTANCE.withConversion(LogicalFilter.class, (RelTrait)Convention.NONE, (RelTrait)ElasticsearchRel.CONVENTION, "ElasticsearchFilterRule").withRuleFactory(ElasticsearchFilterRule::new).toRule(ElasticsearchFilterRule.class);

        protected ElasticsearchFilterRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode relNode) {
            LogicalFilter filter = (LogicalFilter)relNode;
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)this.out);
            return new ElasticsearchFilter(relNode.getCluster(), traitSet, ElasticsearchFilterRule.convert((RelNode)filter.getInput(), (RelTrait)this.out), filter.getCondition());
        }

        static /* synthetic */ ElasticsearchFilterRule access$100() {
            return INSTANCE;
        }
    }

    private static class ElasticsearchSortRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchSortRule INSTANCE = (ElasticsearchSortRule)ConverterRule.Config.INSTANCE.withConversion(Sort.class, (RelTrait)Convention.NONE, (RelTrait)ElasticsearchRel.CONVENTION, "ElasticsearchSortRule").withRuleFactory(ElasticsearchSortRule::new).toRule(ElasticsearchSortRule.class);

        protected ElasticsearchSortRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode relNode) {
            Sort sort = (Sort)relNode;
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)this.out).replace((RelTrait)sort.getCollation());
            return new ElasticsearchSort(relNode.getCluster(), traitSet, ElasticsearchSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), sort.offset, sort.fetch);
        }

        static /* synthetic */ ElasticsearchSortRule access$000() {
            return INSTANCE;
        }
    }

    static abstract class ElasticsearchConverterRule
    extends ConverterRule {
        protected ElasticsearchConverterRule(ConverterRule.Config config) {
            super(config);
        }
    }

    static class RexToElasticsearchTranslator
    extends RexVisitorImpl<String> {
        private final JavaTypeFactory typeFactory;
        private final List<String> inFields;

        RexToElasticsearchTranslator(JavaTypeFactory typeFactory, List<String> inFields) {
            super(true);
            this.typeFactory = typeFactory;
            this.inFields = inFields;
        }

        public String visitLiteral(RexLiteral literal) {
            if (literal.getValue() == null) {
                return "null";
            }
            return "\"literal\":" + ElasticsearchRules.quote(ElasticsearchRules.escapeSpecialSymbols(RexToLixTranslator.translateLiteral((RexLiteral)literal, (RelDataType)literal.getType(), (JavaTypeFactory)this.typeFactory, (RexImpTable.NullAs)RexImpTable.NullAs.NOT_POSSIBLE).toString()));
        }

        public String visitInputRef(RexInputRef inputRef) {
            return ElasticsearchRules.quote(this.inFields.get(inputRef.getIndex()));
        }

        public String visitCall(RexCall call) {
            RexNode op1;
            String name = ElasticsearchRules.isItemCall(call);
            if (name != null) {
                return name;
            }
            List strings = this.visitList((Iterable)call.operands);
            if (call.getKind() == SqlKind.CAST) {
                return (String)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            }
            if (call.getOperator() == SqlStdOperatorTable.ITEM && (op1 = (RexNode)call.getOperands().get(1)) instanceof RexLiteral && op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                return ElasticsearchRules.stripQuotes((String)strings.get(0)) + "[" + ((RexLiteral)op1).getValue2() + "]";
            }
            throw new IllegalArgumentException("Translation of " + call + " is not supported by ElasticsearchProject");
        }
    }
}

