/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Pair;

public interface ElasticsearchRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("ELASTICSEARCH", ElasticsearchRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        final List<String> list = new ArrayList<String>();
        final List<Map.Entry<String, RelFieldCollation.Direction>> sort = new ArrayList<Map.Entry<String, RelFieldCollation.Direction>>();
        final List<Map.Entry<String, RelFieldCollation.NullDirection>> nullsSort = new ArrayList<Map.Entry<String, RelFieldCollation.NullDirection>>();
        final List<Map.Entry<String, String>> aggregations = new ArrayList<Map.Entry<String, String>>();
        final List<String> groupBy = new ArrayList<String>();
        final Map<String, String> expressionItemMap = new LinkedHashMap<String, String>();
        Long offset;
        Long fetch;
        RelOptTable table;
        ElasticsearchTable elasticsearchTable;

        void add(String findOp) {
            this.list.add(findOp);
        }

        void addGroupBy(String field) {
            Objects.requireNonNull(field, "field");
            this.groupBy.add(field);
        }

        void addSort(String field, RelFieldCollation.Direction direction) {
            Objects.requireNonNull(field, "field");
            this.sort.add((Map.Entry<String, RelFieldCollation.Direction>)Pair.of((Object)field, (Object)direction));
        }

        void addNullsSort(String field, RelFieldCollation.NullDirection nullDirection) {
            Objects.requireNonNull(field, "field");
            this.nullsSort.add((Map.Entry<String, RelFieldCollation.NullDirection>)new Pair((Object)field, (Object)nullDirection));
        }

        void addAggregation(String field, String expression) {
            Objects.requireNonNull(field, "field");
            Objects.requireNonNull(expression, "expression");
            this.aggregations.add((Map.Entry<String, String>)Pair.of((Object)field, (Object)expression));
        }

        void addExpressionItemMapping(String expressionId, String item) {
            Objects.requireNonNull(expressionId, "expressionId");
            Objects.requireNonNull(item, "item");
            this.expressionItemMap.put(expressionId, item);
        }

        void offset(long offset) {
            this.offset = offset;
        }

        void fetch(long fetch) {
            this.fetch = fetch;
        }

        void visitChild(int ordinal, RelNode input) {
            assert (ordinal == 0);
            ((ElasticsearchRel)input).implement(this);
        }
    }
}

