/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.adapter.csv.CsvSchema;
import org.apache.calcite.adapter.csv.CsvTable;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;

public class CsvSchemaFactory
implements SchemaFactory {
    public static final CsvSchemaFactory INSTANCE = new CsvSchemaFactory();

    private CsvSchemaFactory() {
    }

    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        String flavorName;
        String directory = (String)operand.get("directory");
        File base = (File)operand.get(ModelHandler.ExtraOperand.BASE_DIRECTORY.camelName);
        File directoryFile = new File(directory);
        if (base != null && !directoryFile.isAbsolute()) {
            directoryFile = new File(base, directory);
        }
        CsvTable.Flavor flavor = (flavorName = (String)operand.get("flavor")) == null ? CsvTable.Flavor.SCANNABLE : CsvTable.Flavor.valueOf(flavorName.toUpperCase(Locale.ROOT));
        return new CsvSchema(directoryFile, flavor);
    }
}

