/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.csv.CsvRules;
import org.apache.calcite.adapter.csv.CsvTranslatableTable;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CsvTableScan
extends TableScan
implements EnumerableRel {
    final CsvTranslatableTable csvTable;
    final int[] fields;

    protected CsvTableScan(RelOptCluster cluster, RelOptTable table, CsvTranslatableTable csvTable, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (List)ImmutableList.of(), table);
        this.csvTable = Objects.requireNonNull(csvTable, "csvTable");
        this.fields = fields;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return new CsvTableScan(this.getCluster(), this.table, this.csvTable, this.fields);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("fields", (Object)Primitive.asList((int[])this.fields));
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int field : this.fields) {
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return builder.build();
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)CsvRules.PROJECT_SCAN);
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        return cost.multiplyBy(((double)this.fields.length + 2.0) / ((double)this.table.getRowType().getFieldCount() + 2.0));
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)Objects.requireNonNull(this.table.getExpression(CsvTranslatableTable.class)), (String)"project", (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.fields)})));
    }
}

