/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaClientRuntimeException;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.com.google.protobuf.Descriptors;
import org.apache.calcite.avatica.com.google.protobuf.Message;
import org.apache.calcite.avatica.com.google.protobuf.ProtocolStringList;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.proto.Requests;
import org.apache.calcite.avatica.proto.Responses;
import org.apache.calcite.avatica.remote.ProtobufService;
import org.apache.calcite.avatica.remote.TypedValue;

public interface Service {
    public ResultSetResponse apply(CatalogsRequest var1);

    public ResultSetResponse apply(SchemasRequest var1);

    public ResultSetResponse apply(TablesRequest var1);

    public ResultSetResponse apply(TableTypesRequest var1);

    public ResultSetResponse apply(TypeInfoRequest var1);

    public ResultSetResponse apply(ColumnsRequest var1);

    public PrepareResponse apply(PrepareRequest var1);

    public ExecuteResponse apply(ExecuteRequest var1);

    public ExecuteResponse apply(PrepareAndExecuteRequest var1);

    public SyncResultsResponse apply(SyncResultsRequest var1);

    public FetchResponse apply(FetchRequest var1);

    public CreateStatementResponse apply(CreateStatementRequest var1);

    public CloseStatementResponse apply(CloseStatementRequest var1);

    public OpenConnectionResponse apply(OpenConnectionRequest var1);

    public CloseConnectionResponse apply(CloseConnectionRequest var1);

    public ConnectionSyncResponse apply(ConnectionSyncRequest var1);

    public DatabasePropertyResponse apply(DatabasePropertyRequest var1);

    public static class SyncResultsResponse
    extends Response {
        public boolean missingStatement = false;
        public final boolean moreResults;

        SyncResultsResponse() {
            this.moreResults = false;
        }

        public SyncResultsResponse(@JsonProperty(value="moreResults") boolean moreResults, @JsonProperty(value="missingStatement") boolean missingStatement) {
            this.moreResults = moreResults;
            this.missingStatement = missingStatement;
        }

        @Override
        SyncResultsResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.SyncResultsResponse)) {
                throw new IllegalArgumentException("Expected SyncResultsResponse, but got " + genericMsg.getClass().getName());
            }
            Responses.SyncResultsResponse msg = (Responses.SyncResultsResponse)genericMsg;
            return new SyncResultsResponse(msg.getMoreResults(), msg.getMissingStatement());
        }

        @Override
        Responses.SyncResultsResponse serialize() {
            Responses.SyncResultsResponse.Builder builder = Responses.SyncResultsResponse.newBuilder();
            return builder.setMoreResults(this.moreResults).setMissingStatement(this.missingStatement).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.missingStatement ? 1231 : 1237);
            result = 31 * result + (this.moreResults ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof SyncResultsResponse)) {
                return false;
            }
            SyncResultsResponse other = (SyncResultsResponse)obj;
            return this.missingStatement == other.missingStatement && this.moreResults == other.moreResults;
        }
    }

    public static class SyncResultsRequest
    extends Request {
        public final String connectionId;
        public final int statementId;
        public final QueryState state;
        public final long offset;

        SyncResultsRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.state = null;
            this.offset = 0L;
        }

        public SyncResultsRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="state") QueryState state, @JsonProperty(value="offset") long offset) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.state = state;
            this.offset = offset;
        }

        @Override
        SyncResultsResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        Request deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.SyncResultsRequest)) {
                throw new IllegalArgumentException("Expected SyncResultsRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.SyncResultsRequest msg = (Requests.SyncResultsRequest)genericMsg;
            return new SyncResultsRequest(msg.getConnectionId(), msg.getStatementId(), QueryState.fromProto(msg.getState()), msg.getOffset());
        }

        @Override
        Requests.SyncResultsRequest serialize() {
            Requests.SyncResultsRequest.Builder builder = Requests.SyncResultsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.state) {
                builder.setState(this.state.toProto());
            }
            builder.setStatementId(this.statementId);
            builder.setOffset(this.offset);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !(obj instanceof SyncResultsRequest)) {
                return false;
            }
            SyncResultsRequest other = (SyncResultsRequest)obj;
            if (this.connectionId == null ? other.connectionId != null : !this.connectionId.equals(other.connectionId)) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
                return false;
            }
            return this.statementId == other.statementId;
        }
    }

    public static class ErrorResponse
    extends Response {
        public static final int UNKNOWN_ERROR_CODE = -1;
        public static final int MISSING_CONNECTION_ERROR_CODE = 1;
        public static final String UNKNOWN_SQL_STATE = "00000";
        public final List<String> exceptions;
        public final String errorMessage;
        public final int errorCode;
        public final String sqlState;
        public final AvaticaSeverity severity;

        ErrorResponse() {
            this.exceptions = Collections.singletonList("Unhandled exception");
            this.errorMessage = "Unknown message";
            this.errorCode = -1;
            this.sqlState = UNKNOWN_SQL_STATE;
            this.severity = AvaticaSeverity.UNKNOWN;
        }

        @JsonCreator
        public ErrorResponse(@JsonProperty(value="exceptions") List<String> exceptions, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="sqlState") String sqlState, @JsonProperty(value="severity") AvaticaSeverity severity) {
            this.exceptions = exceptions;
            this.errorMessage = errorMessage;
            this.errorCode = errorCode;
            this.sqlState = sqlState;
            this.severity = severity;
        }

        protected ErrorResponse(Exception e, String errorMessage, int code, String sqlState, AvaticaSeverity severity) {
            this(errorMessage, code, sqlState, severity, ErrorResponse.toStackTraces(e));
        }

        protected ErrorResponse(String errorMessage, int code, String sqlState, AvaticaSeverity severity, List<String> exceptions) {
            this.exceptions = exceptions;
            this.errorMessage = errorMessage;
            this.errorCode = code;
            this.sqlState = sqlState;
            this.severity = severity;
        }

        static List<String> toStackTraces(Exception e) {
            ArrayList<String> stackTraces = new ArrayList<String>();
            stackTraces.add(ErrorResponse.toString(e));
            if (e instanceof SQLException) {
                for (SQLException next = ((SQLException)e).getNextException(); null != next; next = next.getNextException()) {
                    stackTraces.add(ErrorResponse.toString(next));
                }
            }
            return stackTraces;
        }

        static String toString(Exception e) {
            StringWriter sw = new StringWriter();
            Objects.requireNonNull(e).printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }

        @Override
        ErrorResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.ErrorResponse)) {
                throw new IllegalArgumentException("Expected ErrorResponse, but got " + genericMsg.getClass());
            }
            Responses.ErrorResponse msg = (Responses.ErrorResponse)genericMsg;
            return new ErrorResponse(msg.getExceptionsList(), msg.getErrorMessage(), msg.getErrorCode(), msg.getSqlState(), AvaticaSeverity.fromProto(msg.getSeverity()));
        }

        @Override
        Responses.ErrorResponse serialize() {
            Responses.ErrorResponse.Builder builder = Responses.ErrorResponse.newBuilder();
            return builder.addAllExceptions(this.exceptions).setErrorMessage(this.errorMessage).setErrorCode(this.errorCode).setSqlState(this.sqlState).setSeverity(this.severity.toProto()).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exceptions == null ? 0 : this.exceptions.hashCode());
            result = 31 * result + this.errorCode;
            result = 31 * result + (this.sqlState == null ? 0 : this.sqlState.hashCode());
            result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ErrorResponse)) {
                return false;
            }
            ErrorResponse other = (ErrorResponse)obj;
            if (this.exceptions == null ? other.exceptions != null : !this.exceptions.equals(other.exceptions)) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.sqlState == null ? other.sqlState != null : !this.sqlState.equals(other.sqlState)) {
                return false;
            }
            return this.severity == other.severity;
        }

        public AvaticaClientRuntimeException toException() {
            return new AvaticaClientRuntimeException("Remote driver error: " + this.errorMessage, this.errorCode, this.sqlState, this.severity, this.exceptions);
        }
    }

    public static class DatabasePropertyResponse
    extends Response {
        public final Map<Meta.DatabaseProperty, Object> map;

        DatabasePropertyResponse() {
            this.map = null;
        }

        @JsonCreator
        public DatabasePropertyResponse(@JsonProperty(value="map") Map<Meta.DatabaseProperty, Object> map) {
            this.map = map;
        }

        @Override
        DatabasePropertyResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.DatabasePropertyResponse)) {
                throw new IllegalArgumentException("Expected DatabasePropertyResponse, but got " + genericMsg.getClass().getName());
            }
            Responses.DatabasePropertyResponse msg = (Responses.DatabasePropertyResponse)genericMsg;
            HashMap<Meta.DatabaseProperty, Object> properties = new HashMap<Meta.DatabaseProperty, Object>();
            for (Responses.DatabasePropertyElement property : msg.getPropsList()) {
                Object obj;
                Meta.DatabaseProperty dbProp = Meta.DatabaseProperty.fromProto(property.getKey());
                Common.TypedValue value = property.getValue();
                switch (dbProp) {
                    case GET_NUMERIC_FUNCTIONS: 
                    case GET_STRING_FUNCTIONS: 
                    case GET_SYSTEM_FUNCTIONS: 
                    case GET_TIME_DATE_FUNCTIONS: 
                    case GET_S_Q_L_KEYWORDS: {
                        if (Common.Rep.STRING != value.getType()) {
                            throw new IllegalArgumentException("Expected STRING, but got " + value.getType());
                        }
                        obj = value.getStringValue();
                        break;
                    }
                    case GET_DEFAULT_TRANSACTION_ISOLATION: {
                        if (Common.Rep.INTEGER != value.getType()) {
                            throw new IllegalArgumentException("Expected INTEGER, but got " + value.getType());
                        }
                        obj = (int)value.getNumberValue();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled DatabaseProperty");
                    }
                }
                properties.put(dbProp, obj);
            }
            return new DatabasePropertyResponse(properties);
        }

        @Override
        Responses.DatabasePropertyResponse serialize() {
            Responses.DatabasePropertyResponse.Builder builder = Responses.DatabasePropertyResponse.newBuilder();
            if (null != this.map) {
                for (Map.Entry<Meta.DatabaseProperty, Object> entry : this.map.entrySet()) {
                    Object obj = entry.getValue();
                    Common.TypedValue.Builder valueBuilder = Common.TypedValue.newBuilder();
                    switch (entry.getKey()) {
                        case GET_NUMERIC_FUNCTIONS: 
                        case GET_STRING_FUNCTIONS: 
                        case GET_SYSTEM_FUNCTIONS: 
                        case GET_TIME_DATE_FUNCTIONS: 
                        case GET_S_Q_L_KEYWORDS: {
                            if (!(obj instanceof String)) {
                                throw new RuntimeException("Expected a String, but got " + obj.getClass());
                            }
                            valueBuilder.setType(Common.Rep.STRING).setStringValue((String)obj);
                            break;
                        }
                        case GET_DEFAULT_TRANSACTION_ISOLATION: {
                            if (!(obj instanceof Integer)) {
                                throw new RuntimeException("Expected an Integer, but got " + obj.getClass());
                            }
                            valueBuilder.setType(Common.Rep.INTEGER).setNumberValue(((Integer)obj).longValue());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unhandled DatabaseProperty");
                        }
                    }
                    builder.addProps(Responses.DatabasePropertyElement.newBuilder().setKey(entry.getKey().toProto()).setValue(valueBuilder.build()));
                }
            }
            return builder.build();
        }

        public int hashCode() {
            if (null == this.map) {
                return 0;
            }
            return this.map.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DatabasePropertyResponse) {
                DatabasePropertyResponse other = (DatabasePropertyResponse)o;
                return !(null == this.map ? null != other.map : !this.map.equals(other.map));
            }
            return false;
        }
    }

    public static class ConnectionSyncResponse
    extends Response {
        public final Meta.ConnectionProperties connProps;

        ConnectionSyncResponse() {
            this.connProps = null;
        }

        @JsonCreator
        public ConnectionSyncResponse(@JsonProperty(value="connProps") Meta.ConnectionProperties connProps) {
            this.connProps = connProps;
        }

        @Override
        ConnectionSyncResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.ConnectionSyncResponse)) {
                throw new IllegalArgumentException("Expected ConnectionSyncResponse, but got " + genericMsg.getClass().getName());
            }
            Responses.ConnectionSyncResponse msg = (Responses.ConnectionSyncResponse)genericMsg;
            return new ConnectionSyncResponse(ConnectionPropertiesImpl.fromProto(msg.getConnProps()));
        }

        @Override
        Responses.ConnectionSyncResponse serialize() {
            Responses.ConnectionSyncResponse.Builder builder = Responses.ConnectionSyncResponse.newBuilder();
            if (null != this.connProps) {
                builder.setConnProps(this.connProps.toProto());
            }
            return builder.build();
        }

        public int hashCode() {
            if (null == this.connProps) {
                return 0;
            }
            return this.connProps.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConnectionSyncResponse) {
                ConnectionSyncResponse other = (ConnectionSyncResponse)o;
                return !(null == this.connProps ? null != other.connProps : !this.connProps.equals(other.connProps));
            }
            return false;
        }
    }

    public static class ConnectionSyncRequest
    extends Request {
        public final String connectionId;
        public final Meta.ConnectionProperties connProps;

        ConnectionSyncRequest() {
            this.connectionId = null;
            this.connProps = null;
        }

        @JsonCreator
        public ConnectionSyncRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="connProps") Meta.ConnectionProperties connProps) {
            this.connectionId = connectionId;
            this.connProps = connProps;
        }

        @Override
        ConnectionSyncResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ConnectionSyncRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.ConnectionSyncRequest)) {
                throw new IllegalArgumentException("Expected ConnectionSyncRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.ConnectionSyncRequest msg = (Requests.ConnectionSyncRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            ConnectionPropertiesImpl connProps = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                connProps = ConnectionPropertiesImpl.fromProto(msg.getConnProps());
            }
            return new ConnectionSyncRequest(connectionId, connProps);
        }

        @Override
        Requests.ConnectionSyncRequest serialize() {
            Requests.ConnectionSyncRequest.Builder builder = Requests.ConnectionSyncRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.connProps) {
                builder.setConnProps(this.connProps.toProto());
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connProps == null ? 0 : this.connProps.hashCode());
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConnectionSyncRequest) {
                ConnectionSyncRequest other = (ConnectionSyncRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return !(null == this.connProps ? null != other.connProps : !this.connProps.equals(other.connProps));
            }
            return false;
        }
    }

    public static class CloseConnectionResponse
    extends Response {
        @JsonCreator
        public CloseConnectionResponse() {
        }

        @Override
        CloseConnectionResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.CloseConnectionResponse)) {
                throw new IllegalArgumentException("Expected CloseConnectionResponse, but got " + genericMsg.getClass().getName());
            }
            return new CloseConnectionResponse();
        }

        @Override
        Responses.CloseConnectionResponse serialize() {
            return Responses.CloseConnectionResponse.newBuilder().build();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof CloseConnectionResponse;
        }
    }

    public static class CloseConnectionRequest
    extends Request {
        public final String connectionId;

        CloseConnectionRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CloseConnectionRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CloseConnectionResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CloseConnectionRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.CloseConnectionRequest)) {
                throw new IllegalArgumentException("Expected CloseConnectionRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.CloseConnectionRequest msg = (Requests.CloseConnectionRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CloseConnectionRequest(connectionId);
        }

        @Override
        Requests.CloseConnectionRequest serialize() {
            Requests.CloseConnectionRequest.Builder builder = Requests.CloseConnectionRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CloseConnectionRequest) {
                CloseConnectionRequest other = (CloseConnectionRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class OpenConnectionResponse
    extends Response {
        @JsonCreator
        public OpenConnectionResponse() {
        }

        @Override
        OpenConnectionResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.OpenConnectionResponse)) {
                throw new IllegalArgumentException("Expected OpenConnectionResponse, but got " + genericMsg.getClass().getName());
            }
            return new OpenConnectionResponse();
        }

        @Override
        Responses.OpenConnectionResponse serialize() {
            return Responses.OpenConnectionResponse.newBuilder().build();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof OpenConnectionResponse;
        }
    }

    public static class OpenConnectionRequest
    extends Request {
        public final String connectionId;
        public final Map<String, String> info;

        public OpenConnectionRequest() {
            this.connectionId = null;
            this.info = null;
        }

        @JsonCreator
        public OpenConnectionRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="info") Map<String, String> info) {
            this.connectionId = connectionId;
            this.info = info;
        }

        @Override
        OpenConnectionResponse accept(Service service) {
            return service.apply(this);
        }

        public static Map<String, String> serializeProperties(Properties props) {
            HashMap<String, String> infoAsString = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                boolean localProperty = false;
                for (BuiltInConnectionProperty prop : BuiltInConnectionProperty.values()) {
                    if (!prop.camelName().equals(entry.getKey())) continue;
                    localProperty = true;
                    break;
                }
                if (localProperty) continue;
                infoAsString.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return infoAsString;
        }

        @Override
        Request deserialize(Message genericMsg) {
            Map<String, String> info;
            if (!(genericMsg instanceof Requests.OpenConnectionRequest)) {
                throw new IllegalArgumentException("Expected OpenConnectionRequest, but got" + genericMsg.getClass().getName());
            }
            Requests.OpenConnectionRequest msg = (Requests.OpenConnectionRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            if ((info = msg.getInfo()).isEmpty()) {
                info = null;
            }
            return new OpenConnectionRequest(connectionId, info);
        }

        @Override
        Message serialize() {
            Requests.OpenConnectionRequest.Builder builder = Requests.OpenConnectionRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.info) {
                builder.getMutableInfo().putAll(this.info);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof OpenConnectionRequest) {
                OpenConnectionRequest other = (OpenConnectionRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return !(null == this.info ? null != other.info : !this.info.equals(other.info));
            }
            return false;
        }
    }

    public static class CloseStatementResponse
    extends Response {
        @JsonCreator
        public CloseStatementResponse() {
        }

        @Override
        CloseStatementResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.CloseStatementResponse)) {
                throw new IllegalArgumentException("Expected CloseStatementResponse, but got " + genericMsg.getClass().getName());
            }
            return new CloseStatementResponse();
        }

        @Override
        Responses.CloseStatementResponse serialize() {
            return Responses.CloseStatementResponse.newBuilder().build();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof CloseStatementResponse;
        }
    }

    public static class CloseStatementRequest
    extends Request {
        public final String connectionId;
        public final int statementId;

        CloseStatementRequest() {
            this.connectionId = null;
            this.statementId = 0;
        }

        @JsonCreator
        public CloseStatementRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId) {
            this.connectionId = connectionId;
            this.statementId = statementId;
        }

        @Override
        CloseStatementResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CloseStatementRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.CloseStatementRequest)) {
                throw new IllegalArgumentException("Expected CloseStatementRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.CloseStatementRequest msg = (Requests.CloseStatementRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CloseStatementRequest(connectionId, msg.getStatementId());
        }

        @Override
        Requests.CloseStatementRequest serialize() {
            Requests.CloseStatementRequest.Builder builder = Requests.CloseStatementRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.setStatementId(this.statementId).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CloseStatementRequest) {
                CloseStatementRequest other = (CloseStatementRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return this.statementId == other.statementId;
            }
            return false;
        }
    }

    public static class CreateStatementResponse
    extends Response {
        public final String connectionId;
        public final int statementId;

        CreateStatementResponse() {
            this.connectionId = null;
            this.statementId = 0;
        }

        @JsonCreator
        public CreateStatementResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId) {
            this.connectionId = connectionId;
            this.statementId = statementId;
        }

        @Override
        CreateStatementResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.CreateStatementResponse)) {
                throw new IllegalArgumentException("Expected CreateStatementResponse, but got " + genericMsg.getClass().getName());
            }
            Responses.CreateStatementResponse msg = (Responses.CreateStatementResponse)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CreateStatementResponse(connectionId, msg.getStatementId());
        }

        @Override
        Responses.CreateStatementResponse serialize() {
            Responses.CreateStatementResponse.Builder builder = Responses.CreateStatementResponse.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            builder.setStatementId(this.statementId);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CreateStatementResponse) {
                CreateStatementResponse other = (CreateStatementResponse)o;
                if (this.connectionId == null ? other.connectionId != null : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return this.statementId == other.statementId;
            }
            return false;
        }
    }

    public static class CreateStatementRequest
    extends Request {
        public final String connectionId;

        CreateStatementRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CreateStatementRequest(@JsonProperty(value="signature") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CreateStatementResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CreateStatementRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.CreateStatementRequest)) {
                throw new IllegalArgumentException("Expected CreateStatementRequest, but got" + genericMsg.getClass().getName());
            }
            Requests.CreateStatementRequest msg = (Requests.CreateStatementRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CreateStatementRequest(connectionId);
        }

        @Override
        Requests.CreateStatementRequest serialize() {
            Requests.CreateStatementRequest.Builder builder = Requests.CreateStatementRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CreateStatementRequest) {
                CreateStatementRequest other = (CreateStatementRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class FetchResponse
    extends Response {
        public final Meta.Frame frame;
        public boolean missingStatement = false;
        public boolean missingResults = false;

        FetchResponse() {
            this.frame = null;
        }

        @JsonCreator
        public FetchResponse(@JsonProperty(value="frame") Meta.Frame frame, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="missingResults") boolean missingResults) {
            this.frame = frame;
            this.missingStatement = missingStatement;
            this.missingResults = missingResults;
        }

        @Override
        FetchResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.FetchResponse)) {
                throw new IllegalArgumentException("Expected FetchResponse, but got" + genericMsg.getClass().getName());
            }
            Responses.FetchResponse msg = (Responses.FetchResponse)genericMsg;
            return new FetchResponse(Meta.Frame.fromProto(msg.getFrame()), msg.getMissingStatement(), msg.getMissingResults());
        }

        @Override
        Responses.FetchResponse serialize() {
            Responses.FetchResponse.Builder builder = Responses.FetchResponse.newBuilder();
            if (null != this.frame) {
                builder.setFrame(this.frame.toProto());
            }
            return builder.setMissingStatement(this.missingStatement).setMissingResults(this.missingResults).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.frame == null ? 0 : this.frame.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof FetchResponse) {
                FetchResponse other = (FetchResponse)o;
                if (this.frame == null ? other.frame != null : !this.frame.equals(other.frame)) {
                    return false;
                }
                return this.missingStatement == other.missingStatement;
            }
            return false;
        }
    }

    public static class FetchRequest
    extends Request {
        public final String connectionId;
        public final int statementId;
        public final long offset;
        public final int fetchMaxRowCount;

        FetchRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.offset = 0L;
            this.fetchMaxRowCount = 0;
        }

        @JsonCreator
        public FetchRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="offset") long offset, @JsonProperty(value="fetchMaxRowCount") int fetchMaxRowCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.offset = offset;
            this.fetchMaxRowCount = fetchMaxRowCount;
        }

        @Override
        FetchResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        FetchRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.FetchRequest)) {
                throw new IllegalArgumentException("Expected FetchRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.FetchRequest msg = (Requests.FetchRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new FetchRequest(connectionId, msg.getStatementId(), msg.getOffset(), msg.getFetchMaxRowCount());
        }

        @Override
        Requests.FetchRequest serialize() {
            Requests.FetchRequest.Builder builder = Requests.FetchRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            builder.setStatementId(this.statementId);
            builder.setOffset(this.offset);
            builder.setFetchMaxRowCount(this.fetchMaxRowCount);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.fetchMaxRowCount;
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof FetchRequest) {
                FetchRequest other = (FetchRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return this.offset == other.offset && this.fetchMaxRowCount == other.fetchMaxRowCount;
            }
            return false;
        }
    }

    public static class PrepareResponse
    extends Response {
        public final Meta.StatementHandle statement;

        PrepareResponse() {
            this.statement = null;
        }

        @JsonCreator
        public PrepareResponse(@JsonProperty(value="statement") Meta.StatementHandle statement) {
            this.statement = statement;
        }

        @Override
        PrepareResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.PrepareResponse)) {
                throw new IllegalArgumentException("Expected PrepareResponse, but got " + genericMsg.getClass().getName());
            }
            Responses.PrepareResponse msg = (Responses.PrepareResponse)genericMsg;
            return new PrepareResponse(Meta.StatementHandle.fromProto(msg.getStatement()));
        }

        @Override
        Responses.PrepareResponse serialize() {
            Responses.PrepareResponse.Builder builder = Responses.PrepareResponse.newBuilder();
            if (null != this.statement) {
                builder.setStatement(this.statement.toProto());
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PrepareResponse) {
                PrepareResponse other = (PrepareResponse)o;
                return !(this.statement == null ? other.statement != null : !this.statement.equals(other.statement));
            }
            return false;
        }
    }

    public static class PrepareRequest
    extends Request {
        public final String connectionId;
        public final String sql;
        public final long maxRowCount;

        PrepareRequest() {
            this.connectionId = null;
            this.sql = null;
            this.maxRowCount = 0L;
        }

        @JsonCreator
        public PrepareRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.connectionId = connectionId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        @Override
        PrepareResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        PrepareRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.PrepareRequest)) {
                throw new IllegalArgumentException("Expected PrepareRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.PrepareRequest msg = (Requests.PrepareRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            String sql = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                sql = msg.getSql();
            }
            return new PrepareRequest(connectionId, sql, msg.getMaxRowCount());
        }

        @Override
        Requests.PrepareRequest serialize() {
            Requests.PrepareRequest.Builder builder = Requests.PrepareRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.sql) {
                builder.setSql(this.sql);
            }
            return builder.setMaxRowCount(this.maxRowCount).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (int)(this.maxRowCount ^ this.maxRowCount >>> 32);
            result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PrepareRequest) {
                PrepareRequest other = (PrepareRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.sql ? null != other.sql : !this.sql.equals(other.sql)) {
                    return false;
                }
                return this.maxRowCount == other.maxRowCount;
            }
            return false;
        }
    }

    public static class ExecuteResponse
    extends Response {
        public final List<ResultSetResponse> results;
        public boolean missingStatement = false;

        ExecuteResponse() {
            this.results = null;
        }

        @JsonCreator
        public ExecuteResponse(@JsonProperty(value="resultSets") List<ResultSetResponse> results, @JsonProperty(value="missingStatement") boolean missingStatement) {
            this.results = results;
            this.missingStatement = missingStatement;
        }

        @Override
        ExecuteResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.ExecuteResponse)) {
                throw new IllegalArgumentException("Expected ExecuteResponse, but got " + genericMsg.getClass().getName());
            }
            Responses.ExecuteResponse msg = (Responses.ExecuteResponse)genericMsg;
            List<Responses.ResultSetResponse> msgResults = msg.getResultsList();
            ArrayList<ResultSetResponse> copiedResults = new ArrayList<ResultSetResponse>(msgResults.size());
            for (Responses.ResultSetResponse msgResult : msgResults) {
                copiedResults.add(ResultSetResponse.fromProto(msgResult));
            }
            return new ExecuteResponse(copiedResults, msg.getMissingStatement());
        }

        @Override
        Responses.ExecuteResponse serialize() {
            Responses.ExecuteResponse.Builder builder = Responses.ExecuteResponse.newBuilder();
            for (ResultSetResponse result : this.results) {
                builder.addResults(result.serialize());
            }
            return builder.setMissingStatement(this.missingStatement).build();
        }

        public int hashCode() {
            if (null == this.results) {
                return 0;
            }
            return this.results.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ExecuteResponse) {
                ExecuteResponse other = (ExecuteResponse)o;
                return !(null == this.results ? null != other.results : !this.results.equals(other.results));
            }
            return false;
        }
    }

    public static class ExecuteRequest
    extends Request {
        public final Meta.StatementHandle statementHandle;
        public final List<TypedValue> parameterValues;
        public final long maxRowCount;

        ExecuteRequest() {
            this.statementHandle = null;
            this.parameterValues = null;
            this.maxRowCount = 0L;
        }

        @JsonCreator
        public ExecuteRequest(@JsonProperty(value="statementHandle") Meta.StatementHandle statementHandle, @JsonProperty(value="parameterValues") List<TypedValue> parameterValues, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.statementHandle = statementHandle;
            this.parameterValues = parameterValues;
            this.maxRowCount = maxRowCount;
        }

        @Override
        ExecuteResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ExecuteRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.ExecuteRequest)) {
                throw new IllegalArgumentException("Expected ExecuteRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.ExecuteRequest msg = (Requests.ExecuteRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            Meta.StatementHandle statemetnHandle = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                statemetnHandle = Meta.StatementHandle.fromProto(msg.getStatementHandle());
            }
            ArrayList<TypedValue> values = null;
            if (msg.getHasParameterValues()) {
                values = new ArrayList<TypedValue>(msg.getParameterValuesCount());
                for (Common.TypedValue valueProto : msg.getParameterValuesList()) {
                    values.add(TypedValue.fromProto(valueProto));
                }
            }
            return new ExecuteRequest(statemetnHandle, values, msg.getMaxRowCount());
        }

        @Override
        Requests.ExecuteRequest serialize() {
            Requests.ExecuteRequest.Builder builder = Requests.ExecuteRequest.newBuilder();
            if (null != this.statementHandle) {
                builder.setStatementHandle(this.statementHandle.toProto());
            }
            if (null != this.parameterValues) {
                builder.setHasParameterValues(true);
                for (TypedValue paramValue : this.parameterValues) {
                    if (paramValue == null) {
                        builder.addParameterValues(TypedValue.NULL.toProto());
                        continue;
                    }
                    builder.addParameterValues(paramValue.toProto());
                }
            } else {
                builder.setHasParameterValues(false);
            }
            builder.setMaxRowCount(this.maxRowCount);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.statementHandle == null ? 0 : this.statementHandle.hashCode());
            result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
            result = 31 * result + (int)(this.maxRowCount ^ this.maxRowCount >>> 32);
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ExecuteRequest) {
                ExecuteRequest other = (ExecuteRequest)o;
                if (this.statementHandle == null ? other.statementHandle != null : !this.statementHandle.equals(other.statementHandle)) {
                    return false;
                }
                if (null == this.parameterValues ? null != other.parameterValues : !this.parameterValues.equals(other.parameterValues)) {
                    return false;
                }
                return this.maxRowCount == other.maxRowCount;
            }
            return false;
        }
    }

    public static class PrepareAndExecuteRequest
    extends Request {
        public final String connectionId;
        public final String sql;
        public final long maxRowCount;
        public final int statementId;

        PrepareAndExecuteRequest() {
            this.connectionId = null;
            this.sql = null;
            this.maxRowCount = 0L;
            this.statementId = 0;
        }

        @JsonCreator
        public PrepareAndExecuteRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        @Override
        ExecuteResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        PrepareAndExecuteRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.PrepareAndExecuteRequest)) {
                throw new IllegalArgumentException("Expected PrepareAndExecuteRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.PrepareAndExecuteRequest msg = (Requests.PrepareAndExecuteRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            String sql = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                sql = msg.getSql();
            }
            return new PrepareAndExecuteRequest(connectionId, msg.getStatementId(), sql, msg.getMaxRowCount());
        }

        @Override
        Requests.PrepareAndExecuteRequest serialize() {
            Requests.PrepareAndExecuteRequest.Builder builder = Requests.PrepareAndExecuteRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.sql) {
                builder.setSql(this.sql);
            }
            builder.setStatementId(this.statementId);
            builder.setMaxRowCount(this.maxRowCount);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (int)(this.maxRowCount ^ this.maxRowCount >>> 32);
            result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PrepareAndExecuteRequest) {
                PrepareAndExecuteRequest other = (PrepareAndExecuteRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.sql ? null != other.sql : !this.sql.equals(other.sql)) {
                    return false;
                }
                return this.statementId == other.statementId && this.maxRowCount == other.maxRowCount;
            }
            return false;
        }
    }

    public static class ResultSetResponse
    extends Response {
        public final String connectionId;
        public final int statementId;
        public final boolean ownStatement;
        public final Meta.Signature signature;
        public final Meta.Frame firstFrame;
        public final long updateCount;

        ResultSetResponse() {
            this.connectionId = null;
            this.statementId = 0;
            this.ownStatement = false;
            this.signature = null;
            this.firstFrame = null;
            this.updateCount = 0L;
        }

        @JsonCreator
        public ResultSetResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="ownStatement") boolean ownStatement, @JsonProperty(value="signature") Meta.Signature signature, @JsonProperty(value="firstFrame") Meta.Frame firstFrame, @JsonProperty(value="updateCount") long updateCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.ownStatement = ownStatement;
            this.signature = signature;
            this.firstFrame = firstFrame;
            this.updateCount = updateCount;
        }

        @Override
        ResultSetResponse deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Responses.ResultSetResponse)) {
                throw new IllegalArgumentException("Expected ResultSetResponse, but got " + genericMsg.getClass().getName());
            }
            return ResultSetResponse.fromProto((Responses.ResultSetResponse)genericMsg);
        }

        static ResultSetResponse fromProto(Responses.ResultSetResponse msg) {
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            Meta.Signature signature = null;
            if (ProtobufService.hasField(msg, desc, 4)) {
                signature = Meta.Signature.fromProto(msg.getSignature());
            }
            Meta.Frame frame = null;
            if (ProtobufService.hasField(msg, desc, 5)) {
                frame = Meta.Frame.fromProto(msg.getFirstFrame());
            }
            return new ResultSetResponse(connectionId, msg.getStatementId(), msg.getOwnStatement(), signature, frame, msg.getUpdateCount());
        }

        @Override
        Responses.ResultSetResponse serialize() {
            Responses.ResultSetResponse.Builder builder = Responses.ResultSetResponse.newBuilder();
            builder.setStatementId(this.statementId).setOwnStatement(this.ownStatement).setUpdateCount(this.updateCount);
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.signature) {
                builder.setSignature(this.signature.toProto());
            }
            if (null != this.firstFrame) {
                builder.setFirstFrame(this.firstFrame.toProto());
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.firstFrame == null ? 0 : this.firstFrame.hashCode());
            result = 31 * result + (this.ownStatement ? 1231 : 1237);
            result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
            result = 31 * result + this.statementId;
            result = 31 * result + (int)(this.updateCount ^ this.updateCount >>> 32);
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ResultSetResponse) {
                ResultSetResponse other = (ResultSetResponse)o;
                if (this.connectionId == null ? other.connectionId != null : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (this.firstFrame == null ? other.firstFrame != null : !this.firstFrame.equals(other.firstFrame)) {
                    return false;
                }
                if (this.signature == null ? other.signature != null : !this.signature.equals(other.signature)) {
                    return false;
                }
                return this.ownStatement == other.ownStatement && this.statementId == other.statementId && this.updateCount == other.updateCount;
            }
            return false;
        }
    }

    public static class TypeInfoRequest
    extends Request {
        public final String connectionId;

        public TypeInfoRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public TypeInfoRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        TypeInfoRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.TypeInfoRequest)) {
                throw new IllegalArgumentException("Expected TypeInfoRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.TypeInfoRequest msg = (Requests.TypeInfoRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new TypeInfoRequest(connectionId);
        }

        @Override
        Requests.TypeInfoRequest serialize() {
            Requests.TypeInfoRequest.Builder builder = Requests.TypeInfoRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.connectionId == null ? 0 : this.connectionId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TypeInfoRequest) {
                TypeInfoRequest other = (TypeInfoRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class ColumnsRequest
    extends Request {
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;
        public final String tableNamePattern;
        public final String columnNamePattern;

        ColumnsRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
            this.tableNamePattern = null;
            this.columnNamePattern = null;
        }

        @JsonCreator
        public ColumnsRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern, @JsonProperty(value="tableNamePattern") String tableNamePattern, @JsonProperty(value="columnNamePattern") String columnNamePattern) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.tableNamePattern = tableNamePattern;
            this.columnNamePattern = columnNamePattern;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ColumnsRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.ColumnsRequest)) {
                throw new IllegalArgumentException("Expected ColumnsRequest, but got" + genericMsg.getClass().getName());
            }
            Requests.ColumnsRequest msg = (Requests.ColumnsRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 5)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                schemaPattern = msg.getSchemaPattern();
            }
            String tableNamePattern = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                tableNamePattern = msg.getTableNamePattern();
            }
            String columnNamePattern = null;
            if (ProtobufService.hasField(msg, desc, 4)) {
                columnNamePattern = msg.getColumnNamePattern();
            }
            return new ColumnsRequest(connectionId, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }

        @Override
        Requests.ColumnsRequest serialize() {
            Requests.ColumnsRequest.Builder builder = Requests.ColumnsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            if (null != this.tableNamePattern) {
                builder.setTableNamePattern(this.tableNamePattern);
            }
            if (null != this.columnNamePattern) {
                builder.setColumnNamePattern(this.columnNamePattern);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.columnNamePattern == null ? 0 : this.columnNamePattern.hashCode());
            result = 31 * result + (this.schemaPattern == null ? 0 : this.schemaPattern.hashCode());
            result = 31 * result + (this.tableNamePattern == null ? 0 : this.tableNamePattern.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ColumnsRequest) {
                ColumnsRequest other = (ColumnsRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.catalog ? null != other.catalog : !this.catalog.equals(other.catalog)) {
                    return false;
                }
                if (null == this.schemaPattern ? null != other.schemaPattern : !this.schemaPattern.equals(other.schemaPattern)) {
                    return false;
                }
                if (null == this.tableNamePattern ? null != other.tableNamePattern : !this.tableNamePattern.equals(other.tableNamePattern)) {
                    return false;
                }
                return !(null == this.columnNamePattern ? null != other.columnNamePattern : !this.columnNamePattern.equals(other.columnNamePattern));
            }
            return false;
        }
    }

    public static class TableTypesRequest
    extends Request {
        public final String connectionId;

        public TableTypesRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public TableTypesRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        TableTypesRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.TableTypesRequest)) {
                throw new IllegalArgumentException("Expected TableTypesRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.TableTypesRequest msg = (Requests.TableTypesRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new TableTypesRequest(connectionId);
        }

        @Override
        Requests.TableTypesRequest serialize() {
            Requests.TableTypesRequest.Builder builder = Requests.TableTypesRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.connectionId == null ? 0 : this.connectionId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TableTypesRequest) {
                TableTypesRequest other = (TableTypesRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class TablesRequest
    extends Request {
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;
        public final String tableNamePattern;
        public final List<String> typeList;

        TablesRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
            this.tableNamePattern = null;
            this.typeList = null;
        }

        @JsonCreator
        public TablesRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern, @JsonProperty(value="tableNamePattern") String tableNamePattern, @JsonProperty(value="typeList") List<String> typeList) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.tableNamePattern = tableNamePattern;
            this.typeList = typeList;
        }

        @Override
        Response accept(Service service) {
            return service.apply(this);
        }

        @Override
        Request deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.TablesRequest)) {
                throw new IllegalArgumentException("Expected TablesRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.TablesRequest msg = (Requests.TablesRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 7)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                schemaPattern = msg.getSchemaPattern();
            }
            String tableNamePattern = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                tableNamePattern = msg.getTableNamePattern();
            }
            ProtocolStringList typeList = null;
            if (msg.getHasTypeList()) {
                typeList = msg.getTypeListList();
            }
            return new TablesRequest(connectionId, catalog, schemaPattern, tableNamePattern, typeList);
        }

        @Override
        Requests.TablesRequest serialize() {
            Requests.TablesRequest.Builder builder = Requests.TablesRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            if (null != this.tableNamePattern) {
                builder.setTableNamePattern(this.tableNamePattern);
            }
            if (null != this.typeList) {
                builder.setHasTypeList(true);
                builder.addAllTypeList(this.typeList);
            } else {
                builder.setHasTypeList(false);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.schemaPattern == null ? 0 : this.schemaPattern.hashCode());
            result = 31 * result + (this.tableNamePattern == null ? 0 : this.tableNamePattern.hashCode());
            result = 31 * result + (this.typeList == null ? 0 : this.typeList.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TablesRequest) {
                TablesRequest other = (TablesRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.catalog ? null != other.catalog : !this.catalog.equals(other.catalog)) {
                    return false;
                }
                if (null == this.schemaPattern ? null != other.schemaPattern : !this.schemaPattern.equals(other.schemaPattern)) {
                    return false;
                }
                if (null == this.tableNamePattern ? null != other.tableNamePattern : !this.tableNamePattern.equals(other.tableNamePattern)) {
                    return false;
                }
                return !(null == this.typeList ? null != other.typeList : null == other.typeList || !this.typeList.equals(other.typeList));
            }
            return false;
        }
    }

    public static class SchemasRequest
    extends Request {
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;

        SchemasRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
        }

        @JsonCreator
        public SchemasRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        SchemasRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.SchemasRequest)) {
                throw new IllegalArgumentException("Expected SchemasRequest, but got" + genericMsg.getClass().getName());
            }
            Requests.SchemasRequest msg = (Requests.SchemasRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                schemaPattern = msg.getSchemaPattern();
            }
            return new SchemasRequest(connectionId, catalog, schemaPattern);
        }

        @Override
        Requests.SchemasRequest serialize() {
            Requests.SchemasRequest.Builder builder = Requests.SchemasRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.schemaPattern == null ? 0 : this.schemaPattern.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SchemasRequest) {
                SchemasRequest other = (SchemasRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.catalog ? null != other.catalog : !this.catalog.equals(other.catalog)) {
                    return false;
                }
                return !(null == this.schemaPattern ? null != other.schemaPattern : !this.catalog.equals(other.catalog));
            }
            return false;
        }
    }

    public static class DatabasePropertyRequest
    extends Request {
        public final String connectionId;

        public DatabasePropertyRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public DatabasePropertyRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        DatabasePropertyResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        DatabasePropertyRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.DatabasePropertyRequest)) {
                throw new IllegalArgumentException("Expected DatabasePropertyRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.DatabasePropertyRequest msg = (Requests.DatabasePropertyRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new DatabasePropertyRequest(connectionId);
        }

        @Override
        Requests.DatabasePropertyRequest serialize() {
            Requests.DatabasePropertyRequest.Builder builder = Requests.DatabasePropertyRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.connectionId == null ? 0 : this.connectionId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DatabasePropertyRequest) {
                DatabasePropertyRequest other = (DatabasePropertyRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class CatalogsRequest
    extends Request {
        public final String connectionId;

        public CatalogsRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CatalogsRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CatalogsRequest deserialize(Message genericMsg) {
            if (!(genericMsg instanceof Requests.CatalogsRequest)) {
                throw new IllegalArgumentException("Expected CatalogsRequest, but got " + genericMsg.getClass().getName());
            }
            Requests.CatalogsRequest msg = (Requests.CatalogsRequest)genericMsg;
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CatalogsRequest(connectionId);
        }

        @Override
        Requests.CatalogsRequest serialize() {
            Requests.CatalogsRequest.Builder builder = Requests.CatalogsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.connectionId == null ? 0 : this.connectionId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CatalogsRequest) {
                CatalogsRequest other = (CatalogsRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="response", defaultImpl=ResultSetResponse.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=OpenConnectionResponse.class, name="openConnection"), @JsonSubTypes.Type(value=ResultSetResponse.class, name="resultSet"), @JsonSubTypes.Type(value=PrepareResponse.class, name="prepare"), @JsonSubTypes.Type(value=FetchResponse.class, name="fetch"), @JsonSubTypes.Type(value=CreateStatementResponse.class, name="createStatement"), @JsonSubTypes.Type(value=CloseStatementResponse.class, name="closeStatement"), @JsonSubTypes.Type(value=CloseConnectionResponse.class, name="closeConnection"), @JsonSubTypes.Type(value=ConnectionSyncResponse.class, name="connectionSync"), @JsonSubTypes.Type(value=DatabasePropertyResponse.class, name="databaseProperties"), @JsonSubTypes.Type(value=ExecuteResponse.class, name="executeResults"), @JsonSubTypes.Type(value=ErrorResponse.class, name="error"), @JsonSubTypes.Type(value=SyncResultsResponse.class, name="syncResults")})
    public static abstract class Response {
        abstract Response deserialize(Message var1);

        abstract Message serialize();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="request", defaultImpl=SchemasRequest.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CatalogsRequest.class, name="getCatalogs"), @JsonSubTypes.Type(value=SchemasRequest.class, name="getSchemas"), @JsonSubTypes.Type(value=TablesRequest.class, name="getTables"), @JsonSubTypes.Type(value=TableTypesRequest.class, name="getTableTypes"), @JsonSubTypes.Type(value=TypeInfoRequest.class, name="getTypeInfo"), @JsonSubTypes.Type(value=ColumnsRequest.class, name="getColumns"), @JsonSubTypes.Type(value=ExecuteRequest.class, name="execute"), @JsonSubTypes.Type(value=PrepareRequest.class, name="prepare"), @JsonSubTypes.Type(value=PrepareAndExecuteRequest.class, name="prepareAndExecute"), @JsonSubTypes.Type(value=FetchRequest.class, name="fetch"), @JsonSubTypes.Type(value=CreateStatementRequest.class, name="createStatement"), @JsonSubTypes.Type(value=CloseStatementRequest.class, name="closeStatement"), @JsonSubTypes.Type(value=OpenConnectionRequest.class, name="openConnection"), @JsonSubTypes.Type(value=CloseConnectionRequest.class, name="closeConnection"), @JsonSubTypes.Type(value=ConnectionSyncRequest.class, name="connectionSync"), @JsonSubTypes.Type(value=DatabasePropertyRequest.class, name="databaseProperties"), @JsonSubTypes.Type(value=SyncResultsRequest.class, name="syncResults")})
    public static abstract class Request {
        abstract Response accept(Service var1);

        abstract Request deserialize(Message var1);

        abstract Message serialize();
    }

    public static interface Factory {
        public Service create(AvaticaConnection var1);
    }
}

