/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.MissingResultsException;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.remote.TypedValue;

public class LocalService
implements Service {
    final Meta meta;

    public LocalService(Meta meta) {
        this.meta = meta;
    }

    private static <E> List<E> list(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> rowList = new ArrayList<E>();
        for (E row : iterable) {
            rowList.add(row);
        }
        return rowList;
    }

    public Service.ResultSetResponse toResponse(Meta.MetaResultSet resultSet) {
        if (resultSet.updateCount != -1L) {
            return new Service.ResultSetResponse(resultSet.connectionId, resultSet.statementId, resultSet.ownStatement, null, null, resultSet.updateCount);
        }
        Meta.Signature signature = resultSet.signature;
        Meta.CursorFactory cursorFactory = resultSet.signature.cursorFactory;
        Meta.Frame frame = null;
        int updateCount = -1;
        if (resultSet.firstFrame != null) {
            List<Object> list = LocalService.list(resultSet.firstFrame.rows);
            switch (cursorFactory.style) {
                case ARRAY: {
                    cursorFactory = Meta.CursorFactory.LIST;
                    break;
                }
                case MAP: 
                case LIST: {
                    break;
                }
                case RECORD: {
                    cursorFactory = Meta.CursorFactory.LIST;
                    break;
                }
                default: {
                    cursorFactory = Meta.CursorFactory.map(cursorFactory.fieldNames);
                }
            }
            boolean done = resultSet.firstFrame.done;
            frame = new Meta.Frame(0L, done, list);
            updateCount = -1;
            if (signature.statementType != null && signature.statementType.canUpdate()) {
                frame = null;
                updateCount = ((Number)((List)list.get(0)).get(0)).intValue();
            }
        } else {
            List<List<Object>> list = this.list2(resultSet);
            cursorFactory = Meta.CursorFactory.LIST;
        }
        if (cursorFactory != resultSet.signature.cursorFactory) {
            signature = signature.setCursorFactory(cursorFactory);
        }
        return new Service.ResultSetResponse(resultSet.connectionId, resultSet.statementId, resultSet.ownStatement, signature, frame, updateCount);
    }

    private List<List<Object>> list2(Meta.MetaResultSet resultSet) {
        Meta.StatementHandle h = new Meta.StatementHandle(resultSet.connectionId, resultSet.statementId, null);
        List<TypedValue> parameterValues = Collections.emptyList();
        Iterable<Object> iterable = this.meta.createIterable(h, null, resultSet.signature, parameterValues, resultSet.firstFrame);
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        return MetaImpl.collect(resultSet.signature.cursorFactory, iterable, list);
    }

    @Override
    public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getCatalogs(ch);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.SchemasRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getSchemas(ch, request.catalog, Meta.Pat.of(request.schemaPattern));
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TablesRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getTables(ch, request.catalog, Meta.Pat.of(request.schemaPattern), Meta.Pat.of(request.tableNamePattern), request.typeList);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TableTypesRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getTableTypes(ch);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TypeInfoRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getTypeInfo(ch);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.ColumnsRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getColumns(ch, request.catalog, Meta.Pat.of(request.schemaPattern), Meta.Pat.of(request.tableNamePattern), Meta.Pat.of(request.columnNamePattern));
        return this.toResponse(resultSet);
    }

    @Override
    public Service.PrepareResponse apply(Service.PrepareRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.StatementHandle h = this.meta.prepare(ch, request.sql, request.maxRowCount);
        return new Service.PrepareResponse(h);
    }

    @Override
    public Service.ExecuteResponse apply(Service.PrepareAndExecuteRequest request) {
        Meta.StatementHandle sh = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        try {
            Meta.ExecuteResult executeResult = this.meta.prepareAndExecute(sh, request.sql, request.maxRowCount, new Meta.PrepareCallback(){

                @Override
                public Object getMonitor() {
                    return LocalService.class;
                }

                @Override
                public void clear() {
                }

                @Override
                public void assign(Meta.Signature signature, Meta.Frame firstFrame, long updateCount) {
                }

                @Override
                public void execute() {
                }
            });
            ArrayList<Service.ResultSetResponse> results = new ArrayList<Service.ResultSetResponse>();
            for (Meta.MetaResultSet metaResultSet : executeResult.resultSets) {
                results.add(this.toResponse(metaResultSet));
            }
            return new Service.ExecuteResponse(results, false);
        }
        catch (NoSuchStatementException e) {
            return new Service.ExecuteResponse(null, true);
        }
    }

    @Override
    public Service.FetchResponse apply(Service.FetchRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        try {
            Meta.Frame frame = this.meta.fetch(h, request.offset, request.fetchMaxRowCount);
            return new Service.FetchResponse(frame, false, false);
        }
        catch (NullPointerException | NoSuchStatementException e) {
            return new Service.FetchResponse(null, true, true);
        }
        catch (MissingResultsException e) {
            return new Service.FetchResponse(null, false, true);
        }
    }

    @Override
    public Service.ExecuteResponse apply(Service.ExecuteRequest request) {
        try {
            Meta.ExecuteResult executeResult = this.meta.execute(request.statementHandle, request.parameterValues, request.maxRowCount);
            ArrayList<Service.ResultSetResponse> results = new ArrayList<Service.ResultSetResponse>();
            for (Meta.MetaResultSet metaResultSet : executeResult.resultSets) {
                results.add(this.toResponse(metaResultSet));
            }
            return new Service.ExecuteResponse(results, false);
        }
        catch (NoSuchStatementException e) {
            return new Service.ExecuteResponse(null, true);
        }
    }

    @Override
    public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.StatementHandle h = this.meta.createStatement(ch);
        return new Service.CreateStatementResponse(h.connectionId, h.id);
    }

    @Override
    public Service.CloseStatementResponse apply(Service.CloseStatementRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        this.meta.closeStatement(h);
        return new Service.CloseStatementResponse();
    }

    @Override
    public Service.OpenConnectionResponse apply(Service.OpenConnectionRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        this.meta.openConnection(ch, request.info);
        return new Service.OpenConnectionResponse();
    }

    @Override
    public Service.CloseConnectionResponse apply(Service.CloseConnectionRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        this.meta.closeConnection(ch);
        return new Service.CloseConnectionResponse();
    }

    @Override
    public Service.ConnectionSyncResponse apply(Service.ConnectionSyncRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.ConnectionProperties connProps = this.meta.connectionSync(ch, request.connProps);
        return new Service.ConnectionSyncResponse(connProps);
    }

    @Override
    public Service.DatabasePropertyResponse apply(Service.DatabasePropertyRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        return new Service.DatabasePropertyResponse(this.meta.getDatabaseProperties(ch));
    }

    @Override
    public Service.SyncResultsResponse apply(Service.SyncResultsRequest request) {
        Service.SyncResultsResponse response;
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        try {
            response = new Service.SyncResultsResponse(this.meta.syncResults(h, request.state, request.offset), false);
        }
        catch (NoSuchStatementException e) {
            response = new Service.SyncResultsResponse(false, true);
        }
        return response;
    }
}

