/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.xml;

import java.util.Iterator;
import java.util.Map;
import org.apache.bval.MetaBeanBuilder;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.MetaBeanManager;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.PrivilegedActions;
import org.apache.bval.xml.MetaBeanEnricher;
import org.apache.bval.xml.XMLMetaBeanBuilder;
import org.apache.bval.xml.XMLMetaBeanInfos;
import org.apache.bval.xml.XMLMetaBeanLoader;
import org.apache.bval.xml.XMLMetaBeanRegistry;
import org.apache.bval.xml.XMLMetaBeanURLLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMetaBeanManager
extends MetaBeanManager
implements MetaBeanFinder,
XMLMetaBeanRegistry,
MetaBeanEnricher {
    public XMLMetaBeanManager() {
        this(new XMLMetaBeanBuilder());
    }

    public XMLMetaBeanManager(XMLMetaBeanBuilder builder) {
        super((MetaBeanBuilder)builder);
    }

    @Override
    public void addResourceLoader(String resource) {
        this.addLoader(new XMLMetaBeanURLLoader(PrivilegedActions.getClassLoader(this.getClass()).getResource(resource)));
    }

    @Override
    public synchronized void addLoader(XMLMetaBeanLoader loader) {
        ((XMLMetaBeanBuilder)this.builder).addLoader(loader);
        this.cache.clear();
        this.complete = false;
    }

    @Override
    public Map<String, MetaBean> enrichCopies(XMLMetaBeanInfos ... infos) {
        Map<String, MetaBean> cached = this.findAll();
        try {
            Map<String, MetaBean> patched = ((XMLMetaBeanBuilder)this.builder).enrichCopies(cached, infos);
            Iterator<MetaBean> i$ = patched.values().iterator();
            while (i$.hasNext()) {
                MetaBean entry;
                MetaBean meta = entry = i$.next();
                this.computeRelationships(meta, patched);
            }
            return patched;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error enriching beanInfos", e);
        }
    }

    public Map<String, MetaBean> findAll() {
        if (!this.complete) {
            try {
                Map allBuilt = this.builder.buildAll();
                for (MetaBean meta : allBuilt.values()) {
                    MetaBean cached = this.cache.findForId(meta.getId());
                    if (cached != null) continue;
                    this.cache.cache(meta);
                }
                Map map = this.cache.findAll();
                Iterator i$ = map.values().iterator();
                while (i$.hasNext()) {
                    MetaBean oentry;
                    MetaBean meta = oentry = (MetaBean)i$.next();
                    this.computeRelationships(meta, map);
                }
                this.complete = true;
                return map;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error creating beanInfos", e);
            }
        }
        return this.cache.findAll();
    }

    protected void computeRelationships(MetaBean beanInfo, Map<String, MetaBean> cached) {
        for (MetaProperty prop : beanInfo.getProperties()) {
            String beanRef = (String)prop.getFeature("refBeanId");
            if (beanRef == null) continue;
            prop.setMetaBean(cached.get(beanRef));
        }
    }

    protected void computeRelatedMetaBean(MetaProperty prop, String beanRef) {
        if (beanRef != null) {
            prop.setMetaBean(this.findForId(beanRef));
        } else {
            super.computeRelatedMetaBean(prop, beanRef);
        }
    }
}

