/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.extras.constraints.checkdigit;

import org.apache.bval.extras.constraints.checkdigit.CUSIP;
import org.apache.bval.extras.constraints.checkdigit.ModulusValidator;

public final class CUSIPValidator
extends ModulusValidator<CUSIP> {
    private static final int[] POSITION_WEIGHT = new int[]{2, 1};

    public CUSIPValidator() {
        super(10);
    }

    @Override
    protected int weightedValue(int charValue, int leftPos, int rightPos) throws Exception {
        int weight = POSITION_WEIGHT[rightPos % 2];
        int weightedValue = charValue * weight;
        return CUSIPValidator.sumDigits(weightedValue);
    }

    @Override
    protected int toInt(char character, int leftPos, int rightPos) {
        int charValue = Character.getNumericValue(character);
        if (charValue < 0 || charValue > 35) {
            throw new IllegalArgumentException("Invalid Character[" + leftPos + "] = '" + charValue + "'");
        }
        return charValue;
    }
}

