/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.extras.constraints.checkdigit;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;

abstract class ModulusValidator<A extends Annotation>
implements ConstraintValidator<A, CharSequence> {
    private final int modulus;

    public ModulusValidator(int modulus) {
        this.modulus = modulus;
    }

    public final void initialize(A annotation) {
    }

    public boolean isValid(CharSequence code, ConstraintValidatorContext context) {
        if (code.length() == 0) {
            return false;
        }
        int total = 0;
        for (int i = 0; i < code.length(); ++i) {
            int lth = code.length();
            int leftPos = i + 1;
            int rightPos = lth - i;
            try {
                int charValue = this.toInt(code.charAt(i), leftPos, rightPos);
                total += this.weightedValue(charValue, leftPos, rightPos);
                continue;
            }
            catch (Throwable e) {
                return false;
            }
        }
        if (total == 0) {
            return false;
        }
        return total % this.modulus == 0;
    }

    protected abstract int weightedValue(int var1, int var2, int var3) throws Exception;

    protected int toInt(char character, int leftPos, int rightPos) {
        if (Character.isDigit(character)) {
            return Character.getNumericValue(character);
        }
        throw new IllegalArgumentException("Invalid Character[" + leftPos + "] = '" + character + "'");
    }

    protected static int sumDigits(int number) {
        int total = 0;
        for (int todo = number; todo > 0; todo /= 10) {
            total += todo % 10;
        }
        return total;
    }
}

