/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.xml.XmlIO;

final class AutoValue_XmlIO_Sink<T>
extends XmlIO.Sink<T> {
    private final Class<T> recordClass;
    private final String rootElement;
    private final String charset;

    private AutoValue_XmlIO_Sink(Class<T> recordClass, @Nullable String rootElement, String charset) {
        this.recordClass = recordClass;
        this.rootElement = rootElement;
        this.charset = charset;
    }

    @Override
    Class<T> getRecordClass() {
        return this.recordClass;
    }

    @Override
    @Nullable
    String getRootElement() {
        return this.rootElement;
    }

    @Override
    String getCharset() {
        return this.charset;
    }

    public String toString() {
        return "Sink{recordClass=" + this.recordClass + ", rootElement=" + this.rootElement + ", charset=" + this.charset + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof XmlIO.Sink) {
            XmlIO.Sink that = (XmlIO.Sink)o;
            return this.recordClass.equals(that.getRecordClass()) && (this.rootElement == null ? that.getRootElement() == null : this.rootElement.equals(that.getRootElement())) && this.charset.equals(that.getCharset());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.recordClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.rootElement == null ? 0 : this.rootElement.hashCode();
        h$ *= 1000003;
        return h$ ^= this.charset.hashCode();
    }

    @Override
    XmlIO.Sink.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends XmlIO.Sink.Builder<T> {
        private Class<T> recordClass;
        private String rootElement;
        private String charset;

        Builder() {
        }

        private Builder(XmlIO.Sink<T> source) {
            this.recordClass = source.getRecordClass();
            this.rootElement = source.getRootElement();
            this.charset = source.getCharset();
        }

        @Override
        XmlIO.Sink.Builder<T> setRecordClass(Class<T> recordClass) {
            if (recordClass == null) {
                throw new NullPointerException("Null recordClass");
            }
            this.recordClass = recordClass;
            return this;
        }

        @Override
        XmlIO.Sink.Builder<T> setRootElement(String rootElement) {
            this.rootElement = rootElement;
            return this;
        }

        @Override
        XmlIO.Sink.Builder<T> setCharset(String charset) {
            if (charset == null) {
                throw new NullPointerException("Null charset");
            }
            this.charset = charset;
            return this;
        }

        @Override
        XmlIO.Sink<T> build() {
            String missing = "";
            if (this.recordClass == null) {
                missing = missing + " recordClass";
            }
            if (this.charset == null) {
                missing = missing + " charset";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_XmlIO_Sink(this.recordClass, this.rootElement, this.charset);
        }
    }
}

