/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_Read;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_Write;
import org.apache.beam.sdk.io.xml.XmlSink;
import org.apache.beam.sdk.io.xml.XmlSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdks.java.io.xml.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdks.java.io.xml.repackaged.com.google.common.base.Preconditions;

public class XmlIO {
    public static <T> Read<T> read() {
        return new AutoValue_XmlIO_Read.Builder().setMinBundleSize(8192L).setCompressionType(Read.CompressionType.AUTO).setCharset("UTF-8").build();
    }

    public static <T> Write<T> write() {
        return new AutoValue_XmlIO_Write.Builder().setCharset("UTF-8").build();
    }

    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract ValueProvider<ResourceId> getFilenamePrefix();

        @Nullable
        abstract Class<T> getRecordClass();

        @Nullable
        abstract String getRootElement();

        @Nullable
        abstract String getCharset();

        abstract Builder<T> toBuilder();

        public Write<T> to(String filenamePrefix) {
            ResourceId resourceId = FileBasedSink.convertToFileResourceIfPossible((String)filenamePrefix);
            return this.toBuilder().setFilenamePrefix((ValueProvider<ResourceId>)ValueProvider.StaticValueProvider.of((Object)resourceId)).build();
        }

        public Write<T> withRecordClass(Class<T> recordClass) {
            return this.toBuilder().setRecordClass(recordClass).build();
        }

        public Write<T> withRootElement(String rootElement) {
            return this.toBuilder().setRootElement(rootElement).build();
        }

        public Write<T> withCharset(Charset charset) {
            return this.toBuilder().setCharset(charset.name()).build();
        }

        public void validate(PipelineOptions options) {
            Preconditions.checkNotNull(this.getRecordClass(), "Missing a class to bind to a JAXB context.");
            Preconditions.checkNotNull(this.getRootElement(), "Missing a root element name.");
            Preconditions.checkNotNull(this.getFilenamePrefix(), "Missing a filename to write to.");
            Preconditions.checkNotNull(this.getCharset(), "Missing charset");
            try {
                JAXBContext.newInstance((Class[])new Class[]{this.getRecordClass()});
            }
            catch (JAXBException e) {
                throw new RuntimeException("Error binding classes to a JAXB Context.", e);
            }
        }

        public PDone expand(PCollection<T> input) {
            return (PDone)input.apply((PTransform)WriteFiles.to(this.createSink()));
        }

        @VisibleForTesting
        XmlSink<T> createSink() {
            return new XmlSink(this);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.createSink().populateFileBasedDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"rootElement", (String)this.getRootElement()).withLabel("XML Root Element")).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("XML Record Class")).addIfNotNull(DisplayData.item((String)"charset", (String)this.getCharset()).withLabel("Charset"));
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setFilenamePrefix(ValueProvider<ResourceId> var1);

            abstract Builder<T> setRecordClass(Class<T> var1);

            abstract Builder<T> setRootElement(String var1);

            abstract Builder<T> setCharset(String var1);

            abstract Write<T> build();
        }
    }

    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        private static final int DEFAULT_MIN_BUNDLE_SIZE = 8192;

        @Nullable
        abstract String getFileOrPatternSpec();

        @Nullable
        abstract String getRootElement();

        @Nullable
        abstract String getRecordElement();

        @Nullable
        abstract Class<T> getRecordClass();

        abstract CompressionType getCompressionType();

        abstract long getMinBundleSize();

        @Nullable
        abstract String getCharset();

        abstract Builder<T> toBuilder();

        @Nullable
        abstract ValidationEventHandler getValidationEventHandler();

        public Read<T> from(String fileOrPatternSpec) {
            return this.toBuilder().setFileOrPatternSpec(fileOrPatternSpec).build();
        }

        public Read<T> withRootElement(String rootElement) {
            return this.toBuilder().setRootElement(rootElement).build();
        }

        public Read<T> withRecordElement(String recordElement) {
            return this.toBuilder().setRecordElement(recordElement).build();
        }

        public Read<T> withRecordClass(Class<T> recordClass) {
            return this.toBuilder().setRecordClass(recordClass).build();
        }

        public Read<T> withMinBundleSize(long minBundleSize) {
            return this.toBuilder().setMinBundleSize(minBundleSize).build();
        }

        public Read<T> withCompressionType(CompressionType compressionType) {
            return this.toBuilder().setCompressionType(compressionType).build();
        }

        public Read<T> withCharset(Charset charset) {
            return this.toBuilder().setCharset(charset.name()).build();
        }

        public Read<T> withValidationEventHandler(ValidationEventHandler validationEventHandler) {
            return this.toBuilder().setValidationEventHandler(validationEventHandler).build();
        }

        public void validate(PipelineOptions options) {
            Preconditions.checkNotNull(this.getRootElement(), "rootElement is null. Use builder method withRootElement() to set this.");
            Preconditions.checkNotNull(this.getRecordElement(), "recordElement is null. Use builder method withRecordElement() to set this.");
            Preconditions.checkNotNull(this.getRecordClass(), "recordClass is null. Use builder method withRecordClass() to set this.");
            Preconditions.checkNotNull(this.getCharset(), "charset is null. Use builder method withCharset() to set this.");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.addIfNotDefault(DisplayData.item((String)"minBundleSize", (Long)this.getMinBundleSize()).withLabel("Minimum Bundle Size"), (Object)1L).add(DisplayData.item((String)"filePattern", (String)this.getFileOrPatternSpec()).withLabel("File Pattern")).addIfNotNull(DisplayData.item((String)"rootElement", (String)this.getRootElement()).withLabel("XML Root Element")).addIfNotNull(DisplayData.item((String)"recordElement", (String)this.getRecordElement()).withLabel("XML Record Element")).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("XML Record Class")).addIfNotNull(DisplayData.item((String)"charset", (String)this.getCharset()).withLabel("Charset"));
        }

        @VisibleForTesting
        BoundedSource<T> createSource() {
            XmlSource source = new XmlSource(this);
            switch (this.getCompressionType()) {
                case UNCOMPRESSED: {
                    return source;
                }
                case AUTO: {
                    return CompressedSource.from(source);
                }
                case BZIP2: {
                    return CompressedSource.from(source).withDecompression((CompressedSource.DecompressingChannelFactory)CompressedSource.CompressionMode.BZIP2);
                }
                case GZIP: {
                    return CompressedSource.from(source).withDecompression((CompressedSource.DecompressingChannelFactory)CompressedSource.CompressionMode.GZIP);
                }
                case ZIP: {
                    return CompressedSource.from(source).withDecompression((CompressedSource.DecompressingChannelFactory)CompressedSource.CompressionMode.ZIP);
                }
                case DEFLATE: {
                    return CompressedSource.from(source).withDecompression((CompressedSource.DecompressingChannelFactory)CompressedSource.CompressionMode.DEFLATE);
                }
            }
            throw new IllegalArgumentException("Unknown compression type: " + (Object)((Object)this.getCompressionType()));
        }

        public PCollection<T> expand(PBegin input) {
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from(this.createSource()));
        }

        public static enum CompressionType {
            AUTO(""),
            UNCOMPRESSED(""),
            GZIP(".gz"),
            BZIP2(".bz2"),
            ZIP(".zip"),
            DEFLATE(".deflate");

            private String filenameSuffix;

            private CompressionType(String suffix) {
                this.filenameSuffix = suffix;
            }

            public boolean matches(String filename) {
                return filename.toLowerCase().endsWith(this.filenameSuffix.toLowerCase());
            }
        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setFileOrPatternSpec(String var1);

            abstract Builder<T> setRootElement(String var1);

            abstract Builder<T> setRecordElement(String var1);

            abstract Builder<T> setRecordClass(Class<T> var1);

            abstract Builder<T> setMinBundleSize(long var1);

            abstract Builder<T> setCompressionType(CompressionType var1);

            abstract Builder<T> setCharset(String var1);

            abstract Builder<T> setValidationEventHandler(ValidationEventHandler var1);

            abstract Read<T> build();
        }
    }
}

