/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.tika;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.beam.sdk.util.SerializableThrowable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Throwables;
import org.apache.tika.metadata.Metadata;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ParseResult
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized String fileLocation;
    private final @UnknownKeyFor @NonNull @Initialized String content;
    private final @UnknownKeyFor @NonNull @Initialized Metadata metadata;
    private final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] metadataNames;
    private final @Nullable @UnknownKeyFor @Initialized SerializableThrowable error;

    public static @UnknownKeyFor @NonNull @Initialized ParseResult success(@UnknownKeyFor @NonNull @Initialized String fileLocation, @UnknownKeyFor @NonNull @Initialized String content, @UnknownKeyFor @NonNull @Initialized Metadata metadata) {
        return new ParseResult(fileLocation, content, metadata, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized ParseResult success(@UnknownKeyFor @NonNull @Initialized String fileLocation, @UnknownKeyFor @NonNull @Initialized String content) {
        return new ParseResult(fileLocation, content, new Metadata(), null);
    }

    public static @UnknownKeyFor @NonNull @Initialized ParseResult failure(@UnknownKeyFor @NonNull @Initialized String fileLocation, @UnknownKeyFor @NonNull @Initialized String partialContent, @UnknownKeyFor @NonNull @Initialized Metadata partialMetadata, @UnknownKeyFor @NonNull @Initialized Throwable error) {
        return new ParseResult(fileLocation, partialContent, partialMetadata, error);
    }

    private ParseResult(@UnknownKeyFor @NonNull @Initialized String fileLocation, @UnknownKeyFor @NonNull @Initialized String content, @UnknownKeyFor @NonNull @Initialized Metadata metadata, @UnknownKeyFor @NonNull @Initialized Throwable error) {
        Preconditions.checkArgument((fileLocation != null ? 1 : 0) != 0, (Object)"fileLocation can not be null");
        Preconditions.checkArgument((content != null ? 1 : 0) != 0, (Object)"content can not be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata can not be null");
        this.fileLocation = fileLocation;
        this.content = content;
        this.metadata = metadata;
        this.metadataNames = metadata.names();
        this.error = error == null ? null : new SerializableThrowable(error);
    }

    public @UnknownKeyFor @NonNull @Initialized String getFileLocation() {
        return this.fileLocation;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSuccess() {
        return this.error == null;
    }

    public @UnknownKeyFor @NonNull @Initialized Throwable getError() {
        Preconditions.checkState((this.error != null ? 1 : 0) != 0, (Object)"This is a successful ParseResult");
        return this.error.getThrowable();
    }

    public @UnknownKeyFor @NonNull @Initialized String getErrorAsString() {
        return Throwables.getStackTraceAsString((Throwable)this.getError());
    }

    public @UnknownKeyFor @NonNull @Initialized String getContent() {
        return this.content;
    }

    public @UnknownKeyFor @NonNull @Initialized Metadata getMetadata() {
        return this.metadata;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getFileLocation(), this.getContent(), this.getMetadataHashCode(), this.isSuccess() ? "" : Throwables.getStackTraceAsString((Throwable)this.getError()));
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (!(obj instanceof ParseResult)) {
            return false;
        }
        ParseResult other = (ParseResult)obj;
        return Objects.equals(this.getFileLocation(), other.getFileLocation()) && Objects.equals(this.getContent(), other.getContent()) && Objects.equals(this.getMetadata(), other.getMetadata()) && (this.isSuccess() ? other.isSuccess() : !other.isSuccess() && Objects.equals(this.getErrorAsString(), other.getErrorAsString()));
    }

    private @UnknownKeyFor @NonNull @Initialized int getMetadataHashCode() {
        int hashCode = 0;
        for (String name : this.metadataNames) {
            hashCode += name.hashCode() ^ Arrays.hashCode(this.metadata.getValues(name));
        }
        return hashCode;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileLocation", (Object)this.fileLocation).add("content", (Object)("<" + this.content.length() + " chars>")).add("metadata", (Object)this.metadata).add("error", this.getError() == null ? null : Throwables.getStackTraceAsString((Throwable)this.getError())).toString();
    }
}

