/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.tika;

import com.google.auto.value.AutoValue;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.tika.AutoValue_TikaIO_Parse;
import org.apache.beam.sdk.io.tika.AutoValue_TikaIO_ParseFiles;
import org.apache.beam.sdk.io.tika.ParseResult;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ToTextContentHandler;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.xml.sax.ContentHandler;

public class TikaIO {
    public static @UnknownKeyFor @NonNull @Initialized Parse parse() {
        return new AutoValue_TikaIO_Parse.Builder().build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ParseFiles parseFiles() {
        return new AutoValue_TikaIO_ParseFiles.Builder().build();
    }

    @AutoValue
    public static abstract class ParseFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<ParseResult>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTikaConfigPath();

        abstract @Nullable @UnknownKeyFor @Initialized String getContentTypeHint();

        abstract @Nullable @UnknownKeyFor @Initialized Metadata getInputMetadata();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ParseFiles withTikaConfigPath(@UnknownKeyFor @NonNull @Initialized String tikaConfigPath) {
            Preconditions.checkArgument((tikaConfigPath != null ? 1 : 0) != 0, (Object)"tikaConfigPath can not be null.");
            return this.withTikaConfigPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tikaConfigPath));
        }

        public @UnknownKeyFor @NonNull @Initialized ParseFiles withTikaConfigPath(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tikaConfigPath) {
            Preconditions.checkArgument((tikaConfigPath != null ? 1 : 0) != 0, (Object)"tikaConfigPath can not be null.");
            return this.toBuilder().setTikaConfigPath(tikaConfigPath).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ParseFiles withContentTypeHint(@UnknownKeyFor @NonNull @Initialized String contentTypeHint) {
            Preconditions.checkNotNull((Object)contentTypeHint, (Object)"contentTypeHint can not be null.");
            return this.toBuilder().setContentTypeHint(contentTypeHint).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ParseFiles withInputMetadata(@UnknownKeyFor @NonNull @Initialized Metadata metadata) {
            Metadata inputMetadata = this.getInputMetadata();
            if (inputMetadata != null) {
                for (String name : metadata.names()) {
                    inputMetadata.set(name, metadata.get(name));
                }
            } else {
                inputMetadata = metadata;
            }
            return this.toBuilder().setInputMetadata(inputMetadata).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ParseResult> expand(@UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new ParseToStringFn(this)));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            Metadata metadata;
            super.populateDisplayData(builder);
            if (this.getTikaConfigPath() != null) {
                builder.add(DisplayData.item((String)"tikaConfigPath", this.getTikaConfigPath()).withLabel("TikaConfig Path"));
            }
            if ((metadata = this.getInputMetadata()) != null) {
                builder.add(DisplayData.item((String)"inputMetadata", (String)metadata.toString().trim()).withLabel("Input Metadata"));
            }
            builder.addIfNotNull(DisplayData.item((String)"contentTypeHint", (String)this.getContentTypeHint()).withLabel("Content type hint"));
        }

        private static class ParseToStringFn
        extends DoFn<FileIO.ReadableFile, ParseResult> {
            private final @UnknownKeyFor @NonNull @Initialized ParseFiles spec;
            private transient @UnknownKeyFor @NonNull @Initialized TikaConfig tikaConfig;

            ParseToStringFn(@UnknownKeyFor @NonNull @Initialized ParseFiles spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (this.spec.getTikaConfigPath() != null) {
                    ResourceId configResource = FileSystems.matchSingleFileSpec((String)((String)this.spec.getTikaConfigPath().get())).resourceId();
                    this.tikaConfig = new TikaConfig(Channels.newInputStream(FileSystems.open((ResourceId)configResource)));
                }
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                FileIO.ReadableFile file = (FileIO.ReadableFile)c.element();
                InputStream stream = Channels.newInputStream(file.open());
                try (TikaInputStream tikaStream = TikaInputStream.get((InputStream)stream);){
                    ParseResult res;
                    Metadata tikaMetadata;
                    AutoDetectParser parser = this.tikaConfig == null ? new AutoDetectParser() : new AutoDetectParser(this.tikaConfig);
                    ParseContext context = new ParseContext();
                    context.set(Parser.class, (Object)parser);
                    Metadata metadata = tikaMetadata = this.spec.getInputMetadata() != null ? this.spec.getInputMetadata() : new Metadata();
                    if (this.spec.getContentTypeHint() != null) {
                        tikaMetadata.set("Content-Type", this.spec.getContentTypeHint());
                    }
                    String location = file.getMetadata().resourceId().toString();
                    ToTextContentHandler tikaHandler = new ToTextContentHandler();
                    try {
                        parser.parse((InputStream)tikaStream, (ContentHandler)tikaHandler, tikaMetadata, context);
                        res = ParseResult.success(location, tikaHandler.toString(), tikaMetadata);
                    }
                    catch (Exception e) {
                        res = ParseResult.failure(location, tikaHandler.toString(), tikaMetadata, e);
                    }
                    c.output((Object)res);
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTikaConfigPath(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setContentTypeHint(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInputMetadata(@UnknownKeyFor @NonNull @Initialized Metadata var1);

            abstract @UnknownKeyFor @NonNull @Initialized ParseFiles build();
        }
    }

    @AutoValue
    public static abstract class Parse
    extends PTransform<PBegin, PCollection<ParseResult>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Parse filepattern(@UnknownKeyFor @NonNull @Initialized String filepattern) {
            return this.filepattern((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public @UnknownKeyFor @NonNull @Initialized Parse filepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("File Pattern"));
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ParseResult> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return (PCollection)((PCollection)((PCollection)input.apply((PTransform)FileIO.match().filepattern(this.getFilepattern()))).apply((PTransform)FileIO.readMatches().withCompression(Compression.UNCOMPRESSED))).apply((PTransform)TikaIO.parseFiles());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Parse build();
        }
    }
}

