/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.crosslanguage;

import java.io.IOException;
import java.util.List;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.crosslanguage.CrossLanguageConfiguration;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WriteBuilder
implements ExternalTransformBuilder<Configuration, PCollection<List<byte[]>>, PDone> {
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, @UnknownKeyFor @NonNull @Initialized PDone> buildExternal(@UnknownKeyFor @NonNull @Initialized Configuration c) {
        return SnowflakeIO.write().withDataSourceConfiguration(c.getDataSourceConfiguration()).withStorageIntegrationName(c.getStorageIntegrationName()).withStagingBucketName(c.getStagingBucketName()).withTableSchema(c.getTableSchema()).withCreateDisposition(c.getCreateDisposition()).withWriteDisposition(c.getWriteDisposition()).withUserDataMapper(WriteBuilder.getStringCsvMapper()).withQueryTransformation(c.getQuery()).to(c.getTable());
    }

    private static @UnknownKeyFor @NonNull @Initialized SnowflakeIO.UserDataMapper<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> getStringCsvMapper() {
        return recordLine -> recordLine.stream().map(String::new).toArray();
    }

    public static class Configuration
    extends CrossLanguageConfiguration {
        private @UnknownKeyFor @NonNull @Initialized SnowflakeTableSchema tableSchema;
        private @UnknownKeyFor @NonNull @Initialized CreateDisposition createDisposition;
        private @UnknownKeyFor @NonNull @Initialized WriteDisposition writeDisposition;

        public void setTableSchema(@UnknownKeyFor @NonNull @Initialized String tableSchema) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.tableSchema = (SnowflakeTableSchema)mapper.readValue(tableSchema, SnowflakeTableSchema.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Format of provided table schema is invalid");
            }
        }

        public void setCreateDisposition(@UnknownKeyFor @NonNull @Initialized String createDisposition) {
            this.createDisposition = CreateDisposition.valueOf(createDisposition);
        }

        public void setWriteDisposition(@UnknownKeyFor @NonNull @Initialized String writeDisposition) {
            this.writeDisposition = WriteDisposition.valueOf(writeDisposition);
        }

        public @UnknownKeyFor @NonNull @Initialized SnowflakeTableSchema getTableSchema() {
            return this.tableSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized CreateDisposition getCreateDisposition() {
            return this.createDisposition;
        }

        public @UnknownKeyFor @NonNull @Initialized WriteDisposition getWriteDisposition() {
            return this.writeDisposition;
        }
    }
}

