/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake;

import com.google.auto.value.AutoValue;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.HistoryResponse;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_DataSourceConfiguration;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_Read;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_Write;
import org.apache.beam.sdk.io.snowflake.KeyPairUtils;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.enums.StreamingLogLevel;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeBatchServiceConfig;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServices;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServicesImpl;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeStreamingServiceConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SnowflakeIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized String CSV_QUOTE_CHAR = "'";
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_FLUSH_ROW_LIMIT = 10000;
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_STREAMING_SHARDS_NUMBER = 1;
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BATCH_SHARDS_NUMBER = 0;
    static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_FLUSH_TIME_LIMIT = Duration.millis((long)30000L);
    static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_STREAMING_LOGS_MAX_SLEEP = Duration.standardMinutes((long)2L);
    static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_SLEEP_STREAMING_LOGS = Duration.standardSeconds((long)5000L);

    @VisibleForTesting
    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read(@UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices) {
        return new AutoValue_SnowflakeIO_Read.Builder().setSnowflakeServices(snowflakeServices).setQuotationMark((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)CSV_QUOTE_CHAR)).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read() {
        return SnowflakeIO.read(new SnowflakeServicesImpl());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_SnowflakeIO_Write.Builder().setFileNameTemplate("output").setCreateDisposition(CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(WriteDisposition.APPEND).setFlushTimeLimit(DEFAULT_FLUSH_TIME_LIMIT).setShardsNumber(0).setFlushRowLimit(10000).setQuotationMark(CSV_QUOTE_CHAR).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized String getValueOrNull(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> valueProvider) {
        return valueProvider != null && valueProvider.get() != null ? (String)valueProvider.get() : null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isNotEmpty(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> valueProvider) {
        return valueProvider != null && valueProvider.get() != null && !((String)valueProvider.get()).isEmpty();
    }

    public static class DataSourceProviderFromDataSourceConfiguration
    implements SerializableFunction<Void, DataSource>,
    HasDisplayData {
        private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized DataSourceConfiguration, @UnknownKeyFor @NonNull @Initialized DataSource> instances = new ConcurrentHashMap();
        private final @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration config;

        private DataSourceProviderFromDataSourceConfiguration(@UnknownKeyFor @NonNull @Initialized DataSourceConfiguration config) {
            this.config = config;
        }

        public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> of(@UnknownKeyFor @NonNull @Initialized DataSourceConfiguration config) {
            return new DataSourceProviderFromDataSourceConfiguration(config);
        }

        public @UnknownKeyFor @NonNull @Initialized DataSource apply(@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void input) {
            return instances.computeIfAbsent(this.config, config -> config.buildDatasource());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration getConfig() {
            return this.config;
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class DataSourceConfiguration
    implements Serializable {
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getUrl();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getUsername();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getPassword();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized PrivateKey getPrivateKey();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getRawPrivateKey();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getPrivateKeyPassphrase();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getOauthToken();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getDatabase();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getWarehouse();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getSchema();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getServerName();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer getPortNumber();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getRole();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getAuthenticator();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer getLoginTimeout();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Boolean getSsl();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized DataSource getDataSource();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public static @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration create() {
            return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().build();
        }

        public static @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration create(@UnknownKeyFor @NonNull @Initialized DataSource dataSource) {
            Preconditions.checkArgument((boolean)(dataSource instanceof Serializable), (Object)"dataSource must be Serializable");
            return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setDataSource(dataSource).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withUsernamePasswordAuth(@UnknownKeyFor @NonNull @Initialized String username, @UnknownKeyFor @NonNull @Initialized String password) {
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withUsernamePasswordAuth(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password) {
            return this.builder().setUsername(username).setPassword(password).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withOAuth(@UnknownKeyFor @NonNull @Initialized String token) {
            return this.builder().setOauthToken((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)token)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withOAuth(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> token) {
            return this.builder().setOauthToken(token).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairAuth(@UnknownKeyFor @NonNull @Initialized String username, @UnknownKeyFor @NonNull @Initialized PrivateKey privateKey) {
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setPrivateKey(privateKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairPathAuth(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username, @UnknownKeyFor @NonNull @Initialized String privateKeyPath, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> privateKeyPassphrase) {
            String privateKey = KeyPairUtils.readPrivateKeyFile(privateKeyPath);
            return this.builder().setUsername(username).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKey)).setPrivateKeyPassphrase(privateKeyPassphrase).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairPathAuth(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username, @UnknownKeyFor @NonNull @Initialized String privateKeyPath) {
            String privateKey = KeyPairUtils.readPrivateKeyFile(privateKeyPath);
            return this.builder().setUsername(username).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKey)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairPathAuth(@UnknownKeyFor @NonNull @Initialized String username, @UnknownKeyFor @NonNull @Initialized String privateKeyPath, @UnknownKeyFor @NonNull @Initialized String privateKeyPassphrase) {
            String privateKey = KeyPairUtils.readPrivateKeyFile(privateKeyPath);
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKey)).setPrivateKeyPassphrase((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKeyPassphrase)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairPathAuth(@UnknownKeyFor @NonNull @Initialized String username, @UnknownKeyFor @NonNull @Initialized String privateKeyPath) {
            String privateKey = KeyPairUtils.readPrivateKeyFile(privateKeyPath);
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKey)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairRawAuth(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rawPrivateKey, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> privateKeyPassphrase) {
            return this.builder().setUsername(username).setRawPrivateKey(rawPrivateKey).setPrivateKeyPassphrase(privateKeyPassphrase).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairRawAuth(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rawPrivateKey) {
            return this.builder().setUsername(username).setRawPrivateKey(rawPrivateKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairRawAuth(@UnknownKeyFor @NonNull @Initialized String username, @UnknownKeyFor @NonNull @Initialized String rawPrivateKey, @UnknownKeyFor @NonNull @Initialized String privateKeyPassphrase) {
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rawPrivateKey)).setPrivateKeyPassphrase((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKeyPassphrase)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withKeyPairRawAuth(@UnknownKeyFor @NonNull @Initialized String username, @UnknownKeyFor @NonNull @Initialized String rawPrivateKey) {
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rawPrivateKey)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withUrl(@UnknownKeyFor @NonNull @Initialized String url) {
            Preconditions.checkArgument((boolean)url.startsWith("jdbc:snowflake://"), (Object)"url must have format: jdbc:snowflake://<account_name>.snowflakecomputing.com");
            Preconditions.checkArgument((boolean)url.endsWith("snowflakecomputing.com"), (Object)"url must have format: jdbc:snowflake://<account_name>.snowflakecomputing.com");
            return this.builder().setUrl(url).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
            return this.builder().setDatabase((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)database)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withDatabase(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> database) {
            return this.builder().setDatabase(database).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withWarehouse(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> warehouse) {
            return this.builder().setWarehouse(warehouse).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withWarehouse(@UnknownKeyFor @NonNull @Initialized String warehouse) {
            return this.withWarehouse((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)warehouse));
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withSchema(@UnknownKeyFor @NonNull @Initialized String schema) {
            return this.builder().setSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)schema)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> schema) {
            return this.builder().setSchema(schema).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withServerName(@UnknownKeyFor @NonNull @Initialized String serverName) {
            Preconditions.checkArgument((boolean)serverName.endsWith("snowflakecomputing.com"), (Object)"serverName must be in format <account_name>.snowflakecomputing.com");
            return this.withServerName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)serverName));
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withServerName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> serverName) {
            return this.builder().setServerName(serverName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withPortNumber(@UnknownKeyFor @NonNull @Initialized Integer portNumber) {
            return this.builder().setPortNumber(portNumber).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withRole(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> role) {
            return this.builder().setRole(role).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withRole(@UnknownKeyFor @NonNull @Initialized String role) {
            return this.withRole((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)role));
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withAuthenticator(@UnknownKeyFor @NonNull @Initialized String authenticator) {
            return this.builder().setAuthenticator(authenticator).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration withLoginTimeout(@UnknownKeyFor @NonNull @Initialized Integer loginTimeout) {
            return this.builder().setLoginTimeout(loginTimeout).build();
        }

        void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            if (this.getDataSource() != null) {
                builder.addIfNotNull(DisplayData.item((String)"dataSource", (String)this.getDataSource().getClass().getName()));
            } else {
                builder.addIfNotNull(DisplayData.item((String)"jdbcUrl", (String)this.getUrl()));
                builder.addIfNotNull(DisplayData.item((String)"username", this.getUsername()));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized DataSource buildDatasource() {
            if (this.getDataSource() == null) {
                SnowflakeBasicDataSource basicDataSource = new SnowflakeBasicDataSource();
                basicDataSource.setUrl(this.buildUrl());
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getOauthToken())) {
                    basicDataSource.setOauthToken((String)this.getOauthToken().get());
                } else if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getUsername()) && this.getPrivateKey() != null) {
                    basicDataSource.setUser((String)this.getUsername().get());
                    basicDataSource.setPrivateKey(this.getPrivateKey());
                } else if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getUsername()) && SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getRawPrivateKey())) {
                    PrivateKey privateKey = KeyPairUtils.preparePrivateKey((String)this.getRawPrivateKey().get(), SnowflakeIO.getValueOrNull((ValueProvider<String>)this.getPrivateKeyPassphrase()));
                    basicDataSource.setPrivateKey(privateKey);
                    basicDataSource.setUser((String)this.getUsername().get());
                } else if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getUsername()) && SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getPassword())) {
                    basicDataSource.setUser((String)this.getUsername().get());
                    basicDataSource.setPassword((String)this.getPassword().get());
                } else {
                    throw new RuntimeException("Missing credentials values. Please check your credentials");
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getDatabase())) {
                    basicDataSource.setDatabaseName((String)this.getDatabase().get());
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getWarehouse())) {
                    basicDataSource.setWarehouse((String)this.getWarehouse().get());
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getSchema())) {
                    basicDataSource.setSchema((String)this.getSchema().get());
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getServerName())) {
                    basicDataSource.setServerName((String)this.getServerName().get());
                }
                if (this.getPortNumber() != null) {
                    basicDataSource.setPortNumber(this.getPortNumber().intValue());
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getRole())) {
                    basicDataSource.setRole((String)this.getRole().get());
                }
                if (this.getAuthenticator() != null) {
                    basicDataSource.setAuthenticator(this.getAuthenticator());
                }
                if (this.getLoginTimeout() != null) {
                    try {
                        basicDataSource.setLoginTimeout(this.getLoginTimeout().intValue());
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Failed to setLoginTimeout");
                    }
                }
                return basicDataSource;
            }
            return this.getDataSource();
        }

        private @UnknownKeyFor @NonNull @Initialized String buildUrl() {
            StringBuilder url = new StringBuilder();
            if (this.getUrl() != null) {
                url.append(this.getUrl());
            } else {
                url.append("jdbc:snowflake://");
                url.append((String)this.getServerName().get());
            }
            if (this.getPortNumber() != null) {
                url.append(":").append(this.getPortNumber());
            }
            url.append("?application=beam");
            return url.toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPrivateKey(@UnknownKeyFor @NonNull @Initialized PrivateKey var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRawPrivateKey(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPrivateKeyPassphrase(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setOauthToken(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabase(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWarehouse(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setServerName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPortNumber(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRole(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAuthenticator(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setLoginTimeout(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSsl(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDataSource(@UnknownKeyFor @NonNull @Initialized DataSource var1);

            abstract @UnknownKeyFor @NonNull @Initialized DataSourceConfiguration build();
        }
    }

    private static class StreamToTableFn
    extends DoFn<List<String>, Void> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> dataSourceProviderFn;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> snowPipe;
        private final @UnknownKeyFor @NonNull @Initialized StreamingLogLevel debugMode;
        private final @UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices;
        private transient @UnknownKeyFor @NonNull @Initialized SimpleIngestManager ingestManager;
        @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized String> trackedFilesNames;

        StreamToTableFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> dataSourceProviderFn, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> snowPipe, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir, @UnknownKeyFor @NonNull @Initialized StreamingLogLevel debugMode, @UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            this.stagingBucketDir = stagingBucketDir;
            this.snowPipe = snowPipe;
            this.debugMode = debugMode;
            this.snowflakeServices = snowflakeServices;
            this.trackedFilesNames = new ArrayList();
        }

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.dataSourceProviderFn.apply(null);
            DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
            DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
            PrivateKey privateKey = null;
            if (config.getPrivateKey() != null) {
                privateKey = config.getPrivateKey();
            } else if (SnowflakeIO.isNotEmpty((ValueProvider<String>)config.getPrivateKeyPassphrase()) && SnowflakeIO.isNotEmpty((ValueProvider<String>)config.getRawPrivateKey())) {
                privateKey = KeyPairUtils.preparePrivateKey((String)config.getRawPrivateKey().get(), (String)config.getPrivateKeyPassphrase().get());
            }
            Preconditions.checkArgument((privateKey != null ? 1 : 0) != 0, (Object)"KeyPair is required for authentication");
            String hostName = (String)config.getServerName().get();
            List path = Splitter.on((char)'.').splitToList((CharSequence)hostName);
            String account = (String)path.get(0);
            String username = (String)config.getUsername().get();
            String schema = (String)config.getSchema().get();
            String database = (String)config.getDatabase().get();
            String snowPipeName = String.format("%s.%s.%s", database, schema, this.snowPipe.get());
            this.ingestManager = new SimpleIngestManager(account, username, snowPipeName, privateKey, "https", hostName, 443);
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
            List filesList = (List)context.element();
            if (this.debugMode != null) {
                this.trackedFilesNames.addAll(filesList);
            }
            SnowflakeStreamingServiceConfig config = new SnowflakeStreamingServiceConfig(filesList, (String)this.stagingBucketDir.get(), this.ingestManager);
            this.snowflakeServices.getStreamingService().write(config);
        }

        @DoFn.FinishBundle
        public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.debugMode != null) {
                String beginMark = null;
                Duration currentSleep = Duration.ZERO;
                while (currentSleep.isShorterThan((ReadableDuration)DEFAULT_STREAMING_LOGS_MAX_SLEEP) && this.trackedFilesNames.size() > 0) {
                    Thread.sleep(DEFAULT_SLEEP_STREAMING_LOGS.getMillis());
                    currentSleep = currentSleep.plus((ReadableDuration)DEFAULT_SLEEP_STREAMING_LOGS);
                    HistoryResponse response = this.ingestManager.getHistory(null, null, beginMark);
                    if (response != null && response.getNextBeginMark() != null) {
                        beginMark = response.getNextBeginMark();
                    }
                    if (response == null || response.files == null) continue;
                    response.files.forEach(entry -> {
                        String responseFileName;
                        if (entry.getPath() != null && entry.isComplete().booleanValue() && this.trackedFilesNames.contains(responseFileName = String.format("'%s%s'", entry.getStageLocation(), entry.getPath()).toLowerCase().replace("gcs://", "gs://"))) {
                            this.trackedFilesNames.remove(responseFileName);
                            if (entry.getErrorsSeen() > 0L) {
                                LOG.error(String.format("Snowflake SnowPipe ERROR: %s", entry.toString()));
                            } else if (entry.getErrorsSeen() == 0L && this.debugMode.equals((Object)StreamingLogLevel.INFO)) {
                                LOG.info(String.format("Snowflake SnowPipe INFO: %s", entry.toString()));
                            }
                        }
                    });
                }
                this.trackedFilesNames.forEach(file -> LOG.info(String.format("File %s was not found in ingest history", file)));
            }
        }
    }

    private static class CopyToTableFn
    extends DoFn<List<String>, Void> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> dataSourceProviderFn;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> database;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> schema;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query;
        private final @UnknownKeyFor @NonNull @Initialized SnowflakeTableSchema tableSchema;
        private final @UnknownKeyFor @NonNull @Initialized String quotationMark;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> storageIntegrationName;
        private final @UnknownKeyFor @NonNull @Initialized WriteDisposition writeDisposition;
        private final @UnknownKeyFor @NonNull @Initialized CreateDisposition createDisposition;
        private final @UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices;

        CopyToTableFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> dataSourceProviderFn, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> storageIntegrationName, @UnknownKeyFor @NonNull @Initialized CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized WriteDisposition writeDisposition, @UnknownKeyFor @NonNull @Initialized SnowflakeTableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices, @UnknownKeyFor @NonNull @Initialized String quotationMark) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            this.query = query;
            this.table = table;
            this.tableSchema = tableSchema;
            this.stagingBucketDir = stagingBucketDir;
            this.storageIntegrationName = storageIntegrationName;
            this.writeDisposition = writeDisposition;
            this.createDisposition = createDisposition;
            this.snowflakeServices = snowflakeServices;
            this.quotationMark = quotationMark;
            DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
            DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
            this.database = config.getDatabase();
            this.schema = config.getSchema();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
            String databaseValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.database);
            String schemaValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.schema);
            String tableValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.table);
            String queryValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.query);
            SnowflakeBatchServiceConfig config = new SnowflakeBatchServiceConfig(this.dataSourceProviderFn, (List)context.element(), this.tableSchema, databaseValue, schemaValue, tableValue, queryValue, this.createDisposition, this.writeDisposition, (String)this.storageIntegrationName.get(), (String)this.stagingBucketDir.get(), this.quotationMark);
            this.snowflakeServices.getBatchService().write(config);
        }
    }

    private static class MapObjectsArrayToCsvFn
    extends DoFn<Object[], String> {
        private @UnknownKeyFor @NonNull @Initialized String quotationMark;

        public MapObjectsArrayToCsvFn(@UnknownKeyFor @NonNull @Initialized String quotationMark) {
            this.quotationMark = quotationMark;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            ArrayList<Object> csvItems = new ArrayList<Object>();
            for (Object o : (Object[])context.element()) {
                if (o instanceof String) {
                    String field = (String)o;
                    field = field.replace(SnowflakeIO.CSV_QUOTE_CHAR, "''");
                    field = this.quoteField(field);
                    csvItems.add(field);
                    continue;
                }
                csvItems.add(o);
            }
            context.output((Object)Joiner.on((String)",").useForNull("").join(csvItems));
        }

        private @UnknownKeyFor @NonNull @Initialized String quoteField(@UnknownKeyFor @NonNull @Initialized String field) {
            return this.quoteField(field, this.quotationMark);
        }

        private @UnknownKeyFor @NonNull @Initialized String quoteField(@UnknownKeyFor @NonNull @Initialized String field, @UnknownKeyFor @NonNull @Initialized String quotation) {
            return String.format("%s%s%s", quotation, field, quotation);
        }
    }

    public static class Concatenate
    extends Combine.CombineFn<String, List<String>, List<String>> {
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> createAccumulator() {
            return new ArrayList<String>();
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> addInput(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> mutableAccumulator, @UnknownKeyFor @NonNull @Initialized String input) {
            mutableAccumulator.add(String.format("'%s'", input));
            return mutableAccumulator;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> accumulators) {
            Object result = this.createAccumulator();
            for (List<String> accumulator : accumulators) {
                result.addAll(accumulator);
            }
            return result;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> extractOutput(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> accumulator) {
            return accumulator;
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> getDataSourceProviderFn();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTable();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getStorageIntegrationName();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getStagingBucketName();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getSnowPipe();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer getFlushRowLimit();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer getShardsNumber();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration getFlushTimeLimit();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getFileNameTemplate();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized WriteDisposition getWriteDisposition();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized CreateDisposition getCreateDisposition();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized UserDataMapper<T> getUserDataMapper();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SnowflakeTableSchema getTableSchema();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SnowflakeServices getSnowflakeServices();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getQuotationMark();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized StreamingLogLevel getDebugMode();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDataSourceConfiguration(@UnknownKeyFor @NonNull @Initialized DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(DataSourceProviderFromDataSourceConfiguration.of(config));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDataSourceProviderFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized String table) {
            return this.toBuilder().setTable((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)table)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table) {
            return this.toBuilder().setTable(table).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withStagingBucketName(@UnknownKeyFor @NonNull @Initialized String stagingBucketName) {
            Preconditions.checkArgument((boolean)stagingBucketName.endsWith("/"), (Object)"stagingBucketName must be a cloud storage path ending with /");
            return this.toBuilder().setStagingBucketName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)stagingBucketName)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withStagingBucketName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketName) {
            return this.toBuilder().setStagingBucketName(stagingBucketName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withStorageIntegrationName(@UnknownKeyFor @NonNull @Initialized String integrationName) {
            return this.toBuilder().setStorageIntegrationName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)integrationName)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withStorageIntegrationName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> integrationName) {
            return this.toBuilder().setStorageIntegrationName(integrationName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withQueryTransformation(@UnknownKeyFor @NonNull @Initialized String query) {
            return this.toBuilder().setQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withQueryTransformation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            return this.toBuilder().setQuery(query).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFileNameTemplate(@UnknownKeyFor @NonNull @Initialized String fileNameTemplate) {
            return this.toBuilder().setFileNameTemplate(fileNameTemplate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withUserDataMapper(@UnknownKeyFor @NonNull @Initialized UserDataMapper<T> userDataMapper) {
            return this.toBuilder().setUserDataMapper(userDataMapper).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFlushTimeLimit(@UnknownKeyFor @NonNull @Initialized Duration triggeringFrequency) {
            return this.toBuilder().setFlushTimeLimit(triggeringFrequency).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSnowPipe(@UnknownKeyFor @NonNull @Initialized String snowPipe) {
            return this.toBuilder().setSnowPipe((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)snowPipe)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSnowPipe(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> snowPipe) {
            return this.toBuilder().setSnowPipe(snowPipe).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withShardsNumber(@UnknownKeyFor @NonNull @Initialized Integer shardsNumber) {
            return this.toBuilder().setShardsNumber(shardsNumber).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFlushRowLimit(@UnknownKeyFor @NonNull @Initialized Integer rowsCount) {
            return this.toBuilder().setFlushRowLimit(rowsCount).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWriteDisposition(@UnknownKeyFor @NonNull @Initialized WriteDisposition writeDisposition) {
            return this.toBuilder().setWriteDisposition(writeDisposition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withCreateDisposition(@UnknownKeyFor @NonNull @Initialized CreateDisposition createDisposition) {
            return this.toBuilder().setCreateDisposition(createDisposition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTableSchema(@UnknownKeyFor @NonNull @Initialized SnowflakeTableSchema tableSchema) {
            return this.toBuilder().setTableSchema(tableSchema).build();
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Write<T> withSnowflakeServices(@UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices) {
            return this.toBuilder().setSnowflakeServices(snowflakeServices).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withQuotationMark(@UnknownKeyFor @NonNull @Initialized String quotationMark) {
            return this.toBuilder().setQuotationMark(quotationMark).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDebugMode(@UnknownKeyFor @NonNull @Initialized StreamingLogLevel debugLevel) {
            return this.toBuilder().setDebugMode(debugLevel).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            this.checkArguments(input);
            PCollection<Void> out = this.getSnowPipe() != null ? this.writeStream(input, this.getStagingBucketName()) : this.writeBatch(input, this.getStagingBucketName());
            return PDone.in((Pipeline)out.getPipeline());
        }

        private void checkArguments(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Preconditions.checkArgument((this.getStagingBucketName() != null ? 1 : 0) != 0, (Object)"withStagingBucketName is required");
            Preconditions.checkArgument((this.getUserDataMapper() != null ? 1 : 0) != 0, (Object)"withUserDataMapper() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            if (input.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                Preconditions.checkArgument((this.getSnowPipe() != null ? 1 : 0) != 0, (Object)"in streaming (unbounded) write it is required to specify SnowPipe name via withSnowPipe() method.");
            } else {
                Preconditions.checkArgument((this.getTable() != null ? 1 : 0) != 0, (Object)"in batch writing it is required to specify destination table name via to() method.");
            }
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void> writeStream(@UnknownKeyFor @NonNull @Initialized PCollection<T> input, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir) {
            SnowflakeServices snowflakeServices = this.getSnowflakeServices() != null ? this.getSnowflakeServices() : new SnowflakeServicesImpl();
            PCollection inputInGlobalWindow = (PCollection)input.apply("Rewindow Into Global", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.getFlushTimeLimit()), AfterPane.elementCountAtLeast((int)this.getFlushRowLimit())}))).discardingFiredPanes());
            int shards = this.getShardsNumber() > 0 ? this.getShardsNumber() : 1;
            PCollection files = this.writeFiles(inputInGlobalWindow, stagingBucketDir, shards);
            files = (PCollection)files.apply("Apply User Trigger", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.getFlushTimeLimit()))).discardingFiredPanes());
            PCollection filesConcatenated = (PCollection)files.apply("Create list of files for loading via SnowPipe", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new Concatenate()).withoutDefaults());
            return (PCollection)filesConcatenated.apply("Stream files to table", this.streamToTable(snowflakeServices, stagingBucketDir));
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void> writeBatch(@UnknownKeyFor @NonNull @Initialized PCollection<T> input, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir) {
            SnowflakeServices snowflakeServices = this.getSnowflakeServices() != null ? this.getSnowflakeServices() : new SnowflakeServicesImpl();
            PCollection<String> files = this.writeBatchFiles(input, stagingBucketDir);
            ListCoder coder = ListCoder.of((Coder)StringUtf8Coder.of());
            PCollection reifiedFiles = (PCollection)files.getPipeline().apply(Reify.viewInGlobalWindow((PCollectionView)((PCollectionView)files.apply((PTransform)View.asList())), (Coder)coder));
            return (PCollection)reifiedFiles.apply("Copy files to table", this.copyToTable(snowflakeServices, stagingBucketDir));
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> writeBatchFiles(@UnknownKeyFor @NonNull @Initialized PCollection<T> input, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> outputDirectory) {
            int shards = this.getShardsNumber() > 0 ? this.getShardsNumber() : 0;
            return this.writeFiles(input, outputDirectory, shards);
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> writeFiles(@UnknownKeyFor @NonNull @Initialized PCollection<T> input, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir, @UnknownKeyFor @NonNull @Initialized int numShards) {
            PCollection mappedUserData = ((PCollection)((PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<T, Object[]>(){

                public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] apply(T element) {
                    return this.getUserDataMapper().mapRow(element);
                }
            }))).apply("Map Objects array to CSV lines", (PTransform)ParDo.of((DoFn)new MapObjectsArrayToCsvFn(this.getQuotationMark())))).setCoder((Coder)StringUtf8Coder.of());
            WriteFilesResult filesResult = (WriteFilesResult)mappedUserData.apply("Write files to specified location", (PTransform)FileIO.write().via((FileIO.Sink)TextIO.sink()).to(stagingBucketDir).withPrefix(UUID.randomUUID().toString().subSequence(0, 8).toString()).withSuffix(".csv").withNumShards(numShards).withCompression(Compression.GZIP));
            return (PCollection)filesResult.getPerDestinationOutputFilenames().apply("Parse KV filenames to Strings", (PTransform)Values.create());
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void> copyToTable(@UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir) {
            return ParDo.of((DoFn)new CopyToTableFn(this.getDataSourceProviderFn(), this.getTable(), this.getQuery(), stagingBucketDir, this.getStorageIntegrationName(), this.getCreateDisposition(), this.getWriteDisposition(), this.getTableSchema(), snowflakeServices, this.getQuotationMark()));
        }

        protected // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void> streamToTable(@UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir) {
            return ParDo.of((DoFn)new StreamToTableFn(this.getDataSourceProviderFn(), this.getSnowPipe(), stagingBucketDir, this.getDebugMode(), snowflakeServices));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDataSourceProviderFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTable(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setStorageIntegrationName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setStagingBucketName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSnowPipe(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFlushRowLimit(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setShardsNumber(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFlushTimeLimit(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFileNameTemplate(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUserDataMapper(@UnknownKeyFor @NonNull @Initialized UserDataMapper<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteDisposition(@UnknownKeyFor @NonNull @Initialized WriteDisposition var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCreateDisposition(@UnknownKeyFor @NonNull @Initialized CreateDisposition var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTableSchema(@UnknownKeyFor @NonNull @Initialized SnowflakeTableSchema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSnowflakeServices(@UnknownKeyFor @NonNull @Initialized SnowflakeServices var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQuotationMark(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDebugMode(@UnknownKeyFor @NonNull @Initialized StreamingLogLevel var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> getDataSourceProviderFn();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTable();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getStorageIntegrationName();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getStagingBucketName();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized CsvMapper<T> getCsvMapper();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Coder<T> getCoder();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SnowflakeServices getSnowflakeServices();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuotationMark();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> withDataSourceConfiguration(@UnknownKeyFor @NonNull @Initialized DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(DataSourceProviderFromDataSourceConfiguration.of(config));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withDataSourceProviderFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> fromQuery(@UnknownKeyFor @NonNull @Initialized String query) {
            return this.toBuilder().setQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> fromQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            return this.toBuilder().setQuery(query).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> fromTable(@UnknownKeyFor @NonNull @Initialized String table) {
            return this.toBuilder().setTable((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)table)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> fromTable(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table) {
            return this.toBuilder().setTable(table).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withStagingBucketName(@UnknownKeyFor @NonNull @Initialized String stagingBucketName) {
            Preconditions.checkArgument((boolean)stagingBucketName.endsWith("/"), (Object)"stagingBucketName must be a cloud storage path ending with /");
            return this.toBuilder().setStagingBucketName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)stagingBucketName)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withStagingBucketName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketName) {
            return this.toBuilder().setStagingBucketName(stagingBucketName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withStorageIntegrationName(@UnknownKeyFor @NonNull @Initialized String integrationName) {
            return this.toBuilder().setStorageIntegrationName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)integrationName)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withStorageIntegrationName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> integrationName) {
            return this.toBuilder().setStorageIntegrationName(integrationName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCsvMapper(@UnknownKeyFor @NonNull @Initialized CsvMapper<T> csvMapper) {
            return this.toBuilder().setCsvMapper(csvMapper).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withQuotationMark(@UnknownKeyFor @NonNull @Initialized String quotationMark) {
            return this.toBuilder().setQuotationMark((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)quotationMark)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withQuotationMark(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> quotationMark) {
            return this.toBuilder().setQuotationMark(quotationMark).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.checkArguments();
            PCollection emptyCollection = (PCollection)input.apply((PTransform)Create.of((Object)null, (Object[])new Void[0]));
            String tmpDirName = this.makeTmpDirName();
            PCollection output = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)emptyCollection.apply((PTransform)ParDo.of((DoFn)new CopyIntoStageFn(this.getDataSourceProviderFn(), this.getQuery(), this.getTable(), this.getStorageIntegrationName(), this.getStagingBucketName(), tmpDirName, this.getSnowflakeServices(), this.getQuotationMark())))).apply((PTransform)Reshuffle.viaRandomKey())).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply((PTransform)TextIO.readFiles())).apply((PTransform)ParDo.of((DoFn)new MapCsvToStringArrayFn(this.getQuotationMark())))).apply((PTransform)ParDo.of(new MapStringArrayToUserDataFn<T>(this.getCsvMapper())));
            output.setCoder(this.getCoder());
            ((PCollection)emptyCollection.apply((PTransform)Wait.on((PCollection[])new PCollection[]{output}))).apply((PTransform)ParDo.of((DoFn)new CleanTmpFilesFromGcsFn(this.getStagingBucketName(), tmpDirName)));
            return output;
        }

        private void checkArguments() {
            Preconditions.checkArgument((this.getStorageIntegrationName() != null ? 1 : 0) != 0, (Object)"withStorageIntegrationName() is required");
            Preconditions.checkArgument((this.getStagingBucketName() != null ? 1 : 0) != 0, (Object)"withStagingBucketName() is required");
            Preconditions.checkArgument((this.getQuery() != null || this.getTable() != null ? 1 : 0) != 0, (Object)"fromTable() or fromQuery() is required");
            Preconditions.checkArgument((this.getQuery() == null || this.getTable() == null ? 1 : 0) != 0, (Object)"fromTable() and fromQuery() are not allowed together");
            Preconditions.checkArgument((this.getCsvMapper() != null ? 1 : 0) != 0, (Object)"withCsvMapper() is required");
            Preconditions.checkArgument((this.getCoder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
        }

        private @UnknownKeyFor @NonNull @Initialized String makeTmpDirName() {
            return String.format("sf_copy_csv_%s_%s", new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()), UUID.randomUUID().toString().subSequence(0, 8));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            if (this.getQuery() != null) {
                builder.add(DisplayData.item((String)"query", this.getQuery()));
            }
            if (this.getTable() != null) {
                builder.add(DisplayData.item((String)"table", this.getTable()));
            }
            builder.add(DisplayData.item((String)"storageIntegrationName", this.getStagingBucketName()));
            builder.add(DisplayData.item((String)"stagingBucketName", this.getStagingBucketName()));
            builder.add(DisplayData.item((String)"csvMapper", (String)this.getCsvMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            if (this.getDataSourceProviderFn() instanceof HasDisplayData) {
                ((HasDisplayData)this.getDataSourceProviderFn()).populateDisplayData(builder);
            }
        }

        public static class CleanTmpFilesFromGcsFn
        extends DoFn<Object, Object> {
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir;
            private final @UnknownKeyFor @NonNull @Initialized String tmpDirName;

            public CleanTmpFilesFromGcsFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir, @UnknownKeyFor @NonNull @Initialized String tmpDirName) {
                this.stagingBucketDir = stagingBucketDir;
                this.tmpDirName = tmpDirName;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                String combinedPath = String.format("%s/%s/**", this.stagingBucketDir.get(), this.tmpDirName);
                List paths = FileSystems.match((String)combinedPath).metadata().stream().map(metadata -> metadata.resourceId()).collect(Collectors.toList());
                FileSystems.delete(paths, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
            }
        }

        private static class MapStringArrayToUserDataFn<@UnknownKeyFor T>
        extends DoFn<String[], T> {
            private final @UnknownKeyFor @NonNull @Initialized CsvMapper<T> csvMapper;

            public MapStringArrayToUserDataFn(@UnknownKeyFor @NonNull @Initialized CsvMapper<T> csvMapper) {
                this.csvMapper = csvMapper;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                context.output(this.csvMapper.mapRow((String[])context.element()));
            }
        }

        public static class MapCsvToStringArrayFn
        extends DoFn<String, String[]> {
            private @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> quoteChar;

            public MapCsvToStringArrayFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> quoteChar) {
                this.quoteChar = quoteChar;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                String csvLine = (String)c.element();
                CSVParser parser = new CSVParserBuilder().withQuoteChar(((String)this.quoteChar.get()).charAt(0)).build();
                String[] parts = parser.parseLine(csvLine);
                c.output((Object)parts);
            }
        }

        private static class CopyIntoStageFn
        extends DoFn<Object, String> {
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> dataSourceProviderFn;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> database;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> schema;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> storageIntegrationName;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir;
            private final @UnknownKeyFor @NonNull @Initialized String tmpDirName;
            private final @UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> quotationMark;

            private CopyIntoStageFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> dataSourceProviderFn, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> storageIntegrationName, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> stagingBucketDir, @UnknownKeyFor @NonNull @Initialized String tmpDirName, @UnknownKeyFor @NonNull @Initialized SnowflakeServices snowflakeServices, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> quotationMark) {
                this.dataSourceProviderFn = dataSourceProviderFn;
                this.query = query;
                this.table = table;
                this.storageIntegrationName = storageIntegrationName;
                this.snowflakeServices = snowflakeServices;
                this.quotationMark = quotationMark;
                this.stagingBucketDir = stagingBucketDir;
                this.tmpDirName = tmpDirName;
                DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
                DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
                this.database = config.getDatabase();
                this.schema = config.getSchema();
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                String databaseValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.database);
                String schemaValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.schema);
                String tableValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.table);
                String queryValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.query);
                String stagingBucketRunDir = String.format("%s/%s/run_%s/", this.stagingBucketDir.get(), this.tmpDirName, UUID.randomUUID().toString().subSequence(0, 8));
                SnowflakeBatchServiceConfig config = new SnowflakeBatchServiceConfig(this.dataSourceProviderFn, databaseValue, schemaValue, tableValue, queryValue, (String)this.storageIntegrationName.get(), stagingBucketRunDir, (String)this.quotationMark.get());
                String output = this.snowflakeServices.getBatchService().read(config);
                context.output((Object)output);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDataSourceProviderFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized DataSource> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTable(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setStorageIntegrationName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setStagingBucketName(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCsvMapper(@UnknownKeyFor @NonNull @Initialized CsvMapper<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSnowflakeServices(@UnknownKeyFor @NonNull @Initialized SnowflakeServices var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQuotationMark(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }

    @FunctionalInterface
    public static interface UserDataMapper<@UnknownKeyFor T>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] mapRow(T var1);
    }

    @FunctionalInterface
    public static interface CsvMapper<@UnknownKeyFor T>
    extends Serializable {
        public T mapRow(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] var1) throws @UnknownKeyFor @NonNull @Initialized Exception;
    }
}

