/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.IngestResponseException;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeService;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeStreamingServiceConfig;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeStreamingServiceImpl
implements SnowflakeService<SnowflakeStreamingServiceConfig> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SnowflakeStreamingServiceImpl.class);
    private transient @UnknownKeyFor @NonNull @Initialized SimpleIngestManager ingestManager;

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized SnowflakeStreamingServiceConfig config) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.ingest(config);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String read(@UnknownKeyFor @NonNull @Initialized SnowflakeStreamingServiceConfig config) throws @UnknownKeyFor @NonNull @Initialized Exception {
        throw new UnsupportedOperationException("Not supported by SnowflakeIO.");
    }

    private void ingest(@UnknownKeyFor @NonNull @Initialized SnowflakeStreamingServiceConfig config) throws @UnknownKeyFor @NonNull @Initialized IngestResponseException, @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized URISyntaxException {
        List<String> filesList = config.getFilesList();
        String stagingBucketDir = config.getStagingBucketDir();
        this.ingestManager = config.getIngestManager();
        Set files = filesList.stream().map(e -> e.replaceAll(String.valueOf(stagingBucketDir), "")).map(e -> e.replaceAll("'", "")).collect(Collectors.toSet());
        if (!files.isEmpty()) {
            this.ingestManager.ingestFiles(SimpleIngestManager.wrapFilepaths(files), null);
        }
    }
}

