/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.data.text;

import java.io.Serializable;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SnowflakeBinary
implements SnowflakeDataType,
Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized Long MAX_SIZE = 0x800000L;
    private @UnknownKeyFor @NonNull @Initialized Long size;

    public SnowflakeBinary() {
    }

    public static @UnknownKeyFor @NonNull @Initialized SnowflakeBinary of() {
        return new SnowflakeBinary();
    }

    public static @UnknownKeyFor @NonNull @Initialized SnowflakeBinary of(@UnknownKeyFor @NonNull @Initialized long size) {
        return new SnowflakeBinary(size);
    }

    public SnowflakeBinary(@UnknownKeyFor @NonNull @Initialized long size) {
        if (size > MAX_SIZE) {
            throw new IllegalArgumentException(String.format("Provided size %s is bigger than max size %s ", size, MAX_SIZE));
        }
        this.size = size;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String sql() {
        if (this.size != null) {
            return String.format("BINARY(%d)", this.size);
        }
        return "BINARY";
    }

    public @UnknownKeyFor @NonNull @Initialized Long getSize() {
        return this.size;
    }

    public void setSize(@UnknownKeyFor @NonNull @Initialized Long size) {
        this.size = size;
    }
}

