/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import org.apache.beam.sdk.io.redis.RedisConnectionConfiguration;
import org.apache.beam.sdk.io.redis.RedisIO;

final class AutoValue_RedisIO_WriteStreams
extends RedisIO.WriteStreams {
    private final RedisConnectionConfiguration connectionConfiguration;
    private final long maxLen;
    private final boolean approximateTrim;

    private AutoValue_RedisIO_WriteStreams(RedisConnectionConfiguration connectionConfiguration, long maxLen, boolean approximateTrim) {
        this.connectionConfiguration = connectionConfiguration;
        this.maxLen = maxLen;
        this.approximateTrim = approximateTrim;
    }

    @Override
    RedisConnectionConfiguration connectionConfiguration() {
        return this.connectionConfiguration;
    }

    @Override
    long maxLen() {
        return this.maxLen;
    }

    @Override
    boolean approximateTrim() {
        return this.approximateTrim;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RedisIO.WriteStreams) {
            RedisIO.WriteStreams that = (RedisIO.WriteStreams)((Object)o);
            return this.connectionConfiguration.equals(that.connectionConfiguration()) && this.maxLen == that.maxLen() && this.approximateTrim == that.approximateTrim();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.connectionConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxLen >>> 32 ^ this.maxLen);
        h$ *= 1000003;
        return h$ ^= this.approximateTrim ? 1231 : 1237;
    }

    @Override
    RedisIO.WriteStreams.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RedisIO.WriteStreams.Builder {
        private RedisConnectionConfiguration connectionConfiguration;
        private Long maxLen;
        private Boolean approximateTrim;

        Builder() {
        }

        private Builder(RedisIO.WriteStreams source) {
            this.connectionConfiguration = source.connectionConfiguration();
            this.maxLen = source.maxLen();
            this.approximateTrim = source.approximateTrim();
        }

        @Override
        RedisIO.WriteStreams.Builder setConnectionConfiguration(RedisConnectionConfiguration connectionConfiguration) {
            if (connectionConfiguration == null) {
                throw new NullPointerException("Null connectionConfiguration");
            }
            this.connectionConfiguration = connectionConfiguration;
            return this;
        }

        @Override
        RedisIO.WriteStreams.Builder setMaxLen(long maxLen) {
            this.maxLen = maxLen;
            return this;
        }

        @Override
        RedisIO.WriteStreams.Builder setApproximateTrim(boolean approximateTrim) {
            this.approximateTrim = approximateTrim;
            return this;
        }

        @Override
        RedisIO.WriteStreams build() {
            if (this.connectionConfiguration == null || this.maxLen == null || this.approximateTrim == null) {
                StringBuilder missing = new StringBuilder();
                if (this.connectionConfiguration == null) {
                    missing.append(" connectionConfiguration");
                }
                if (this.maxLen == null) {
                    missing.append(" maxLen");
                }
                if (this.approximateTrim == null) {
                    missing.append(" approximateTrim");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RedisIO_WriteStreams(this.connectionConfiguration, this.maxLen, this.approximateTrim);
        }
    }
}

