/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.redis.RedisConnectionConfiguration;
import org.apache.beam.sdk.io.redis.RedisIO;

final class AutoValue_RedisIO_Read
extends RedisIO.Read {
    private final RedisConnectionConfiguration connectionConfiguration;
    private final String keyPattern;
    private final int batchSize;
    private final boolean outputParallelization;

    private AutoValue_RedisIO_Read(@Nullable RedisConnectionConfiguration connectionConfiguration, @Nullable String keyPattern, int batchSize, boolean outputParallelization) {
        this.connectionConfiguration = connectionConfiguration;
        this.keyPattern = keyPattern;
        this.batchSize = batchSize;
        this.outputParallelization = outputParallelization;
    }

    @Override
    @Nullable
    RedisConnectionConfiguration connectionConfiguration() {
        return this.connectionConfiguration;
    }

    @Override
    @Nullable
    String keyPattern() {
        return this.keyPattern;
    }

    @Override
    int batchSize() {
        return this.batchSize;
    }

    @Override
    boolean outputParallelization() {
        return this.outputParallelization;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RedisIO.Read) {
            RedisIO.Read that = (RedisIO.Read)((Object)o);
            return (this.connectionConfiguration == null ? that.connectionConfiguration() == null : this.connectionConfiguration.equals(that.connectionConfiguration())) && (this.keyPattern == null ? that.keyPattern() == null : this.keyPattern.equals(that.keyPattern())) && this.batchSize == that.batchSize() && this.outputParallelization == that.outputParallelization();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.connectionConfiguration == null ? 0 : this.connectionConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyPattern == null ? 0 : this.keyPattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchSize;
        h$ *= 1000003;
        return h$ ^= this.outputParallelization ? 1231 : 1237;
    }

    @Override
    RedisIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RedisIO.Read.Builder {
        private RedisConnectionConfiguration connectionConfiguration;
        private String keyPattern;
        private Integer batchSize;
        private Boolean outputParallelization;

        Builder() {
        }

        private Builder(RedisIO.Read source) {
            this.connectionConfiguration = source.connectionConfiguration();
            this.keyPattern = source.keyPattern();
            this.batchSize = source.batchSize();
            this.outputParallelization = source.outputParallelization();
        }

        @Override
        RedisIO.Read.Builder setConnectionConfiguration(RedisConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
            return this;
        }

        @Override
        RedisIO.Read.Builder setKeyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
            return this;
        }

        @Override
        RedisIO.Read.Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        RedisIO.Read.Builder setOutputParallelization(boolean outputParallelization) {
            this.outputParallelization = outputParallelization;
            return this;
        }

        @Override
        RedisIO.Read build() {
            String missing = "";
            if (this.batchSize == null) {
                missing = missing + " batchSize";
            }
            if (this.outputParallelization == null) {
                missing = missing + " outputParallelization";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RedisIO_Read(this.connectionConfiguration, this.keyPattern, this.batchSize, this.outputParallelization);
        }
    }
}

