/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import javax.annotation.Nullable;
import org.apache.avro.generic.GenericData;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

final class AutoValue_ParquetIO_Sink
extends ParquetIO.Sink {
    private final String jsonSchema;
    private final CompressionCodecName compressionCodec;
    private final SerializableConfiguration configuration;
    private final int rowGroupSize;
    private final Class<? extends GenericData> avroDataModelClass;

    private AutoValue_ParquetIO_Sink(@Nullable String jsonSchema, CompressionCodecName compressionCodec, @Nullable SerializableConfiguration configuration, int rowGroupSize, @Nullable Class<? extends GenericData> avroDataModelClass) {
        this.jsonSchema = jsonSchema;
        this.compressionCodec = compressionCodec;
        this.configuration = configuration;
        this.rowGroupSize = rowGroupSize;
        this.avroDataModelClass = avroDataModelClass;
    }

    @Override
    @Nullable
    String getJsonSchema() {
        return this.jsonSchema;
    }

    @Override
    CompressionCodecName getCompressionCodec() {
        return this.compressionCodec;
    }

    @Override
    @Nullable
    SerializableConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    int getRowGroupSize() {
        return this.rowGroupSize;
    }

    @Override
    @Nullable
    Class<? extends GenericData> getAvroDataModelClass() {
        return this.avroDataModelClass;
    }

    public String toString() {
        return "Sink{jsonSchema=" + this.jsonSchema + ", compressionCodec=" + this.compressionCodec + ", configuration=" + this.configuration + ", rowGroupSize=" + this.rowGroupSize + ", avroDataModelClass=" + this.avroDataModelClass + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParquetIO.Sink) {
            ParquetIO.Sink that = (ParquetIO.Sink)o;
            return (this.jsonSchema == null ? that.getJsonSchema() == null : this.jsonSchema.equals(that.getJsonSchema())) && this.compressionCodec.equals((Object)that.getCompressionCodec()) && (this.configuration == null ? that.getConfiguration() == null : this.configuration.equals(that.getConfiguration())) && this.rowGroupSize == that.getRowGroupSize() && (this.avroDataModelClass == null ? that.getAvroDataModelClass() == null : this.avroDataModelClass.equals(that.getAvroDataModelClass()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.jsonSchema == null ? 0 : this.jsonSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.compressionCodec.hashCode();
        h$ *= 1000003;
        h$ ^= this.configuration == null ? 0 : this.configuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowGroupSize;
        h$ *= 1000003;
        return h$ ^= this.avroDataModelClass == null ? 0 : this.avroDataModelClass.hashCode();
    }

    @Override
    ParquetIO.Sink.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ParquetIO.Sink.Builder {
        private String jsonSchema;
        private CompressionCodecName compressionCodec;
        private SerializableConfiguration configuration;
        private Integer rowGroupSize;
        private Class<? extends GenericData> avroDataModelClass;

        Builder() {
        }

        private Builder(ParquetIO.Sink source) {
            this.jsonSchema = source.getJsonSchema();
            this.compressionCodec = source.getCompressionCodec();
            this.configuration = source.getConfiguration();
            this.rowGroupSize = source.getRowGroupSize();
            this.avroDataModelClass = source.getAvroDataModelClass();
        }

        @Override
        ParquetIO.Sink.Builder setJsonSchema(String jsonSchema) {
            this.jsonSchema = jsonSchema;
            return this;
        }

        @Override
        ParquetIO.Sink.Builder setCompressionCodec(CompressionCodecName compressionCodec) {
            if (compressionCodec == null) {
                throw new NullPointerException("Null compressionCodec");
            }
            this.compressionCodec = compressionCodec;
            return this;
        }

        @Override
        ParquetIO.Sink.Builder setConfiguration(SerializableConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        ParquetIO.Sink.Builder setRowGroupSize(int rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
            return this;
        }

        @Override
        ParquetIO.Sink.Builder setAvroDataModelClass(Class<? extends GenericData> avroDataModelClass) {
            this.avroDataModelClass = avroDataModelClass;
            return this;
        }

        @Override
        ParquetIO.Sink build() {
            if (this.compressionCodec == null || this.rowGroupSize == null) {
                StringBuilder missing = new StringBuilder();
                if (this.compressionCodec == null) {
                    missing.append(" compressionCodec");
                }
                if (this.rowGroupSize == null) {
                    missing.append(" rowGroupSize");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ParquetIO_Sink(this.jsonSchema, this.compressionCodec, this.configuration, this.rowGroupSize, this.avroDataModelClass);
        }
    }
}

