/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

final class AutoValue_ParquetIO_Sink
extends ParquetIO.Sink {
    private final String jsonSchema;
    private final CompressionCodecName compressionCodec;

    private AutoValue_ParquetIO_Sink(@Nullable String jsonSchema, CompressionCodecName compressionCodec) {
        this.jsonSchema = jsonSchema;
        this.compressionCodec = compressionCodec;
    }

    @Override
    @Nullable
    String getJsonSchema() {
        return this.jsonSchema;
    }

    @Override
    CompressionCodecName getCompressionCodec() {
        return this.compressionCodec;
    }

    public String toString() {
        return "Sink{jsonSchema=" + this.jsonSchema + ", compressionCodec=" + this.compressionCodec + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParquetIO.Sink) {
            ParquetIO.Sink that = (ParquetIO.Sink)o;
            return (this.jsonSchema == null ? that.getJsonSchema() == null : this.jsonSchema.equals(that.getJsonSchema())) && this.compressionCodec.equals((Object)that.getCompressionCodec());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.jsonSchema == null ? 0 : this.jsonSchema.hashCode();
        h$ *= 1000003;
        return h$ ^= this.compressionCodec.hashCode();
    }

    @Override
    ParquetIO.Sink.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ParquetIO.Sink.Builder {
        private String jsonSchema;
        private CompressionCodecName compressionCodec;

        Builder() {
        }

        private Builder(ParquetIO.Sink source) {
            this.jsonSchema = source.getJsonSchema();
            this.compressionCodec = source.getCompressionCodec();
        }

        @Override
        ParquetIO.Sink.Builder setJsonSchema(String jsonSchema) {
            this.jsonSchema = jsonSchema;
            return this;
        }

        @Override
        ParquetIO.Sink.Builder setCompressionCodec(CompressionCodecName compressionCodec) {
            if (compressionCodec == null) {
                throw new NullPointerException("Null compressionCodec");
            }
            this.compressionCodec = compressionCodec;
            return this;
        }

        @Override
        ParquetIO.Sink build() {
            String missing = "";
            if (this.compressionCodec == null) {
                missing = missing + " compressionCodec";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ParquetIO_Sink(this.jsonSchema, this.compressionCodec);
        }
    }
}

