/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Projections;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.mongodb.AutoValue_FindQuery;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@AutoValue
public abstract class FindQuery
implements SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> {
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized BsonDocument filters();

    @Pure
    abstract @UnknownKeyFor @NonNull @Initialized int limit();

    @Pure
    abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> projection();

    private static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_FindQuery.Builder().setLimit(0).setProjection(Collections.emptyList()).setFilters(new BsonDocument());
    }

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized FindQuery create() {
        return FindQuery.builder().build();
    }

    private @UnknownKeyFor @NonNull @Initialized FindQuery withFilters(@UnknownKeyFor @NonNull @Initialized BsonDocument filters) {
        return this.toBuilder().setFilters(filters).build();
    }

    static @UnknownKeyFor @NonNull @Initialized BsonDocument bson2BsonDocument(@UnknownKeyFor @NonNull @Initialized Bson filters) {
        return filters.toBsonDocument(BasicDBObject.class, MongoClientSettings.getDefaultCodecRegistry());
    }

    public @UnknownKeyFor @NonNull @Initialized FindQuery withFilters(@UnknownKeyFor @NonNull @Initialized Bson filters) {
        return this.withFilters(FindQuery.bson2BsonDocument(filters));
    }

    public @UnknownKeyFor @NonNull @Initialized FindQuery withLimit(@UnknownKeyFor @NonNull @Initialized int limit) {
        return this.toBuilder().setLimit(limit).build();
    }

    public @UnknownKeyFor @NonNull @Initialized FindQuery withProjection(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> projection) {
        Preconditions.checkArgument((projection != null ? 1 : 0) != 0, (Object)"projection can not be null");
        return this.toBuilder().setProjection(projection).build();
    }

    public @UnknownKeyFor @NonNull @Initialized MongoCursor<@UnknownKeyFor @NonNull @Initialized Document> apply(@UnknownKeyFor @NonNull @Initialized MongoCollection<@UnknownKeyFor @NonNull @Initialized Document> collection) {
        return collection.find().filter((Bson)this.filters()).limit(this.limit()).projection(Projections.include(this.projection())).iterator();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setFilters(@Nullable @UnknownKeyFor @Initialized BsonDocument var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setLimit(@UnknownKeyFor @NonNull @Initialized int var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setProjection(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized FindQuery build();
    }
}

